/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button;

import com.macrofocus.button.ButtonEvent;
import com.macrofocus.button.ButtonListener;
import com.macrofocus.button.ButtonModel;
import com.macrofocus.button.ButtonView;
import com.macrofocus.color.ColorModel;
import com.macrofocus.color.RGBColorModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.UIManager;

public class CenterButtonView
extends ButtonView {
    private int screenWidth;
    private int screenHeight;
    private final ButtonModel buttonModel;
    private int minimumWidth;
    private int minimumHeight;
    private int maximumWidth;
    private Color backgroundColor;
    private Color textColor = Color.white;
    private Font font = new Font("Helvetica", 0, 12);
    private String label;
    private final String name;

    public CenterButtonView(ButtonModel buttonModel, String label, PropertiesModel propertiesModel) {
        this(buttonModel, null, label, propertiesModel);
    }

    public CenterButtonView(final ButtonModel buttonModel, String name, String label, final PropertiesModel propertiesModel) {
        this.buttonModel = buttonModel;
        this.label = label;
        this.name = name;
        this.updateProperties(propertiesModel);
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                CenterButtonView.this.updateProperties(propertiesModel);
                CenterButtonView.this.repaint();
            }
        });
        this.setOpaque(true);
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading();
        if (label != null) {
            this.minimumWidth = fontMetrics.stringWidth(label.substring(0, 1));
            this.maximumWidth = fontMetrics.stringWidth(label);
        } else {
            this.minimumWidth = 0;
            this.maximumWidth = 0;
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CenterButtonView.this.updateScreenValues();
                CenterButtonView.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                buttonModel.setSelected(this);
            }
        });
        buttonModel.addButtonListener(new ButtonListener(){

            @Override
            public void buttonSelected(ButtonEvent e) {
            }

            @Override
            public void buttonStateChanged(ButtonEvent e) {
            }

            @Override
            public void buttonEnabledChanged(ButtonEvent e) {
            }
        });
    }

    public void setLabel(Object source, String label) {
        this.label = label;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.label != null) {
            Graphics2D g2 = (Graphics2D)g;
            Object antialiasing = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setFont(this.font);
            FontMetrics fontMetrics = g.getFontMetrics();
            g.setColor(this.textColor);
            int x = this.screenWidth < this.maximumWidth ? 0 : (this.screenWidth - this.maximumWidth) / 2;
            g.drawString(this.label, x, fontMetrics.getMaxAscent());
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialiasing);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    protected void updateScreenValues() {
        Dimension size = this.getSize();
        this.screenWidth = size.width;
        this.screenHeight = size.height;
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        this.backgroundColor = ((ColorModel)propertiesModel.getValue(this.getClass(), this.name, "backgroundColor", (Object)new RGBColorModel(119, 158, 209))).getColor();
        this.setBackground(this.backgroundColor);
        this.textColor = ((ColorModel)propertiesModel.getValue(this.getClass(), this.name, "textColor", (Object)new RGBColorModel(0, 0, 0))).getColor();
        Font font = UIManager.getFont("TableHeader.font");
        if (font != null) {
            this.font = font;
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[name=" + this.name + ",label=" + this.label + "]";
    }
}

