/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button;

import com.macrofocus.button.ButtonModel;
import com.macrofocus.button.ButtonView;
import com.macrofocus.color.ColorModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class FocusButtonView
extends ButtonView {
    private boolean _hasFocus = false;
    private int screenWidth;
    private int screenHeight;
    private final ButtonModel buttonModel;
    private final String label;
    private int minimumWidth;
    private int minimumHeight;
    private int maximumWidth;
    private Color backgroundColor;
    private Color textColor = Color.white;
    private static final Font font = new Font("Helvetica", 0, 12);

    public FocusButtonView(final ButtonModel buttonModel, String label, final PropertiesModel propertiesModel, Component parent) {
        this.buttonModel = buttonModel;
        this.label = label;
        this.updateProperties(propertiesModel);
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                FocusButtonView.this.updateProperties(propertiesModel);
                FocusButtonView.this.repaint();
            }
        });
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading();
        this.minimumWidth = fontMetrics.stringWidth(label.substring(0, 1));
        this.maximumWidth = fontMetrics.stringWidth(label);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FocusButtonView.this.updateScreenValues();
                FocusButtonView.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                buttonModel.setSelected(this);
            }
        });
        parent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    FocusButtonView.this._hasFocus = true;
                    FocusButtonView.this.repaint();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    FocusButtonView.this._hasFocus = false;
                    FocusButtonView.this.repaint();
                }
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this._hasFocus) {
            g.setColor(this.backgroundColor.darker());
            g.drawOval(3, 3, this.screenHeight - 6, this.screenHeight - 6);
        }
        g.setFont(font);
        FontMetrics fontMetrics = g.getFontMetrics();
        g.setColor(this.textColor);
        int x = this.screenWidth < this.maximumWidth ? 0 : (this.screenWidth - this.maximumWidth) / 2;
        g.drawString(this.label, x, fontMetrics.getMaxAscent());
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    protected void updateScreenValues() {
        Dimension size = this.getSize();
        this.screenWidth = size.width;
        this.screenHeight = size.height;
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        this.backgroundColor = ((ColorModel)propertiesModel.getValue(this.getClass(), "backgroundColor")).getColor();
        this.setBackground(this.backgroundColor);
        this.textColor = ((ColorModel)propertiesModel.getValue(this.getClass(), "textColor")).getColor();
    }
}

