/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button;

import java.awt.image.RGBImageFilter;

class HighlightFilter
extends RGBImageFilter {
    private int mode;

    public HighlightFilter(int mode) {
        this.canFilterIndexColorModel = true;
        this.mode = mode;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb >> 0 & 0xFF;
        switch (this.mode) {
            case 1: {
                g = 0;
                b = 0;
                break;
            }
            case 2: {
                r = 0;
                b = 0;
                break;
            }
            case 3: {
                r = 0;
                g = 0;
                break;
            }
            case 6: {
                int reference = 200;
                double shift = 0.5;
                int diff = r - reference;
                if (diff != 0) {
                    r -= diff / Math.abs(diff) * (int)(shift * (double)Math.abs(diff));
                }
                if ((diff = g - reference) != 0) {
                    g -= diff / Math.abs(diff) * (int)(shift * (double)Math.abs(diff));
                }
                if ((diff = b - reference) == 0) break;
                b -= diff / Math.abs(diff) * (int)(shift * (double)Math.abs(diff));
                break;
            }
            case 5: {
                r += 20;
                g += 20;
                b += 20;
                break;
            }
        }
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return rgb & 0xFF000000 | r << 16 | g << 8 | b << 0;
    }
}

