/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button;

import com.macrofocus.button.ButtonEvent;
import com.macrofocus.button.ButtonListener;
import com.macrofocus.button.ButtonModel;
import com.macrofocus.button.ButtonView;
import com.macrofocus.color.ColorModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class LeftButtonView
extends ButtonView {
    private int screenWidth;
    private int screenHeight;
    private final ButtonModel buttonModel;
    private int minimumWidth;
    private int minimumHeight;
    private int maximumWidth;
    private Color backgroundColor;
    private Color textColor = Color.white;
    private static final Font font = new Font("Helvetica", 0, 12);
    private String label;
    private final String name;

    public LeftButtonView(ButtonModel buttonModel, String label, PropertiesModel propertiesModel) {
        this(buttonModel, null, label, propertiesModel);
    }

    public LeftButtonView(final ButtonModel buttonModel, String name, String label, final PropertiesModel propertiesModel) {
        this.buttonModel = buttonModel;
        this.label = label;
        this.name = name;
        this.updateProperties(propertiesModel);
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                LeftButtonView.this.updateProperties(propertiesModel);
                LeftButtonView.this.repaint();
            }
        });
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading();
        this.minimumWidth = fontMetrics.stringWidth(label.substring(0, 1));
        this.maximumWidth = fontMetrics.stringWidth(label);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LeftButtonView.this.updateScreenValues();
                LeftButtonView.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                buttonModel.setSelected(this);
            }
        });
        buttonModel.addButtonListener(new ButtonListener(){

            @Override
            public void buttonSelected(ButtonEvent e) {
            }

            @Override
            public void buttonStateChanged(ButtonEvent e) {
            }

            @Override
            public void buttonEnabledChanged(ButtonEvent e) {
            }
        });
    }

    public void setLabel(Object source, String label) {
        this.label = label;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setFont(font);
        FontMetrics fontMetrics = g.getFontMetrics();
        g.setColor(this.textColor);
        int x = 0;
        g.drawString(this.label, x, fontMetrics.getMaxAscent());
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.maximumWidth, this.minimumHeight);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.maximumWidth, this.minimumHeight);
    }

    protected void updateScreenValues() {
        Dimension size = this.getSize();
        this.screenWidth = size.width;
        this.screenHeight = size.height;
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        this.backgroundColor = ((ColorModel)propertiesModel.getValue(this.getClass(), this.name, "backgroundColor")).getColor();
        this.setBackground(this.backgroundColor);
        this.textColor = ((ColorModel)propertiesModel.getValue(this.getClass(), this.name, "textColor")).getColor();
    }
}

