/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button;

import com.macrofocus.button.ButtonAdapter;
import com.macrofocus.button.ButtonEvent;
import com.macrofocus.button.ButtonModel;
import com.macrofocus.button.ButtonView;
import com.macrofocus.color.ColorModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.awt.DrawingTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class StateButtonView
extends ButtonView {
    private boolean _stateActive = false;
    private final int SHIFT = 10;
    private int screenWidth;
    private int screenHeight;
    private final ButtonModel buttonModel;
    private final String label;
    private int minimumWidth;
    private int minimumHeight;
    private int maximumWidth;
    private Color backgroundColor;
    private Color markerColor;
    private Color textColor = Color.white;
    private static final Font font = new Font("Helvetica", 0, 12);
    private final PropertiesModel propertiesModel;

    public StateButtonView(final ButtonModel buttonModel, String label, final PropertiesModel propertiesModel) {
        this.buttonModel = buttonModel;
        this.label = label;
        this.propertiesModel = propertiesModel;
        this.updateProperties(propertiesModel);
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                StateButtonView.this.updateProperties(propertiesModel);
                StateButtonView.this.repaint();
            }
        });
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading();
        this.minimumWidth = fontMetrics.stringWidth(label.substring(0, 1));
        this.maximumWidth = fontMetrics.stringWidth(label) + 10;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                StateButtonView.this.updateScreenValues();
                StateButtonView.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                buttonModel.setSelected(this);
            }
        });
        buttonModel.addButtonListener(new ButtonAdapter(){

            @Override
            public void buttonSelected(ButtonEvent e) {
                StateButtonView.this.repaint();
            }

            @Override
            public void buttonStateChanged(ButtonEvent event) {
                StateButtonView.this.repaint();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.buttonModel.isStateOn()) {
            g.setColor(this.backgroundColor);
            DrawingTools.drawThin3DRect(2, 2, 6, this.screenHeight - 4, false, g, this.backgroundColor);
        } else {
            g.setColor(this.backgroundColor);
            DrawingTools.drawThin3DRect(2, 2, 6, this.screenHeight - 4, true, g, this.backgroundColor);
            g.setColor(this.markerColor);
            g.fillRect(4, 4, 2, this.screenHeight - 8);
        }
        g.setFont(font);
        FontMetrics fontMetrics = g.getFontMetrics();
        g.setColor(this.textColor);
        int x = this.screenWidth < this.maximumWidth ? 0 : (this.screenWidth - this.maximumWidth - 10) / 2;
        g.drawString(this.label, x + 10, fontMetrics.getMaxAscent());
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.maximumWidth, this.minimumHeight);
    }

    protected void updateScreenValues() {
        Dimension size = this.getSize();
        this.screenWidth = size.width;
        this.screenHeight = size.height;
    }

    public void setBackgroundColor(Color background_color) {
        this.backgroundColor = background_color;
        this.setBackground(this.backgroundColor);
    }

    public void setTextColor(Color text_color) {
        this.textColor = text_color;
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        this.backgroundColor = ((ColorModel)propertiesModel.getValue(this.getClass(), "backgroundColor")).getColor();
        this.setBackground(this.backgroundColor);
        this.textColor = ((ColorModel)propertiesModel.getValue(this.getClass(), "textColor")).getColor();
        this.markerColor = ((ColorModel)propertiesModel.getValue(this.getClass(), "markerColor")).getColor();
    }

    protected int getMaximumWidth() {
        return this.maximumWidth;
    }

    protected Color getBackgroundColor() {
        return this.backgroundColor;
    }
}

