/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button.state;

import com.macrofocus.button.state.StateButtonEvent;
import com.macrofocus.button.state.StateButtonListener;
import com.macrofocus.button.state.StateButtonModel;
import java.util.Enumeration;
import java.util.Vector;

public class SimpleStateButtonModel
implements StateButtonModel {
    private final int stateCount;
    private int state;
    private final Vector stateButtonListeners;

    public SimpleStateButtonModel(int stateCount) {
        this(stateCount, 0);
    }

    public SimpleStateButtonModel(int stateCount, int state) {
        this.stateCount = stateCount;
        this.state = state;
        this.stateButtonListeners = new Vector();
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void setState(Object source, int state) {
        int oldState = this.state;
        this.state = state >= this.getStateCount() ? this.getStateCount() - 1 : (state < 0 ? 0 : state);
        if (this.state != oldState) {
            this.fireStateButtonChanged(new StateButtonEvent(source, this));
        }
    }

    @Override
    public int getStateCount() {
        return this.stateCount;
    }

    @Override
    public void incrementState(Object source) {
        ++this.state;
        if (this.state >= this.getStateCount()) {
            this.state = 0;
        }
        this.fireStateButtonChanged(new StateButtonEvent(source, this));
    }

    @Override
    public void decrementState(Object source) {
        --this.state;
        if (this.state < 0) {
            this.state = this.getStateCount() - 1;
        }
        this.fireStateButtonChanged(new StateButtonEvent(source, this));
    }

    @Override
    public void addStateButtonListener(StateButtonListener listener) {
        this.stateButtonListeners.addElement(listener);
    }

    @Override
    public void removeStateButtonListener(StateButtonListener listener) {
        this.stateButtonListeners.removeElement(listener);
    }

    private void fireStateButtonChanged(StateButtonEvent event) {
        Enumeration enumeration = this.stateButtonListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((StateButtonListener)enumeration.nextElement()).stateButtonChanged(event);
        }
    }
}

