/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button.state;

import com.macrofocus.button.state.StateButtonEvent;
import com.macrofocus.button.state.StateButtonListener;
import com.macrofocus.button.state.StateButtonModel;
import com.macrofocus.button.state.StateButtonView;
import com.macrofocus.color.ColorModel;
import com.macrofocus.color.RGBColorModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;

public class TwoStateButtonView
extends StateButtonView {
    private final StateButtonModel stateButtonModel;
    private final String name;
    private Color backgroundColor;
    private Color markerColor;

    public TwoStateButtonView(StateButtonModel stateButtonModel, PropertiesModel propertiesModel) {
        this(null, stateButtonModel, propertiesModel);
    }

    public TwoStateButtonView(String name, StateButtonModel stateButtonModel, final PropertiesModel propertiesModel) {
        this.stateButtonModel = stateButtonModel;
        this.name = name;
        this.updateProperties(propertiesModel);
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                TwoStateButtonView.this.updateProperties(propertiesModel);
                TwoStateButtonView.this.repaint();
            }
        });
        stateButtonModel.addStateButtonListener(new StateButtonListener(){

            @Override
            public void stateButtonChanged(StateButtonEvent e) {
                TwoStateButtonView.this.repaint();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        Object antialiasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension d = this.getSize();
        int center = (d.height - 1) / 2;
        int top = 2;
        int bottom = d.height - 3;
        int left = 2;
        int right = d.width - 3;
        g.setColor(this.backgroundColor.brighter());
        g.drawLine(0, 0, 0, d.height - 1);
        g.drawLine(0, 0, d.width - 2, 0);
        g.setColor(this.backgroundColor.darker());
        g.drawLine(d.width - 1, 0, d.width - 1, d.height - 1);
        g.drawLine(1, d.height - 1, d.width - 1, d.height - 1);
        g.setColor(this.markerColor);
        if (this.stateButtonModel.getState() < this.stateButtonModel.getStateCount() - 1) {
            Polygon polygon = new Polygon();
            polygon.addPoint(left, center);
            polygon.addPoint(right, top);
            polygon.addPoint(right, bottom);
            g.fillPolygon(polygon);
        } else {
            Polygon polygon = new Polygon();
            polygon.addPoint(left + 1, top + 1);
            polygon.addPoint(left + 1, bottom - 1);
            polygon.addPoint(right, center);
            g.fillPolygon(polygon);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        this.backgroundColor = ((ColorModel)propertiesModel.getValue(this.getClass(), this.name, "backgroundColor", (Object)new RGBColorModel(150, 180, 220))).getColor();
        this.setBackground(this.backgroundColor);
        this.markerColor = ((ColorModel)propertiesModel.getValue(this.getClass(), this.name, "markerColor", (Object)new RGBColorModel(255, 255, 0))).getColor();
    }
}

