/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.drawing.axis;

import com.macrofocus.drawing.axis.AxisEvent;
import com.macrofocus.drawing.axis.AxisListener;
import com.macrofocus.drawing.axis.AxisModel;
import com.macrofocus.drawing.coordinate.CoordinateEvent;
import com.macrofocus.drawing.coordinate.CoordinateListener;
import com.macrofocus.drawing.coordinate.CoordinateSystemModel;
import java.util.Enumeration;
import java.util.Vector;

public class SimpleAxisModel
implements AxisModel {
    private CoordinateSystemModel coordinateSystemModel;
    private double[] tickValues = new double[0];
    private double fullRangeMin;
    private double fullRangeMax;
    private Vector axisListeners = new Vector();
    private static final boolean debug = false;

    @Override
    public double[] getTickValues() {
        return this.tickValues;
    }

    @Override
    public int getNumberOfTicks() {
        return this.tickValues.length;
    }

    private void computeTickMarks() {
        if (this.coordinateSystemModel == null) {
            this.tickValues = new double[0];
            return;
        }
        double minValue = this.coordinateSystemModel.getWorldMinY();
        double maxValue = this.coordinateSystemModel.getWorldMaxY();
        double range = maxValue - minValue;
        double step_size = this.roundUpTo_2_5_10(range / 10.0);
        double start_value = Math.ceil(minValue / step_size) * step_size;
        int number_of_values = (int)((maxValue - start_value) / step_size) + 1;
        this.tickValues = new double[number_of_values];
        for (int i = 0; i < number_of_values; ++i) {
            this.tickValues[i] = start_value + (double)i * step_size;
        }
    }

    private double roundUpTo_2_5_10(double value) {
        int exponent;
        double _LOG10SCALE = 1.0 / Math.log(10.0);
        if ((value *= Math.pow(10.0, -(exponent = (int)Math.floor(Math.log(value) * _LOG10SCALE)))) > 5.0) {
            value = 10.0;
        } else if (value > 2.0) {
            value = 5.0;
        } else if (value > 1.0) {
            value = 2.0;
        }
        return value *= Math.pow(10.0, exponent);
    }

    @Override
    public void setCoordinateSystemModel(CoordinateSystemModel coordinateSystemModel) {
        this.coordinateSystemModel = coordinateSystemModel;
        final SimpleAxisModel axis_model = this;
        this.coordinateSystemModel.addCoordinateListener(new CoordinateListener(){

            @Override
            public void xRangeChanged(CoordinateEvent e) {
            }

            @Override
            public void yRangeChanged(CoordinateEvent e) {
                SimpleAxisModel.this.computeTickMarks();
                SimpleAxisModel.this.fireRangeChanged(new AxisEvent(this, axis_model));
            }
        });
        this.fireRangeChanged(new AxisEvent(this, axis_model));
    }

    @Override
    public CoordinateSystemModel getCoordinateSystemModel() {
        return this.coordinateSystemModel;
    }

    @Override
    public void setFullRange(double min, double max) {
        this.fullRangeMin = min;
        this.fullRangeMax = max;
        this.fireFullRangeChanged(new AxisEvent(this, this));
    }

    @Override
    public double getFullRangeMin() {
        return this.fullRangeMin;
    }

    @Override
    public double getFullRangeMax() {
        return this.fullRangeMax;
    }

    private void fireRangeChanged(AxisEvent event) {
        Enumeration enumeration = this.axisListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((AxisListener)enumeration.nextElement()).rangeChanged(event);
        }
    }

    private void fireFullRangeChanged(AxisEvent event) {
        Enumeration enumeration = this.axisListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((AxisListener)enumeration.nextElement()).fullRangeChanged(event);
        }
    }

    @Override
    public void addAxisListener(AxisListener listener) {
        this.axisListeners.addElement(listener);
    }

    @Override
    public void removeAxisListener(AxisListener listener) {
        this.axisListeners.removeElement(listener);
    }
}

