/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.graphic;

import com.macrofocus.color.ColormapModel;
import com.macrofocus.color.SimpleColormapModel;
import com.macrofocus.graphic.AbstractGraphicModel;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

public final class IndexedGraphicModel
extends AbstractGraphicModel {
    private final int height;
    private final int width;
    private final byte[] byteBuffer;
    private final MemoryImageSource memoryImageSource;
    private Image memoryImage;
    private final Component component;
    private final ColormapModel colormapModel;

    public IndexedGraphicModel(Component component, byte[] r, byte[] g, byte[] b, int width, int height) {
        this.width = width;
        this.height = height;
        this.byteBuffer = new byte[width * height];
        this.component = component;
        this.colormapModel = new SimpleColormapModel(r, g, b);
        IndexColorModel icm = new IndexColorModel(8, r.length, r, g, b, 0);
        this.memoryImageSource = new MemoryImageSource(width, height, (ColorModel)icm, this.byteBuffer, 0, width);
        this.memoryImageSource.setAnimated(true);
        this.memoryImage = component.createImage(this.memoryImageSource);
    }

    public IndexedGraphicModel(Component component, byte[] r, byte[] g, byte[] b, byte[] a, int width, int height) {
        this.width = width;
        this.height = height;
        this.byteBuffer = new byte[width * height];
        this.component = component;
        this.colormapModel = new SimpleColormapModel(r, g, b, a);
        IndexColorModel icm = new IndexColorModel(8, r.length, r, g, b, a);
        this.memoryImageSource = new MemoryImageSource(width, height, (ColorModel)icm, this.byteBuffer, 0, width);
        this.memoryImageSource.setAnimated(true);
        this.memoryImage = component.createImage(this.memoryImageSource);
    }

    public IndexedGraphicModel(Component component, ColormapModel colormapModel, int width, int height) {
        this.width = width;
        this.height = height;
        this.byteBuffer = new byte[width * height];
        this.component = component;
        this.colormapModel = colormapModel;
        byte[] r = new byte[colormapModel.getColorCount()];
        byte[] g = new byte[colormapModel.getColorCount()];
        byte[] b = new byte[colormapModel.getColorCount()];
        byte[] a = new byte[colormapModel.getColorCount()];
        for (int i = 0; i < colormapModel.getColorCount(); ++i) {
            r[i] = (byte)colormapModel.getColorModel(i).getRed();
            g[i] = (byte)colormapModel.getColorModel(i).getGreen();
            b[i] = (byte)colormapModel.getColorModel(i).getBlue();
            a[i] = (byte)colormapModel.getColorModel(i).getAlpha();
        }
        IndexColorModel icm = new IndexColorModel(8, r.length, r, g, b, a);
        this.memoryImageSource = new MemoryImageSource(width, height, (ColorModel)icm, this.byteBuffer, 0, width);
        this.memoryImageSource.setAnimated(true);
        this.memoryImage = component.createImage(this.memoryImageSource);
    }

    @Override
    public final void drawPoint(int x, int y, int color) {
        if (x < 0) {
            return;
        }
        if (x >= this.width) {
            return;
        }
        if (y < 0) {
            return;
        }
        if (y >= this.height) {
            return;
        }
        this.byteBuffer[(this.height - 1 - y) * this.width + x] = (byte)color;
    }

    @Override
    public final void drawBitmap(byte[] bit_map, int bit_map_width, int bit_map_height, int x, int y) {
        for (int i = 0; i < bit_map_height; ++i) {
            System.arraycopy(bit_map, i * bit_map_width, this.byteBuffer, (this.height - 1 - (y + i)) * this.width + x, bit_map_width);
        }
    }

    @Override
    public final void clearImage(int color) {
        int size = this.byteBuffer.length - 1;
        int index = 1;
        this.byteBuffer[0] = (byte)color;
        for (int cleared = 1; cleared < size; cleared <<= 1) {
            System.arraycopy(this.byteBuffer, 0, this.byteBuffer, index, cleared);
            size -= cleared;
            index += cleared;
        }
        System.arraycopy(this.byteBuffer, 0, this.byteBuffer, index, size);
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final Image getImage() {
        return this.memoryImage;
    }

    @Override
    public final void newPixels() {
        this.memoryImageSource.newPixels();
    }

    @Override
    public final void dispose() {
        this.memoryImage.flush();
    }

    public final int getRed(int x, int y) {
        return this.colormapModel.getColorModel(this.byteBuffer[(this.height - 1 - y) * this.width + x] + 256).getRed();
    }

    public final int getGreen(int x, int y) {
        return this.colormapModel.getColorModel(this.byteBuffer[(this.height - 1 - y) * this.width + x] + 256).getGreen();
    }

    public final int getBlue(int x, int y) {
        return this.colormapModel.getColorModel(this.byteBuffer[(this.height - 1 - y) * this.width + x] + 256).getBlue();
    }

    public final int getAlpha(int x, int y) {
        return 255;
    }

    @Override
    public final ColormapModel getColormapModel() {
        return this.colormapModel;
    }
}

