/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.graphic;

import com.macrofocus.color.ColorModel;
import com.macrofocus.color.ColormapModel;
import com.macrofocus.color.SimpleColormapModel;
import com.macrofocus.graphic.AbstractDirectGraphicModel;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public final class OpaqueGraphicModel
extends AbstractDirectGraphicModel {
    private final int height;
    private final int width;
    private final int[] intBuffer;
    private final ColormapModel colormapModel;
    private final MemoryImageSource memoryImageSource;
    private final Image memoryImage;
    private final java.awt.image.ColorModel cm;

    public OpaqueGraphicModel(Component component, int[] r, int[] g, int[] b, int[] a, int width, int height) {
        this(component, (ColormapModel)new SimpleColormapModel(r, g, b, a), width, height);
    }

    public OpaqueGraphicModel(Component component, ColormapModel colormapModel, int width, int height) {
        this(component, colormapModel, 0, width, height);
    }

    public OpaqueGraphicModel(Component component, ColormapModel colormapModel, int alphaThreshold, int width, int height) {
        this.width = width;
        this.height = height;
        this.colormapModel = colormapModel;
        this.intBuffer = new int[width * height];
        this.cm = java.awt.image.ColorModel.getRGBdefault();
        this.memoryImageSource = new MemoryImageSource(width, height, this.cm, this.intBuffer, 0, width);
        this.memoryImageSource.setAnimated(true);
        this.memoryImage = component.createImage(this.memoryImageSource);
    }

    @Override
    public void drawPoint(int x, int y, ColorModel colorModel) {
        if (x < 0) {
            return;
        }
        if (x >= this.width - 1) {
            return;
        }
        if (y < 0) {
            return;
        }
        if (y >= this.height - 1) {
            return;
        }
        this.intBuffer[(this.height - 1 - y) * this.width + x] = colorModel.getRGBA();
    }

    @Override
    public void drawPoint(int x, int y, int direct_color) {
        if (x < 0) {
            return;
        }
        if (x >= this.width - 1) {
            return;
        }
        if (y < 0) {
            return;
        }
        if (y >= this.height - 1) {
            return;
        }
        this.intBuffer[(this.height - 1 - y) * this.width + x] = direct_color;
    }

    @Override
    public void drawBitmap(byte[] bit_map, int bit_map_width, int bit_map_height, int x, int y) {
        for (int i = 0; i < bit_map_height; ++i) {
            System.arraycopy(bit_map, i * bit_map_width, this.intBuffer, (this.height - 1 - (y + i)) * this.width + x, bit_map_width);
        }
    }

    @Override
    public void clearImage(ColorModel colorModel) {
        int size = this.intBuffer.length - 1;
        int index = 1;
        this.intBuffer[0] = 0xFF000000 | colorModel.getRGB() & 0xFFFFFF;
        for (int cleared = 1; cleared < size; cleared <<= 1) {
            System.arraycopy(this.intBuffer, 0, this.intBuffer, index, cleared);
            size -= cleared;
            index += cleared;
        }
        System.arraycopy(this.intBuffer, 0, this.intBuffer, index, size);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Image getImage() {
        return this.memoryImage;
    }

    public int getRed(int x, int y) {
        return this.cm.getRed(this.intBuffer[(this.height - 1 - y) * this.width + x]);
    }

    public int getGreen(int x, int y) {
        return this.cm.getGreen(this.intBuffer[(this.height - 1 - y) * this.width + x]);
    }

    public int getBlue(int x, int y) {
        return this.cm.getBlue(this.intBuffer[(this.height - 1 - y) * this.width + x]);
    }

    public int getAlpha(int x, int y) {
        return 255;
    }

    @Override
    public ColormapModel getColormapModel() {
        return this.colormapModel;
    }

    @Override
    public void newPixels() {
        this.memoryImageSource.newPixels();
    }

    @Override
    public void dispose() {
        this.memoryImage.flush();
    }
}

