/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.adapter;

import com.macrofocus.math.stat.Histogram;
import com.macrofocus.slider.AbstractRangeSliderModel;
import com.macrofocus.slider.RangeSliderEvent;
import com.macrofocus.slider.RangeSliderListener;
import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.util.range.MBoundedRangeEvent;
import com.macrofocus.util.range.MBoundedRangeListener;
import com.macrofocus.util.range.MBoundedRangeModel;
import java.util.Enumeration;
import java.util.Vector;

public class MBoundedRangeRangeSliderAdapter
extends AbstractRangeSliderModel {
    private MBoundedRangeModel boundedRangeModel;
    private double minExtentFactor;
    private double maxExtentFactor;
    private double lowerMinimumValue;
    private double lowerMaximumValue;
    private double upperMinimumValue;
    private double upperMaximumValue;
    private boolean lowerMinimumEnabled = false;
    private boolean lowerMaximumEnabled = false;
    private boolean upperMinimumEnabled = false;
    private boolean upperMaximumEnabled = false;
    private Vector sliderListeners;
    private Histogram histogram;
    private MBoundedRangeListener listener = new MBoundedRangeListener(){

        public void boundedRangeChanged(MBoundedRangeEvent event) {
            MBoundedRangeRangeSliderAdapter.this.notifySliderChanged(new RangeSliderEvent(MBoundedRangeRangeSliderAdapter.this.getSelf(), event.getSource(), MBoundedRangeRangeSliderAdapter.this.getCurrentMinimum(), MBoundedRangeRangeSliderAdapter.this.getCurrentMaximum(), 0.0, 0.0));
        }
    };
    private ResetStrategy resetStrategy = new ResetStrategy(){

        @Override
        public void reset() {
            MBoundedRangeRangeSliderAdapter.this.setValues(this, MBoundedRangeRangeSliderAdapter.this.boundedRangeModel.getMinimum(), MBoundedRangeRangeSliderAdapter.this.boundedRangeModel.getMaximum());
        }
    };

    public MBoundedRangeRangeSliderAdapter(MBoundedRangeModel boundedRangeModel) {
        this(boundedRangeModel, 0.0, 1.0);
    }

    public MBoundedRangeRangeSliderAdapter(MBoundedRangeModel boundedRangeModel, double minExtentFactor, double maxExtentFactor) {
        this.boundedRangeModel = boundedRangeModel;
        this.minExtentFactor = minExtentFactor;
        this.maxExtentFactor = maxExtentFactor;
        boundedRangeModel.addBoundedRangeListener(this.listener);
        this.sliderListeners = new Vector();
    }

    private RangeSliderModel getSelf() {
        return this;
    }

    public void setValues(Object source, double rangeMin, double rangeMax) {
        this.boundedRangeModel.setValue(source, rangeMin, rangeMax - rangeMin);
    }

    public double getCurrentExtent() {
        return this.boundedRangeModel.getExtent();
    }

    public double getCurrentMinimum() {
        return this.boundedRangeModel.getValue();
    }

    public double getCurrentMaximum() {
        return this.boundedRangeModel.getValue() + this.boundedRangeModel.getExtent();
    }

    public double getMinimum() {
        return this.boundedRangeModel.getMinimum();
    }

    public double getMaximum() {
        return this.boundedRangeModel.getMaximum();
    }

    public void setMinMax(Object source, double min, double max) {
        this.boundedRangeModel.setMinMax(source, min, max);
    }

    public void setMinimum(Object source, double min) {
        this.boundedRangeModel.setMinimum(source, min);
    }

    public void setMaximum(Object source, double max) {
        this.boundedRangeModel.setMaximum(source, max);
    }

    public double getExtent() {
        return Math.max(this.getMinimum(), this.getMaximum()) - Math.min(this.getMinimum(), this.getMaximum());
    }

    public double getLowerMinimumValue() {
        if (this.lowerMinimumEnabled) {
            return this.lowerMinimumValue;
        }
        return this.getMinimum();
    }

    public void setLowerMinimumValue(double lowerMinimumValue) {
        this.lowerMinimumValue = lowerMinimumValue;
        this.lowerMinimumEnabled = true;
    }

    public double getLowerMaximumValue() {
        if (this.lowerMaximumEnabled) {
            return this.lowerMaximumValue;
        }
        return this.getMaximum();
    }

    public void setLowerMaximumValue(double lowerMaximumValue) {
        this.lowerMaximumValue = lowerMaximumValue;
        this.lowerMaximumEnabled = true;
    }

    public double getUpperMinimumValue() {
        if (this.upperMinimumEnabled) {
            return this.upperMinimumValue;
        }
        return this.getMinimum();
    }

    public void setUpperMinimumValue(double upperMinimumValue) {
        this.upperMinimumValue = upperMinimumValue;
        this.upperMinimumEnabled = true;
    }

    public double getUpperMaximumValue() {
        if (this.upperMaximumEnabled) {
            return this.upperMaximumValue;
        }
        return this.getMaximum();
    }

    public void setUpperMaximumValue(double upperMaximumValue) {
        this.upperMaximumValue = upperMaximumValue;
        this.upperMaximumEnabled = true;
    }

    public void setLowerMinimumEnabled(boolean lowerMinimumEnabled) {
        this.lowerMinimumEnabled = lowerMinimumEnabled;
    }

    public void setLowerMaximumEnabled(boolean lowerMaximumEnabled) {
        this.lowerMaximumEnabled = lowerMaximumEnabled;
    }

    public void setUpperMinimumEnabled(boolean upperMinimumEnabled) {
        this.upperMinimumEnabled = upperMinimumEnabled;
    }

    public void setUpperMaximumEnabled(boolean upperMaximumEnabled) {
        this.upperMaximumEnabled = upperMaximumEnabled;
    }

    public void reset(Object source) {
        this.resetStrategy.reset();
    }

    public double getMaximumExtent() {
        if (this.maxExtentFactor == 0.0) {
            return Double.MAX_VALUE;
        }
        return (this.boundedRangeModel.getMaximum() - this.boundedRangeModel.getMinimum()) / this.maxExtentFactor;
    }

    public double getMinimumExtent() {
        if (this.minExtentFactor == 0.0) {
            return 0.0;
        }
        return (this.boundedRangeModel.getMaximum() - this.boundedRangeModel.getMinimum()) / this.minExtentFactor;
    }

    public void setBoundedRangeModel(MBoundedRangeModel boundedRangeModel) {
        if (this.boundedRangeModel != null) {
            this.boundedRangeModel.removeBoundedRangeListener(this.listener);
        }
        this.boundedRangeModel = boundedRangeModel;
        if (this.boundedRangeModel == null) {
            throw new RuntimeException("Debug: Null range model");
        }
        RangeSliderEvent eventRange = new RangeSliderEvent((RangeSliderModel)this, (Object)this, boundedRangeModel.getMinimum(), boundedRangeModel.getMaximum(), this.boundedRangeModel.getMinimum(), this.boundedRangeModel.getMaximum());
        this.boundedRangeModel.addBoundedRangeListener(this.listener);
        this.notifySliderScaleChanged(eventRange);
    }

    public void addSliderListener(RangeSliderListener rangeSliderListener) {
        this.sliderListeners.addElement(rangeSliderListener);
    }

    public void removeSliderListener(RangeSliderListener rangeSliderListener) {
        this.sliderListeners.removeElement(rangeSliderListener);
    }

    private void notifySliderChanged(RangeSliderEvent eventRange) {
        Enumeration enumeration = this.sliderListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((RangeSliderListener)enumeration.nextElement()).sliderChanged(eventRange);
        }
    }

    private void notifySliderScaleChanged(RangeSliderEvent eventRange) {
        Enumeration enumeration = this.sliderListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((RangeSliderListener)enumeration.nextElement()).sliderScaleChanged(eventRange);
        }
    }

    public String toString() {
        return this.boundedRangeModel.toString();
    }

    public boolean isInvertedScale() {
        return this.boundedRangeModel.getMinimum() > this.boundedRangeModel.getMaximum();
    }

    public void setResetStrategy(ResetStrategy resetStrategy) {
        this.resetStrategy = resetStrategy;
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public void setHistogram(Histogram histogram) {
        this.histogram = histogram;
    }

    public static interface ResetStrategy {
        public void reset();
    }
}

