/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.soom.lens.coordinate;

import com.macrofocus.soom.lens.coordinate.CoordinateAxisEvent;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisListener;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisModel;
import com.macrofocus.soom.lens.zoom.ZoomStrategy;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractCoordinateAxisModel
implements CoordinateAxisModel {
    private ZoomStrategy zoomStrategy = null;
    private boolean invertDeviceCoordinates = false;
    private boolean invertWorldCoordinates = false;
    private final List<CoordinateAxisListener> coordinateAxisListeners = new CopyOnWriteArrayList<CoordinateAxisListener>();

    protected AbstractCoordinateAxisModel() {
    }

    public AbstractCoordinateAxisModel(ZoomStrategy zoomStrategy, boolean invertDeviceCoordinates, boolean invertWorldCoordinates) {
        this();
        this.zoomStrategy = zoomStrategy;
        this.invertDeviceCoordinates = invertDeviceCoordinates;
        this.invertWorldCoordinates = invertWorldCoordinates;
    }

    @Override
    public void setDeviceCoordinatesInverted(boolean invertDeviceCoordinates) {
        this.invertDeviceCoordinates = invertDeviceCoordinates;
        this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.Screen));
    }

    @Override
    public void setWorldCoordinatesInverted(boolean invertWorldCoordinates) {
        this.invertWorldCoordinates = invertWorldCoordinates;
        this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.World));
    }

    @Override
    public boolean getDeviceCoordinatesInverted() {
        return this.invertDeviceCoordinates;
    }

    @Override
    public boolean getWorldCoordinatesInverted() {
        return this.invertWorldCoordinates;
    }

    @Override
    public void setZoomStrategy(ZoomStrategy zoomStrategy) {
        this.zoomStrategy = zoomStrategy;
        this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.Zoom));
    }

    @Override
    public ZoomStrategy getZoomStrategy() {
        return this.zoomStrategy;
    }

    @Override
    public abstract int getScreenSize();

    @Override
    public abstract double getWorldMin();

    @Override
    public abstract double getWorldMax();

    @Override
    public abstract double getWorldRange();

    @Override
    public double screenToWorld(int x) {
        double x_viewport = this.screenToViewport(x);
        double x_normalized = this.viewportToNormalized(x_viewport);
        double x_zoomed = this.zoomStrategy != null ? this.zoomStrategy.zoomedToNormalized(x_normalized) : x_normalized;
        return this.normalizedToWorld(x_zoomed);
    }

    @Override
    public int worldToScreen(double x) {
        return this.normalizedToScreen(this.worldToNormalized(x));
    }

    @Override
    public int normalizedToScreen(double x_normalized) {
        double x_viewport = this.normalizedToViewport(x_normalized);
        return this.viewportToScreen(x_viewport);
    }

    @Override
    public double worldToNormalized(double x) {
        return (x - this.getWorldMin()) / this.getWorldRange();
    }

    @Override
    public double normalizedToWorld(double x) {
        return x * this.getWorldRange() + this.getWorldMin();
    }

    @Override
    public double normalizedToViewport(double x_normalized) {
        x_normalized = (x_normalized - this.getViewportMin()) / this.getViewportRange();
        double x_zoomed = this.zoomStrategy != null ? this.zoomStrategy.normalizedToZoomed(x_normalized) : x_normalized;
        if (this.invertWorldCoordinates) {
            x_zoomed = 1.0 - x_zoomed;
        }
        return x_zoomed;
    }

    @Override
    public abstract double getViewportRange();

    @Override
    public abstract double getViewportMin();

    @Override
    public abstract double getViewportMax();

    @Override
    public double viewportToNormalized(double viewport) {
        if (this.zoomStrategy != null) {
            viewport = this.zoomStrategy.zoomedToNormalized(viewport);
        }
        double normalized = viewport * this.getViewportRange() + this.getViewportMin();
        if (this.invertWorldCoordinates) {
            normalized = 1.0 - normalized;
        }
        return normalized;
    }

    @Override
    public int viewportToScreen(double x_viewport) {
        if (this.invertDeviceCoordinates) {
            x_viewport = 1.0 - x_viewport;
        }
        return (int)(x_viewport * (double)(this.getScreenSize() - 1));
    }

    @Override
    public double screenToViewport(int x_screen) {
        double x_viewport = (double)x_screen / (double)(this.getScreenSize() - 1);
        if (this.invertDeviceCoordinates) {
            x_viewport = 1.0 - x_viewport;
        }
        return x_viewport;
    }

    public String toString() {
        return this.getClass().getName() + "[screenSize=" + this.getScreenSize() + ",worldMin=" + this.getWorldMin() + ",worldMax=" + this.getWorldMax() + "]";
    }

    @Override
    public void addCoordinateListener(CoordinateAxisListener listener) {
        this.coordinateAxisListeners.add(listener);
    }

    @Override
    public void addWeakCoordinateListener(CoordinateAxisListener listener) {
        this.coordinateAxisListeners.add(new WeakCoordinateAxisListener(listener));
    }

    @Override
    public void removeCoordinateListener(CoordinateAxisListener listener) {
        this.coordinateAxisListeners.remove(listener);
    }

    protected void fireRangeChanged(CoordinateAxisEvent event) {
        for (CoordinateAxisListener coordinateAxisListener : this.coordinateAxisListeners) {
            coordinateAxisListener.rangeChanged(event);
        }
    }

    private class WeakCoordinateAxisListener
    implements CoordinateAxisListener {
        private final WeakReference<CoordinateAxisListener> l_ref;

        public WeakCoordinateAxisListener(CoordinateAxisListener listener) {
            this.l_ref = new WeakReference<CoordinateAxisListener>(listener);
        }

        @Override
        public void rangeChanged(CoordinateAxisEvent event) {
            CoordinateAxisListener l = (CoordinateAxisListener)this.l_ref.get();
            if (l != null) {
                l.rangeChanged(event);
            } else {
                AbstractCoordinateAxisModel.this.removeCoordinateListener(this);
            }
        }
    }
}

