/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.soom.lens.coordinate;

import com.macrofocus.soom.lens.coordinate.CoordinateAxisModel;
import java.awt.geom.AffineTransform;

public class CoordinateAxisHelper {
    public static AffineTransform worldToScreen(CoordinateAxisModel xModel, CoordinateAxisModel yModel) {
        if (yModel.getWorldCoordinatesInverted()) {
            double xs = (double)xModel.getScreenSize() / xModel.getWorldRange();
            double ys = (double)yModel.getScreenSize() / yModel.getWorldRange();
            AffineTransform at = new AffineTransform();
            at.setToScale(xs, ys);
            at.translate(-xModel.getWorldMin(), -yModel.getWorldMin());
            return at;
        }
        double xs = (double)xModel.getScreenSize() / xModel.getWorldRange();
        double ys = (double)yModel.getScreenSize() / yModel.getWorldRange();
        double tx = -xModel.getWorldMin() * xs;
        double ty = yModel.getWorldMin() * ys + (double)yModel.getScreenSize();
        AffineTransform at = new AffineTransform(xs, 0.0, 0.0, -ys, tx, ty);
        return at;
    }
}

