/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.soom.lens.zoom;

import com.macrofocus.soom.lens.zoom.ZoomEvent;
import com.macrofocus.soom.lens.zoom.ZoomListener;
import com.macrofocus.soom.lens.zoom.ZoomStrategy;
import java.util.Vector;

public class BifocalLensZoom
implements ZoomStrategy {
    private double focusPositionNormalized = 0.5;
    private double focusSizeNormalized = 0.0;
    private double zoomFactor;
    private double compressionFactor;
    final double[] windowBoundaries = new double[4];
    private final Vector zoomListeners;

    public BifocalLensZoom() {
        this.computeWindowBoundaries();
        this.zoomListeners = new Vector();
    }

    public void setZoomFactor(double zoomFactor) {
        if (zoomFactor == this.zoomFactor) {
            return;
        }
        this.zoomFactor = this.focusSizeNormalized * zoomFactor > 1.0 ? 1.0 / this.focusSizeNormalized : zoomFactor;
        this.computeCompressionFactor();
        this.computeWindowBoundaries();
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    public void setParameters(double focusPositionNormalized, double focusSizeNormalized, double zoomFactor) {
        if (focusPositionNormalized == this.focusPositionNormalized && focusSizeNormalized == this.focusSizeNormalized && zoomFactor == this.zoomFactor) {
            return;
        }
        this.focusPositionNormalized = focusPositionNormalized - focusSizeNormalized / 2.0 < 0.0 ? focusSizeNormalized / 2.0 : (focusPositionNormalized + focusSizeNormalized / 2.0 > 1.0 ? 1.0 - focusSizeNormalized / 2.0 : focusPositionNormalized);
        this.focusSizeNormalized = focusSizeNormalized;
        if (focusPositionNormalized - focusSizeNormalized / 2.0 < 0.0) {
            this.focusPositionNormalized = focusSizeNormalized / 2.0;
        } else if (focusPositionNormalized + focusSizeNormalized / 2.0 > 1.0) {
            this.focusPositionNormalized = 1.0 - focusSizeNormalized / 2.0;
        }
        this.zoomFactor = focusSizeNormalized * zoomFactor > 1.0 ? 1.0 / focusSizeNormalized : zoomFactor;
        this.computeCompressionFactor();
        this.computeWindowBoundaries();
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    public void setFocusPositionNormalized(double focusPositionNormalized) {
        if (focusPositionNormalized == this.focusPositionNormalized) {
            return;
        }
        this.focusPositionNormalized = focusPositionNormalized - this.focusSizeNormalized / 2.0 < 0.0 ? this.focusSizeNormalized / 2.0 : (focusPositionNormalized + this.focusSizeNormalized / 2.0 > 1.0 ? 1.0 - this.focusSizeNormalized / 2.0 : focusPositionNormalized);
        this.computeWindowBoundaries();
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    public void setFocusSizeNormalized(double focusSizeNormalized) {
        if (focusSizeNormalized == this.focusSizeNormalized) {
            return;
        }
        this.focusSizeNormalized = focusSizeNormalized;
        if (this.focusPositionNormalized - focusSizeNormalized / 2.0 < 0.0) {
            this.focusPositionNormalized = focusSizeNormalized / 2.0;
        } else if (this.focusPositionNormalized + focusSizeNormalized / 2.0 > 1.0) {
            this.focusPositionNormalized = 1.0 - focusSizeNormalized / 2.0;
        }
        this.computeCompressionFactor();
        this.computeWindowBoundaries();
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    public void setLensNormalized(double position, double size) {
        if (position == this.focusPositionNormalized && size == this.focusSizeNormalized) {
            return;
        }
        this.focusPositionNormalized = position;
        this.focusSizeNormalized = size;
        this.computeCompressionFactor();
        this.computeWindowBoundaries();
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    public void setZoomWindowNormalized(Object source, double x1, double x2) {
        double size = (x2 - x1) / this.zoomFactor;
        double focus = x1 * (1.0 - size) / (1.0 - size * this.zoomFactor) + size / 2.0;
        this.setFocusSizeNormalized(size);
        this.setFocusPositionNormalized(focus);
        this.fireZoomChanged(new ZoomEvent(source, this));
    }

    @Override
    public double normalizedToZoomed(double x) {
        if (this.focusSizeNormalized <= 0.0) {
            return x;
        }
        return BifocalLensZoom.focalTransformation(x, false, this.windowBoundaries[0], this.windowBoundaries[1], this.windowBoundaries[2], this.windowBoundaries[3]);
    }

    @Override
    public double zoomedToNormalized(double x) {
        if (this.focusSizeNormalized <= 0.0) {
            return x;
        }
        return BifocalLensZoom.focalTransformation(x, true, this.windowBoundaries[2], this.windowBoundaries[3], this.windowBoundaries[0], this.windowBoundaries[1]);
    }

    private static double focalTransformation(double value_raw, boolean back_transformation, double window_low_raw, double window_high_raw, double window_low_trans, double window_high_trans) {
        double value_trans = value_raw < window_low_raw ? value_raw / window_low_raw * window_low_trans : (value_raw > window_high_raw ? (value_raw - window_high_raw) / (1.0 - window_high_raw) * (1.0 - window_high_trans) + window_high_trans : (value_raw - window_low_raw) / (window_high_raw - window_low_raw) * (window_high_trans - window_low_trans) + window_low_trans);
        return value_trans;
    }

    private void computeWindowBoundaries() {
        double low_size_zoom;
        double x1w = this.focusPositionNormalized - this.focusSizeNormalized / 2.0;
        double x2w = this.focusPositionNormalized + this.focusSizeNormalized / 2.0;
        double low_size_percentage_world = x1w / (1.0 - this.focusSizeNormalized);
        double focus_size_zoom = this.focusSizeNormalized * this.zoomFactor;
        double x1z = low_size_zoom = low_size_percentage_world * (1.0 - focus_size_zoom);
        double x2z = low_size_zoom + focus_size_zoom;
        this.windowBoundaries[0] = x1w;
        this.windowBoundaries[1] = x2w;
        this.windowBoundaries[2] = x1z;
        this.windowBoundaries[3] = x2z;
    }

    public double getLensBoundaryLowZoomed() {
        return this.windowBoundaries[2];
    }

    public double getLensBoundaryHighZoomed() {
        return this.windowBoundaries[3];
    }

    public double[] getLensBoundariesZoomed() {
        double[] lens_boundaries = new double[]{this.windowBoundaries[2], this.windowBoundaries[3]};
        return lens_boundaries;
    }

    public double getFocusPositionNormalized() {
        return this.focusPositionNormalized;
    }

    public double getFocusSizeNormalized() {
        return this.focusSizeNormalized;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    private void computeCompressionFactor() {
        this.compressionFactor = (1.0 - this.zoomFactor * this.focusSizeNormalized) / (1.0 - this.focusSizeNormalized);
    }

    public double getCompressionFactor() {
        return this.compressionFactor;
    }

    public boolean isLensActive() {
        return this.focusSizeNormalized > 0.0;
    }

    @Override
    public void addZoomListener(ZoomListener listener) {
        this.zoomListeners.addElement(listener);
    }

    @Override
    public void removeZoomListener(ZoomListener listener) {
        this.zoomListeners.removeElement(listener);
    }

    private void fireZoomChanged(ZoomEvent event) {
        for (int i = 0; i < this.zoomListeners.size(); ++i) {
            ZoomListener zoomListener = (ZoomListener)this.zoomListeners.elementAt(i);
            zoomListener.zoomChanged(event);
        }
    }

    public String toString() {
        return this.getClass().getName() + " (position world, size world, zoomfactor): " + this.focusPositionNormalized + ", " + this.focusSizeNormalized + ", " + this.zoomFactor;
    }
}

