/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.soom.lens.zoom;

import com.macrofocus.soom.lens.zoom.ZoomEvent;
import com.macrofocus.soom.lens.zoom.ZoomListener;
import com.macrofocus.soom.lens.zoom.ZoomStrategy;
import java.util.Vector;

public class StandardViewportZoom
implements ZoomStrategy {
    private double minValue = 0.0;
    private double maxValue = 1.0;
    private final Vector zoomListeners = new Vector();

    @Override
    public double normalizedToZoomed(double x) {
        return (x - this.minValue) / (this.maxValue - this.minValue);
    }

    @Override
    public double zoomedToNormalized(double x) {
        return this.minValue + x * (this.maxValue - this.minValue);
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
        this.fireZoomChanged(new ZoomEvent(this, this));
    }

    public void setMinMaxValues(Object source, double minValue, double maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.fireZoomChanged(new ZoomEvent(source, this));
    }

    @Override
    public void addZoomListener(ZoomListener listener) {
        this.zoomListeners.addElement(listener);
    }

    @Override
    public void removeZoomListener(ZoomListener listener) {
        this.zoomListeners.removeElement(listener);
    }

    private void fireZoomChanged(ZoomEvent event) {
        for (int i = 0; i < this.zoomListeners.size(); ++i) {
            ZoomListener zoomListener = (ZoomListener)this.zoomListeners.elementAt(i);
            zoomListener.zoomChanged(event);
        }
    }

    public String toString() {
        return this.getClass().getName() + " (min, maxr): " + this.minValue + ", " + this.maxValue;
    }
}

