/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.soom.lens.zoom.selection;

import com.macrofocus.data.DataModel;
import com.macrofocus.data.RowMajorDataModel;
import com.macrofocus.data.SimpleDataModel;
import com.macrofocus.data.row.RowModel;
import com.macrofocus.data.row.SimpleRowModel;
import com.macrofocus.resources.ResourcesEvent;
import com.macrofocus.resources.ResourcesListener;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.soom.lens.zoom.selection.ZoomConfiguration;
import com.macrofocus.soom.lens.zoom.selection.ZoomSelectionEvent;
import com.macrofocus.soom.lens.zoom.selection.ZoomSelectionListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public class ZoomSelectionModel
implements Externalizable {
    private static final long serialVersionUID = 4225877919073551077L;
    private List<ZoomSelectionListener> selectionListeners;
    private List<ZoomConfiguration> zoomConfigurations = new ArrayList<ZoomConfiguration>();
    private String selectedConfiguration = "none";

    public ZoomSelectionModel() {
        this.selectionListeners = new ArrayList<ZoomSelectionListener>();
    }

    public ZoomSelectionModel(final DataModel dataModel, final ResourcesModel resourcesModel) {
        this();
        this.addConfigurations(dataModel, resourcesModel);
        resourcesModel.addResourcesListener(new ResourcesListener(){

            public void resourcesLocaleChanged(ResourcesEvent event) {
                ZoomSelectionModel.this.zoomConfigurations.clear();
                ZoomSelectionModel.this.addConfigurations(dataModel, resourcesModel);
            }
        });
    }

    private void addConfigurations(DataModel dataModel, ResourcesModel resourcesModel) {
        int nameColumnIndex = dataModel.getColumnIndex((Object)"Name");
        int titleColumnIndex = dataModel.getLocalizedColumnIndex((Object)"Title", resourcesModel.getLocale());
        int focusXColumnIndex = dataModel.getColumnIndex((Object)"FocusX");
        int focusYColumnIndex = dataModel.getColumnIndex((Object)"FocusY");
        int focusWidthColumnIndex = dataModel.getColumnIndex((Object)"FocusWidth");
        int focusHeightColumnIndex = dataModel.getColumnIndex((Object)"FocusHeight");
        int zoomFactorColumnIndex = dataModel.getColumnIndex((Object)"ZoomFactor");
        for (int row = 0; row < dataModel.getRowCount(); ++row) {
            ZoomConfiguration zoomConfiguration = new ZoomConfiguration((String)dataModel.getValueAt(row, nameColumnIndex), (String)dataModel.getValueAt(row, titleColumnIndex), (Double)dataModel.getValueAt(row, focusXColumnIndex), (Double)dataModel.getValueAt(row, focusYColumnIndex), (Double)dataModel.getValueAt(row, focusWidthColumnIndex), (Double)dataModel.getValueAt(row, focusHeightColumnIndex), (Double)dataModel.getValueAt(row, zoomFactorColumnIndex));
            this.addConfiguration(zoomConfiguration);
        }
        this.fireConfigurationChanged(new ZoomSelectionEvent(this, this.getSelf(), ""));
    }

    private ZoomSelectionModel getSelf() {
        return this;
    }

    public void addConfiguration(ZoomConfiguration configuration) {
        this.zoomConfigurations.add(configuration);
    }

    public void selectConfiguration(Object source, String name) {
        for (int i = 0; i < this.zoomConfigurations.size(); ++i) {
            ZoomConfiguration configuration = this.zoomConfigurations.get(i);
            if (!name.equals(configuration.getName())) continue;
            this.selectedConfiguration = name;
            this.fireConfigurationSelected(new ZoomSelectionEvent(source, this, name));
            break;
        }
    }

    public ZoomConfiguration getSelectedConfiguration() {
        if (this.selectedConfiguration.equals("none")) {
            return null;
        }
        for (int i = 0; i < this.zoomConfigurations.size(); ++i) {
            ZoomConfiguration configuration = this.zoomConfigurations.get(i);
            if (!configuration.getName().equals(this.selectedConfiguration)) continue;
            return configuration;
        }
        return null;
    }

    public int getNumberOfConfigurations() {
        return this.zoomConfigurations.size();
    }

    public String getConfigurationName(int index) {
        ZoomConfiguration configuration = this.zoomConfigurations.get(index);
        return configuration.getTitle();
    }

    public String getConfigurationTitle(int index) {
        return this.getConfigurationName(index);
    }

    public void addZoomSelectionListener(ZoomSelectionListener listener) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<ZoomSelectionListener>();
        }
        this.selectionListeners.add(listener);
    }

    public void removeZoomSelectionListener(ZoomSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    private void fireConfigurationSelected(ZoomSelectionEvent event) {
        for (ZoomSelectionListener listener : this.selectionListeners) {
            listener.configurationSelected(event);
        }
    }

    private void fireConfigurationChanged(ZoomSelectionEvent event) {
        for (ZoomSelectionListener listener : this.selectionListeners) {
            listener.configurationChanged(event);
        }
    }

    private DataModel toDataModel() {
        Object[] header = new String[]{"Name", "Title", "FocusX", "FocusY", "FocusWidth", "FocusHeight", "ZoomFactor"};
        Class[] classes = new Class[]{String.class, String.class, Double.class, Double.class, Double.class, Double.class, Double.class};
        RowMajorDataModel dataModel = new RowMajorDataModel(header, classes);
        for (ZoomConfiguration zoomConfiguration : this.zoomConfigurations) {
            Object[] values = new Object[]{zoomConfiguration.getName(), zoomConfiguration.getTitle(), zoomConfiguration.getFocusX(), zoomConfiguration.getFocusY(), zoomConfiguration.getFocusWidth(), zoomConfiguration.getFocusHeight(), zoomConfiguration.getZoomFactor()};
            SimpleRowModel rowModel = new SimpleRowModel(values, classes, header);
            dataModel.addRowModel((RowModel)rowModel);
        }
        return new SimpleDataModel((DataModel)dataModel);
    }

    private void fromDataModel(DataModel dataModel) {
        int nameColumnIndex = dataModel.getColumnIndex((Object)"Name");
        int titleColumnIndex = dataModel.getColumnIndex((Object)"Title");
        int focusXColumnIndex = dataModel.getColumnIndex((Object)"FocusX");
        int focusYColumnIndex = dataModel.getColumnIndex((Object)"FocusY");
        int focusWidthColumnIndex = dataModel.getColumnIndex((Object)"FocusWidth");
        int focusHeightColumnIndex = dataModel.getColumnIndex((Object)"FocusHeight");
        int zoomFactorColumnIndex = dataModel.getColumnIndex((Object)"ZoomFactor");
        for (int row = 0; row < dataModel.getRowCount(); ++row) {
            ZoomConfiguration zoomConfiguration = new ZoomConfiguration((String)dataModel.getValueAt(row, nameColumnIndex), (String)dataModel.getValueAt(row, titleColumnIndex), (Double)dataModel.getValueAt(row, focusXColumnIndex), (Double)dataModel.getValueAt(row, focusYColumnIndex), (Double)dataModel.getValueAt(row, focusWidthColumnIndex), (Double)dataModel.getValueAt(row, focusHeightColumnIndex), (Double)dataModel.getValueAt(row, zoomFactorColumnIndex));
            this.addConfiguration(zoomConfiguration);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(10000);
        out.writeObject(this.toDataModel());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 10000) {
            DataModel dataModel = (DataModel)in.readObject();
            this.fromDataModel(dataModel);
        }
    }
}

