/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.soom.time;

import com.macrofocus.soom.lens.coordinate.CoordinateAxisModel;
import java.util.Calendar;

public class GridModel {
    private CoordinateAxisModel coordinateAxis;
    private static Calendar calendar;
    private long startDate;
    private long endDate;
    private int screenWindowSize;
    private double numberOfPixelsPerDay;
    private long firstDay;
    private boolean drawDays;
    private int[] dayTicks;
    private long[] dayDates;
    private double numberOfPixelsPerWeek;
    private long firstWeek;
    private boolean drawWeeks;
    private int[] weekTicks;
    private long[] weekDates;
    private double numberOfPixelsPerMonth;
    private long firstMonth;
    private boolean drawMonths;
    private int[] monthTicks;
    private long[] monthDates;
    private double numberOfPixelsPerYear;
    private long firstYear;
    private boolean drawYears;
    private int[] yearTicks;
    private long[] yearDates;
    private static int MINIMUM_NUMBER_OF_PIXELS_BETWEEN_DAYS;
    private static int MINIMUM_NUMBER_OF_PIXELS_BETWEEN_WEEKS;
    private static int MINIMUM_NUMBER_OF_PIXELS_BETWEEN_MONTHS;
    private static int MINIMUM_NUMBER_OF_PIXELS_BETWEEN_YEARS;
    private static final long N_MILLISECS_PER_DAY = 86400000L;
    private static final long N_MILLISECS_PER_WEEK = 604800000L;
    private static final long N_MILLISECS_PER_MONTH = 2592000000L;
    private static final long N_MILLISECS_PER_YEAR = 31536000000L;

    public GridModel(CoordinateAxisModel coordinateAxis) {
        this.coordinateAxis = coordinateAxis;
        calendar = Calendar.getInstance();
        this.setWindow((long)coordinateAxis.getWorldMin(), (long)coordinateAxis.getWorldMax());
    }

    public synchronized void setWindow(long startDate, long endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.screenWindowSize = this.coordinateAxis.worldToScreen(endDate) - this.coordinateAxis.worldToScreen(startDate);
        this.computeParameters();
    }

    public boolean isDrawDays() {
        return this.drawDays;
    }

    public int[] getDayTicks() {
        return this.dayTicks;
    }

    public long[] getDayDates() {
        return this.dayDates;
    }

    public double getNumberOfPixelsPerDay() {
        return this.numberOfPixelsPerDay;
    }

    public boolean isDrawWeeks() {
        return this.drawWeeks;
    }

    public int[] getWeekTicks() {
        return this.weekTicks;
    }

    public long[] getWeekDates() {
        return this.weekDates;
    }

    public double getNumberOfPixelsPerWeek() {
        return this.numberOfPixelsPerWeek;
    }

    public boolean isDrawMonths() {
        return this.drawMonths;
    }

    public int[] getMonthTicks() {
        return this.monthTicks;
    }

    public long[] getMonthDates() {
        return this.monthDates;
    }

    public double getNumberOfPixelsPerMonth() {
        return this.numberOfPixelsPerMonth;
    }

    public boolean isDrawYears() {
        return this.drawYears;
    }

    public int[] getYearTicks() {
        return this.yearTicks;
    }

    public long[] getYearDates() {
        return this.yearDates;
    }

    public double getNumberOfPixelsPerYear() {
        return this.numberOfPixelsPerYear;
    }

    private synchronized void computeParameters() {
        this.computeDayParameters();
        this.computeWeekParameters();
        this.computeMonthParameters();
        this.computeYearParameters();
    }

    private synchronized void computeDayParameters() {
        this.numberOfPixelsPerDay = (double)this.screenWindowSize / ((double)(this.endDate - this.startDate) / 8.64E7);
        if (this.numberOfPixelsPerDay > (double)MINIMUM_NUMBER_OF_PIXELS_BETWEEN_DAYS) {
            this.drawDays = true;
            calendar.setTimeInMillis(this.startDate);
            GridModel.advanceCalendarToNextBeginningOfDay(calendar);
            this.firstDay = calendar.getTimeInMillis();
            int n_ticks = (int)((this.endDate - this.firstDay) / 86400000L) + 1;
            n_ticks = Math.max(0, n_ticks);
            this.dayTicks = new int[n_ticks];
            this.dayDates = new long[n_ticks];
            long current_date = calendar.getTimeInMillis();
            for (int index = 0; current_date < this.endDate && index < n_ticks; ++index) {
                this.dayTicks[index] = this.coordinateAxis.worldToScreen(current_date);
                this.dayDates[index] = current_date;
                calendar.add(6, 1);
                current_date = calendar.getTimeInMillis();
            }
        } else {
            this.drawDays = false;
            this.firstDay = 0L;
        }
    }

    private synchronized void computeWeekParameters() {
        this.numberOfPixelsPerWeek = (double)this.screenWindowSize / ((double)(this.endDate - this.startDate) / 6.048E8);
        if (this.numberOfPixelsPerWeek > (double)MINIMUM_NUMBER_OF_PIXELS_BETWEEN_WEEKS) {
            this.drawWeeks = true;
            calendar.setTimeInMillis(this.startDate);
            GridModel.advanceCalendarToNextBeginningOfDay(calendar);
            int day_of_week = calendar.get(7);
            if (day_of_week < 2) {
                calendar.add(6, 2 - day_of_week);
            } else if (day_of_week > 2) {
                calendar.add(6, 9 - day_of_week);
            }
            this.firstWeek = calendar.getTimeInMillis();
            int n_ticks = (int)((this.endDate - this.firstWeek) / 604800000L) + 1;
            if (n_ticks < 0) {
                n_ticks = 0;
            }
            this.weekTicks = new int[n_ticks];
            this.weekDates = new long[n_ticks];
            long current_date = calendar.getTimeInMillis();
            for (int index = 0; current_date < this.endDate && index < n_ticks; ++index) {
                this.weekTicks[index] = this.coordinateAxis.worldToScreen(current_date);
                this.weekDates[index] = current_date;
                calendar.add(6, 7);
                current_date = calendar.getTimeInMillis();
            }
        } else {
            this.drawWeeks = false;
            this.firstWeek = 0L;
        }
    }

    private synchronized void computeMonthParameters() {
        this.numberOfPixelsPerMonth = (double)this.screenWindowSize / ((double)(this.endDate - this.startDate) / 2.592E9);
        if (this.numberOfPixelsPerMonth > (double)MINIMUM_NUMBER_OF_PIXELS_BETWEEN_MONTHS) {
            this.drawMonths = true;
            calendar.setTimeInMillis(this.startDate);
            GridModel.advanceCalendarToNextBeginningOfDay(calendar);
            calendar.add(2, 1);
            int start_month = calendar.get(2);
            int start_year = calendar.get(1);
            calendar.setTimeInMillis(this.endDate);
            int end_month = calendar.get(2);
            int end_year = calendar.get(1);
            calendar.set(start_year, start_month, 1, 0, 0, 0);
            this.firstMonth = calendar.getTimeInMillis();
            calendar.set(end_year, end_month, 1, 0, 0, 0);
            long last_month = calendar.getTimeInMillis();
            int n_ticks = (int)Math.round((double)(last_month - this.firstMonth) / 2.592E9) + 1;
            if (n_ticks < 0) {
                n_ticks = 0;
            }
            this.monthTicks = new int[n_ticks];
            this.monthDates = new long[n_ticks];
            int index = 0;
            for (int year = start_year; year <= end_year; ++year) {
                for (int month = 0; month <= 11; ++month) {
                    if (year == start_year && month < start_month || year == end_year && month > end_month) continue;
                    calendar.set(year, month, 1, 0, 0, 0);
                    if (index < n_ticks) {
                        this.monthTicks[index] = this.coordinateAxis.worldToScreen(calendar.getTimeInMillis());
                        this.monthDates[index] = calendar.getTimeInMillis();
                    }
                    ++index;
                }
            }
        } else {
            this.drawMonths = false;
            this.firstMonth = 0L;
        }
    }

    private synchronized void computeYearParameters() {
        this.numberOfPixelsPerYear = (double)this.screenWindowSize / ((double)(this.endDate - this.startDate) / 3.1536E10);
        if (this.numberOfPixelsPerYear > (double)MINIMUM_NUMBER_OF_PIXELS_BETWEEN_YEARS) {
            this.drawYears = true;
            calendar.setTimeInMillis(this.startDate);
            GridModel.advanceCalendarToNextBeginningOfDay(calendar);
            int start_year = calendar.get(1) + 1;
            calendar.setTimeInMillis(this.endDate);
            int end_year = calendar.get(1);
            calendar.set(start_year, 0, 1, 0, 0, 0);
            this.firstYear = calendar.getTimeInMillis();
            calendar.set(end_year, 0, 1, 0, 0, 0);
            long last_year = calendar.getTimeInMillis();
            int n_ticks = (int)Math.round((double)(last_year - this.firstYear) / 3.1536E10) + 1;
            if (n_ticks < 0) {
                n_ticks = 0;
            }
            this.yearTicks = new int[n_ticks];
            this.yearDates = new long[n_ticks];
            int index = 0;
            for (int year = start_year; year <= end_year; ++year) {
                calendar.set(year, 0, 1, 0, 0, 0);
                if (index < n_ticks) {
                    this.yearTicks[index] = this.coordinateAxis.worldToScreen(calendar.getTimeInMillis());
                    this.yearDates[index] = calendar.getTimeInMillis();
                }
                ++index;
            }
        } else {
            this.drawYears = false;
            this.firstYear = 0L;
        }
    }

    private static void advanceCalendarToNextBeginningOfDay(Calendar c) {
        c.add(5, 1);
        int year = c.get(1);
        int month = c.get(2);
        int day = c.get(5);
        c.set(year, month, day, 0, 0, 0);
    }

    private static long computeClosestDayCeiling(long timestamp) {
        calendar.setTimeInMillis(timestamp);
        calendar.add(5, 1);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        calendar.set(year, month, day, 0, 0, 0);
        return calendar.getTimeInMillis();
    }

    private static long computeClosestDayFloor(long timestamp) {
        long closest_day = timestamp / 86400000L * 86400000L;
        return closest_day;
    }

    static {
        MINIMUM_NUMBER_OF_PIXELS_BETWEEN_DAYS = 5;
        MINIMUM_NUMBER_OF_PIXELS_BETWEEN_WEEKS = 5;
        MINIMUM_NUMBER_OF_PIXELS_BETWEEN_MONTHS = 5;
        MINIMUM_NUMBER_OF_PIXELS_BETWEEN_YEARS = 5;
    }
}

