/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.timing;

import com.macrofocus.util.range.MBoundedRangeModel;
import org.jdesktop.core.animation.timing.Animator;
import org.jdesktop.core.animation.timing.TimingTarget;

public class BoundedRangeTimingTarget
implements TimingTarget {
    private MBoundedRangeModel from;
    private double toRangeMin;
    private double toRangeMax;

    public BoundedRangeTimingTarget(MBoundedRangeModel from, double toRangeMin, double toRangeMax) {
        this.from = from;
        this.toRangeMin = toRangeMin;
        this.toRangeMax = toRangeMax;
    }

    public void timingEvent(Animator source, double v) {
        if (this.from.getValue() != this.toRangeMin || this.from.getValue() + this.from.getExtent() != this.toRangeMax) {
            double min = BoundedRangeTimingTarget.inter(this.from.getValue(), this.toRangeMin, v);
            double max = BoundedRangeTimingTarget.inter(this.from.getValue() + this.from.getExtent(), this.toRangeMax, v);
            this.setWorld(min, max);
        }
    }

    private static double inter(double f, double t, double v) {
        return f + (t - f) * v;
    }

    public void begin(Animator source) {
        if (this.from.getValue() != this.toRangeMin || this.from.getValue() + this.from.getExtent() != this.toRangeMax) {
            // empty if block
        }
    }

    public void end(Animator source) {
        this.setWorld(this.toRangeMin, this.toRangeMax);
    }

    public void repeat(Animator source) {
    }

    public void reverse(Animator source) {
    }

    private void setWorld(double min, double max) {
        this.from.setValue((Object)this, min, max - min);
    }
}

