/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.help;

import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.help.OpenBrowserAction;
import java.applet.AppletContext;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class WebHelpAction
extends AbstractAction {
    private String key;
    private String target;
    private String trailing = "...";
    private AppletContext appletContext;

    public WebHelpAction(String target, String label) {
        this(target, label, (AppletContext)null, "...");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 0));
    }

    public WebHelpAction(String target, String label, AppletContext appletContext) {
        this(target, label, appletContext, "...");
    }

    public WebHelpAction(String target, String label, AppletContext appletContext, String trailing) {
        this.putValue("Name", label + trailing);
        this.target = target;
        this.appletContext = appletContext;
        this.trailing = trailing;
    }

    public WebHelpAction(String key, PropertiesModel propertiesModel) {
        this(null, key, propertiesModel);
    }

    public WebHelpAction(String target, String key, PropertiesModel propertiesModel) {
        this(target, key, propertiesModel, "...");
    }

    public WebHelpAction(String target, String key, final PropertiesModel propertiesModel, String trailing) {
        this.target = target;
        this.key = key;
        this.trailing = trailing;
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                WebHelpAction.this.updateProperties(propertiesModel);
            }
        });
        this.updateProperties(propertiesModel);
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        String name = "Unknown";
        if (propertiesModel.isAvailable(this.key)) {
            name = (String)propertiesModel.getValue(this.key);
        }
        name = name + this.trailing;
        this.putValue("Name", name);
    }

    public void setAppletContext(AppletContext appletContext) {
        this.appletContext = appletContext;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        URL url;
        try {
            url = new URL(this.target);
        }
        catch (MalformedURLException e) {
            url = null;
            e.printStackTrace();
        }
        if (url != null) {
            if (this.appletContext != null) {
                this.appletContext.showDocument(url, "help");
            } else {
                OpenBrowserAction openBrowserAction = new OpenBrowserAction(url);
                openBrowserAction.actionPerformed(evt);
            }
        }
    }

    public static void showHelp(String target) {
        if (target != null) {
            // empty if block
        }
    }
}

