/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.registration;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.registration.RegistrationView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public final class RegisterAction
extends AbstractAction {
    private final ApplicationModel applicationModel;
    private JFrame mainFrame;
    private ResourcesModel resourcesModel;
    private PropertiesModel propertiesModel;
    private final PropertiesListener propertiesListener = new PropertiesListener(){

        public void propertiesChanged(PropertiesEvent e) {
            RegisterAction.this.updateProperties(e.getPropertiesModel());
        }
    };

    public RegisterAction(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public void setMainFrame(JFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void setResourcesModel(ResourcesModel resourcesModel) {
        this.resourcesModel = resourcesModel;
        if (this.propertiesModel != null) {
            this.propertiesModel.removePropertiesListener(this.propertiesListener);
        }
        this.propertiesModel = resourcesModel.getPropertiesModel();
        if (this.propertiesModel != null) {
            this.propertiesModel.addPropertiesListener(this.propertiesListener);
        }
        this.updateProperties(this.propertiesModel);
    }

    private void setLicenseModel(LicenseModel licenseModel) {
        this.applicationModel.setLicenseModel(licenseModel);
    }

    @Override
    public final void actionPerformed(ActionEvent event) {
        Runnable runnable = new Runnable(){
            private final WeakActionListeners actionListeners = new WeakActionListeners();

            @Override
            public void run() {
                final JDialog dialog = new JDialog(RegisterAction.this.mainFrame, (String)RegisterAction.this.propertiesModel.getValue("action.register.title", (Object)"Enter License Data"), true);
                dialog.setDefaultCloseOperation(0);
                final RegistrationView registrationView = new RegistrationView(RegisterAction.this.propertiesModel);
                dialog.setContentPane(registrationView);
                registrationView.getOkButton().addActionListener(this.actionListeners.create(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RegisterAction.this.checkLicense(registrationView, dialog);
                    }
                }, (Object)registrationView.getOkButton()));
                registrationView.getCancelButton().addActionListener(this.actionListeners.create(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        dialog.dispose();
                    }
                }, (Object)registrationView.getCancelButton()));
                LicenseModel loadedLicenseModel = RegisterAction.this.loadLicenseData(RegisterAction.this.propertiesModel);
                LicenseModel.State state = loadedLicenseModel.verify();
                if (state == LicenseModel.State.Expired) {
                    RegisterAction.this.showLicenseExpiredMessage(RegisterAction.this.mainFrame);
                }
                dialog.pack();
                dialog.setLocationRelativeTo(RegisterAction.this.mainFrame);
                dialog.setVisible(true);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void checkLicense(RegistrationView registrationView, JDialog dialog) {
        LicenseModel licenseModel = this.setData(registrationView.getUsername(), registrationView.getLicenseKey());
        LicenseModel.State state = licenseModel.verify();
        if (state == LicenseModel.State.Valid) {
            PropertiesModel propertiesModel = this.resourcesModel.getPropertiesModel();
            propertiesModel.setValue("username", (Object)registrationView.getUsername());
            propertiesModel.setValue("licensekey", (Object)registrationView.getLicenseKey());
            this.resourcesModel.savePreferences();
            dialog.dispose();
        } else {
            switch (state) {
                case EmptyKey: {
                    JOptionPane.showMessageDialog(registrationView, this.propertiesModel.getValue("action.register.empty.key", (Object)"The key is empty"));
                    break;
                }
                case EmptyUsername: {
                    JOptionPane.showMessageDialog(registrationView, this.propertiesModel.getValue("action.register.empty.username", (Object)"The username is empty"));
                    break;
                }
                case InvalidKey: {
                    JOptionPane.showMessageDialog(registrationView, this.propertiesModel.getValue("action.register.invalid.key", (Object)"The key is invalid"));
                    break;
                }
                case InvalidLength: {
                    JOptionPane.showMessageDialog(registrationView, this.propertiesModel.getValue("action.register.invalid.length", (Object)"The length of the key is invalid"));
                    break;
                }
                case Expired: {
                    this.showLicenseExpiredMessage(registrationView);
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(registrationView, this.propertiesModel.getValue("action.register.unknown.error", (Object)"Unknown error"));
                }
            }
        }
    }

    public void showLicenseExpiredMessage(final Component parent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(parent, RegisterAction.this.propertiesModel.getValue("action.register.expired", (Object)"The key has expired"));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public LicenseModel setData(String username, String key) {
        SimpleLicenseModel licenseModel = new SimpleLicenseModel(this.applicationModel, username, key);
        LicenseModel.State state = licenseModel.verify();
        if (state == LicenseModel.State.Valid) {
            this.setLicenseModel((LicenseModel)licenseModel);
        }
        return licenseModel;
    }

    private void refresh() {
    }

    private void save() {
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        String name = "Register";
        if (propertiesModel != null) {
            name = (String)propertiesModel.getValue("action.register.label", (Object)name);
        }
        name = name + "...";
        this.putValue("Name", name);
    }

    public LicenseModel loadLicenseData(PropertiesModel propertiesModel) {
        String username = (String)propertiesModel.getValue("username");
        String key = (String)propertiesModel.getValue("licensekey");
        return this.setData(username, key);
    }

    public LicenseModel loadLicenseData(String username, String key) {
        return this.setData(username, key);
    }
}

