/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing;

import com.apple.eawt.Application;
import com.macrofocus.application.ApplicationModel;
import com.macrofocus.helper.SwingHelper;
import com.macrofocus.resources.Resource;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.java2d.RenderingHintsListener;
import com.macrofocus.util.java2d.RenderingHintsModel;
import com.macrofocus.util.java2d.RepaintRenderingHintsListener;
import com.macrofocus.util.java2d.SimpleRenderingHintsModel;
import com.macrofocus.util.swing.Translucent;
import com.macrofocus.util.swing.action.ExitAction;
import com.macrofocus.util.swing.waitwithstyle.PerformanceInfiniteProgressPanel;
import com.macrofocus.util.swing.window.ResourcesSplashPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;

public class MFrame
extends JFrame {
    private RenderingHintsModel renderingHintsModel;
    private ApplicationModel applicationModel;
    private Action exitAction;
    private RenderingHintsListener renderingHintsListener;
    private PerformanceInfiniteProgressPanel progressPanel;
    private File file;
    private String filename;
    private boolean modified = false;
    private Translucent splashPanel;
    private WindowAdapter windowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            if (MFrame.this.exitAction != null) {
                MFrame.this.exitAction.actionPerformed(new ActionEvent(this, 0, null));
            } else {
                e.getWindow().dispose();
            }
        }
    };
    private Component waitPane = null;
    private Component glassPane = null;
    private boolean waitPaneVisible = false;
    private Cursor realCursor = null;
    private boolean waitCursorVisible = false;
    private boolean waiting = false;

    public MFrame(RenderingHintsModel renderingHintsModel) throws HeadlessException {
        this.renderingHintsModel = renderingHintsModel;
    }

    public MFrame(ApplicationModel applicationModel, ResourcesModel resourcesModel, Resource resource, ExitAction exitAction, boolean isSplashEnabled, boolean defaultFrameSize) {
        this.exitAction = exitAction;
        this.applicationModel = applicationModel;
        PropertiesModel propertiesModel = resourcesModel.getPropertiesModel();
        this.updateTitle();
        exitAction.setMainFrame(this);
        if (defaultFrameSize || !((Boolean)propertiesModel.getValue(resource.getMainFrameRestoreOnStartupKey(), (Object)Boolean.FALSE)).booleanValue()) {
            propertiesModel.setValue(resource.getMainFrameWidthKey(), (Object)resource.getMainFrameWidthDefaultValue());
            propertiesModel.setValue(resource.getMainFrameHeightKey(), (Object)resource.getMainFrameHeightDefaultValue());
        }
        int width = (Integer)propertiesModel.getValue(resource.getMainFrameWidthKey());
        int height = (Integer)propertiesModel.getValue(resource.getMainFrameHeightKey());
        if (!defaultFrameSize && ((Boolean)propertiesModel.getValue(resource.getMainFrameRestoreOnStartupKey(), (Object)Boolean.FALSE)).booleanValue()) {
            int x = (Integer)propertiesModel.getValue(resource.getMainFrameXKey(), (Object)-1);
            int y = (Integer)propertiesModel.getValue(resource.getMainFrameYKey(), (Object)-1);
            if (x >= 0 && y >= 0) {
                int diffHeight;
                int diffWidth;
                Rectangle bounds = new Rectangle();
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice[] gs = ge.getScreenDevices();
                for (int j = 0; j < gs.length; ++j) {
                    GraphicsDevice gd = gs[j];
                    GraphicsConfiguration gc = gd.getDefaultConfiguration();
                    bounds = bounds.union(gc.getBounds());
                }
                if ((double)width > bounds.getWidth()) {
                    width = bounds.width;
                }
                if ((double)height > bounds.getHeight()) {
                    height = bounds.height;
                }
                if ((diffWidth = bounds.width - (x + width)) < 0) {
                    x += diffWidth;
                }
                if ((diffHeight = bounds.height - (y + height)) < 0) {
                    y += diffHeight;
                }
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                this.setBounds(x, y, width, height);
            } else {
                this.setSize(width, height);
                try {
                    this.setLocationByPlatform(true);
                }
                catch (NoSuchMethodError e) {
                    this.setLocationRelativeTo(null);
                }
            }
        } else {
            this.setSize(width, height);
            try {
                this.setLocationByPlatform(true);
            }
            catch (NoSuchMethodError e) {
                this.setLocationRelativeTo(null);
            }
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.windowListener);
        URL iconUrl = resourcesModel.getUrl("icon32x32.gif");
        if (iconUrl != null) {
            Image image = new ImageIcon(iconUrl).getImage();
            try {
                Application.getApplication().setDockIconImage(image);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.setIconImage(image);
        }
        this.setVisible(true);
        if (isSplashEnabled) {
            this.splashPanel = new ResourcesSplashPanel(resourcesModel, "splash.jpg", applicationModel, true);
            this.getLayeredPane().add(this.splashPanel.getComponent(), JLayeredPane.POPUP_LAYER, 0);
            SwingHelper.center((Container)this.getLayeredPane(), (Component)this.splashPanel.getComponent());
        }
        this.renderingHintsModel = new SimpleRenderingHintsModel();
        this.renderingHintsListener = new RepaintRenderingHintsListener(this, 500L);
        this.renderingHintsModel.addWeakRenderingHintsListener(this.renderingHintsListener);
    }

    @Override
    public void paintComponents(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.renderingHintsModel != null) {
            g2.setRenderingHints(this.renderingHintsModel.getRenderingHints());
        }
        super.paintComponents(g);
    }

    public RenderingHintsModel getRenderingHintsModel() {
        return this.renderingHintsModel;
    }

    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.updateTitle();
    }

    public void setFilename(String filename) {
        if (this.filename != filename) {
            this.filename = filename;
            this.file = null;
            this.updateTitle();
        }
    }

    public void setFile(File file) {
        if (this.file != file) {
            this.file = file;
            this.filename = file != null ? file.getName() : null;
            this.updateTitle();
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setModified(boolean modified) {
        if (this.modified != modified) {
            this.modified = modified;
            this.updateTitle();
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    private void updateTitle() {
        if (this.applicationModel != null) {
            String title = this.applicationModel.getName();
            if (this.filename != null) {
                title = title + " - " + this.filename;
                if (this.modified) {
                    title = title + "*";
                }
            }
            this.setTitle(title);
        }
    }

    protected void finalize() throws Throwable {
        System.gc();
        if (this.progressPanel != null) {
            this.progressPanel.stop();
        }
        super.finalize();
    }

    public void setWaiting(boolean waiting) {
        if (waiting && this.progressPanel == null) {
            this.progressPanel = new PerformanceInfiniteProgressPanel(false);
            this.setWaitPane(this.progressPanel);
        }
        this.setWaiting2(waiting);
        this.validate();
        this.setWaitCursorVisible(waiting);
        this.getContentPane().setIgnoreRepaint(!waiting);
        this.getContentPane().setEnabled(!waiting);
        if (waiting) {
            this.progressPanel.start();
        } else {
            this.progressPanel.stop();
        }
        this.validate();
        this.repaint();
    }

    public void setExitAction(Action exitAction) {
        this.exitAction = exitAction;
    }

    public Translucent getSplashPanel() {
        return this.splashPanel;
    }

    public void setWaiting2(boolean waiting) {
        boolean old = this.isWaiting();
        this.waiting = waiting;
        this.firePropertyChange("waiting", old, this.isWaiting());
        this.setWaitPaneVisible(waiting);
        this.setWaitCursorVisible(waiting);
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public void setWaitPane(Component c) {
        Component old = this.getWaitPane();
        this.waitPane = c;
        this.firePropertyChange("waitPane", old, this.getWaitPane());
    }

    public Component getWaitPane() {
        return this.waitPane;
    }

    public void setWaitPaneVisible(boolean flag) {
        boolean old = this.isWaitPaneVisible();
        if (flag != old) {
            this.waitPaneVisible = flag;
            Component wp = this.getWaitPane();
            if (this.isWaitPaneVisible()) {
                this.glassPane = this.getRootPane().getGlassPane();
                if (wp != null) {
                    this.getRootPane().setGlassPane(wp);
                    wp.setVisible(true);
                }
            } else {
                if (wp != null) {
                    wp.setVisible(false);
                }
                this.getRootPane().setGlassPane(this.glassPane);
            }
            this.firePropertyChange("waitPaneVisible", old, this.isWaitPaneVisible());
        }
    }

    public boolean isWaitPaneVisible() {
        return this.waitPaneVisible;
    }

    public void setWaitCursorVisible(boolean flag) {
        boolean old = this.isWaitCursorVisible();
        if (flag != old) {
            this.waitCursorVisible = flag;
            if (this.isWaitCursorVisible()) {
                this.realCursor = this.getCursor();
                super.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                super.setCursor(this.realCursor);
            }
            this.firePropertyChange("waitCursorVisible", old, this.isWaitCursorVisible());
        }
    }

    public boolean isWaitCursorVisible() {
        return this.waitCursorVisible;
    }
}

