/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.action;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.swing.print.A4PortraitPaper;
import com.macrofocus.util.swing.print.JComponentPrintable;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;

public class PrintJComponentAction
extends AbstractAction {
    private Component component;

    public PrintJComponentAction(PropertiesModel propertiesModel) {
        this(null, propertiesModel);
    }

    public PrintJComponentAction(Component component, ResourcesModel resourcesModel) {
        this(component, resourcesModel.getPropertiesModel());
        URL url = resourcesModel.getUrl("Print16.gif");
        if (url != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        }
    }

    public PrintJComponentAction(Component component) {
        this(component, (PropertiesModel)null);
    }

    public PrintJComponentAction(Component component, final PropertiesModel propertiesModel) {
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    PrintJComponentAction.this.updateProperties(propertiesModel);
                }
            });
        }
        this.component = component;
        this.checkEnabled();
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("MnemonicKey", 80);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        JComponentPrintable printable = new JComponentPrintable(this.component, false);
        PrintJComponentAction.disableDoubleBuffering(this.component);
        pj.setPrintable(printable);
        PageFormat defaultPf = pj.defaultPage();
        defaultPf.setOrientation(0);
        A4PortraitPaper paper = new A4PortraitPaper();
        defaultPf.setPaper(paper);
        PageFormat pf = pj.pageDialog(defaultPf);
        if (!pf.equals(defaultPf)) {
            pj.setPrintable(printable, pf);
        } else {
            pj.setPrintable(printable);
        }
        if (pj.printDialog()) {
            try {
                pj.print();
            }
            catch (PrinterException e) {
                Logging.getInstance().process((Throwable)e);
            }
        }
        PrintJComponentAction.enableDoubleBuffering(this.component);
    }

    public void setComponent(Component component) {
        this.component = component;
        this.checkEnabled();
    }

    private void checkEnabled() {
        boolean enable = this.component != null;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPrintJobAccess();
            }
            this.setEnabled(enable);
        }
        catch (Exception e) {
            this.setEnabled(false);
        }
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        String name = "Print...";
        if (propertiesModel != null && propertiesModel.isAvailable("action.print.label")) {
            name = propertiesModel.getValue("action.print.label") + "...";
        }
        this.putValue("Name", name);
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

