/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class KunststoffButtonBorder
extends AbstractBorder {
    protected static Insets borderInsets = new Insets(3, 10, 3, 10);
    private Color primaryControlDarkShadow;
    private Color primaryControl;
    private Color controlDarkShadow;
    private Color controlHighlight;
    private Color controlShadow;
    private Color control;

    public KunststoffButtonBorder(Color controlColor, Color highlightColor, Color shadowColor) {
        this.primaryControlDarkShadow = shadowColor;
        this.primaryControl = controlColor;
        this.controlDarkShadow = shadowColor;
        this.controlHighlight = highlightColor;
        this.controlShadow = shadowColor;
        this.control = controlColor;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        if (model.isEnabled()) {
            if (model.isPressed() && model.isArmed()) {
                this.drawPressed3DBorder(g, x, y, w, h);
            } else if (button instanceof JButton && ((JButton)button).isDefaultButton()) {
                if (button.hasFocus()) {
                    // empty if block
                }
                this.drawDefaultButtonBorder(g, x, y, w, h, false);
            } else {
                if (button.hasFocus()) {
                    // empty if block
                }
                this.drawButtonBorder(g, x, y, w, h, false);
            }
        } else {
            this.drawDisabledBorder(g, x, y, w - 1, h - 1);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return borderInsets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets newInsets) {
        newInsets.top = KunststoffButtonBorder.borderInsets.top;
        newInsets.left = KunststoffButtonBorder.borderInsets.left;
        newInsets.bottom = KunststoffButtonBorder.borderInsets.bottom;
        newInsets.right = KunststoffButtonBorder.borderInsets.right;
        return newInsets;
    }

    private void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        this.drawFlush3DBorder(g, 0, 0, w, h);
        g.setColor(MetalLookAndFeel.getControlShadow());
        g.drawLine(1, 1, 1, h - 2);
        g.drawLine(1, 1, w - 2, 1);
        g.translate(-x, -y);
    }

    private void drawFlush3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(this.controlDarkShadow);
        g.drawRect(0, 0, w - 2, h - 2);
        g.setColor(this.controlHighlight);
        g.drawRect(1, 1, w - 2, h - 2);
        g.setColor(this.control);
        g.drawLine(0, h - 1, 1, h - 2);
        g.drawLine(w - 1, 0, w - 2, 1);
        g.translate(-x, -y);
    }

    private void drawDisabledBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(this.controlShadow);
        g.drawRect(0, 0, w - 1, h - 1);
    }

    private void drawDefaultButtonBorder(Graphics g, int x, int y, int w, int h, boolean active) {
        this.drawButtonBorder(g, x + 1, y + 1, w - 1, h - 1, active);
        g.setColor(this.controlDarkShadow);
        g.drawRect(x, y, w - 3, h - 3);
        g.drawLine(w - 2, 0, w - 2, 0);
        g.drawLine(0, h - 2, 0, h - 2);
    }

    private void drawButtonBorder(Graphics g, int x, int y, int w, int h, boolean active) {
        if (active) {
            this.drawActiveButtonBorder(g, x, y, w, h);
        } else {
            this.drawFlush3DBorder(g, x, y, w, h);
        }
    }

    private void drawActiveButtonBorder(Graphics g, int x, int y, int w, int h) {
        this.drawFlush3DBorder(g, x, y, w, h);
        g.setColor(this.primaryControl);
        g.drawLine(x + 1, y + 1, x + 1, h - 3);
        g.drawLine(x + 1, y + 1, w - 3, x + 1);
        g.setColor(this.primaryControlDarkShadow);
        g.drawLine(x + 2, h - 2, w - 2, h - 2);
        g.drawLine(w - 2, y + 2, w - 2, h - 2);
    }
}

