/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.dnd;

import com.macrofocus.util.swing.dnd.GhostedDragImage;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public abstract class DragHandler
implements DragSourceListener,
DragSourceMotionListener,
DragGestureListener {
    static final int MOVE = 2;
    static final int COPY = 1;
    static final int LINK = 0x40000000;
    static final int NONE = 0;
    static final int MOVE_MASK = 64;
    static final boolean OSX = System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    static final int COPY_MASK = OSX ? 512 : 128;
    static final int LINK_MASK = OSX ? 768 : 192;
    static final int KEY_MASK = 9152;
    static int modifiers;
    private int supportedActions;
    private DelegatingTransferable transferable;
    private boolean fixCursor = true;
    private Component component;
    private GhostedDragImage ghost;
    public static final float DEFAULT_GHOST_ALPHA = 0.5f;
    private String lastAction;

    public DragHandler(Component comp, int actions) {
        this.component = comp;
        this.supportedActions = actions;
        DragSource src = DragSource.getDefaultDragSource();
        src.createDefaultDragGestureRecognizer(comp, this.supportedActions, this);
    }

    protected boolean canDrag(DragGestureEvent e) {
        int mods = e.getTriggerEvent().getModifiersEx() & 0x23C0;
        if (mods == 64) {
            return (this.supportedActions & 2) != 0;
        }
        if (mods == COPY_MASK) {
            return (this.supportedActions & 1) != 0;
        }
        if (mods == LINK_MASK) {
            return (this.supportedActions & 0x40000000) != 0;
        }
        return true;
    }

    protected abstract Transferable getTransferable(DragGestureEvent var1);

    protected Icon getDragIcon(DragGestureEvent e, Point offset) {
        offset.setLocation(0, 0);
        return null;
    }

    protected void dragStarted(DragGestureEvent e) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        if ((e.getDragAction() & this.supportedActions) != 0 && this.canDrag(e)) {
            modifiers = e.getTriggerEvent().getModifiersEx() & 0x23C0;
            Transferable t = this.getTransferable(e);
            this.transferable = new DelegatingTransferable(t);
            try {
                Cursor cursor = null;
                Point imageOffset = new Point();
                Icon dragImage = this.getDragIcon(e, imageOffset);
                Point origin = e.getDragOrigin();
                imageOffset.translate(-origin.x, -origin.y);
                if (dragImage != null && DragSource.isDragImageSupported()) {
                    e.startDrag(cursor, this.createDragImage(dragImage), imageOffset, this.transferable, this);
                } else {
                    if (dragImage != null) {
                        Window w = SwingUtilities.getWindowAncestor(this.component);
                        if (this.component instanceof JComponent && w instanceof RootPaneContainer) {
                            JLayeredPane p = ((RootPaneContainer)((Object)w)).getLayeredPane();
                            Point loc = this.component.getLocationOnScreen();
                            loc.translate(origin.x, origin.y);
                            this.ghost = new GhostedDragImage(p, p, loc, dragImage, imageOffset, true);
                        }
                    }
                    e.startDrag(cursor, this.transferable, this);
                }
                this.dragStarted(e);
                e.getDragSource().addDragSourceMotionListener(this);
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                // empty catch block
            }
        }
    }

    private Image createDragImage(Icon icon) {
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = new BufferedImage(w, h, 3);
        Graphics g = image.getGraphics();
        icon.paintIcon(this.component, g, 0, 0);
        g.dispose();
        return image;
    }

    private int reduce(int actions) {
        if ((actions & 2) != 0 && actions != 2) {
            return 2;
        }
        if ((actions & 1) != 0 && actions != 1) {
            return 1;
        }
        return actions;
    }

    protected Cursor getCursorForAction(int actualAction) {
        switch (actualAction) {
            case 2: {
                return DragSource.DefaultMoveDrop;
            }
            case 1: {
                return DragSource.DefaultCopyDrop;
            }
            case 0x40000000: {
                return DragSource.DefaultLinkDrop;
            }
        }
        return DragSource.DefaultMoveNoDrop;
    }

    protected int getAcceptableDropAction(int targetActions) {
        return this.reduce(this.supportedActions & targetActions);
    }

    protected int getDropAction(DragSourceEvent ev) {
        if (ev instanceof DragSourceDragEvent) {
            DragSourceDragEvent e = (DragSourceDragEvent)ev;
            return e.getDropAction();
        }
        return 0;
    }

    protected int adjustDropAction(DragSourceEvent ev) {
        int action = this.getDropAction(ev);
        if (ev instanceof DragSourceDragEvent) {
            int mods;
            DragSourceDragEvent e = (DragSourceDragEvent)ev;
            if (action == 0 && (mods = e.getGestureModifiersEx() & 0x23C0) == 0) {
                action = this.getAcceptableDropAction(e.getTargetActions());
            }
        }
        return action;
    }

    protected void updateCursor(DragSourceEvent ev) {
        if (!this.fixCursor) {
            return;
        }
        Cursor cursor = this.getCursorForAction(this.adjustDropAction(ev));
        if (this.ghost != null) {
            this.ghost.setCursor(cursor);
        }
        ev.getDragSourceContext().setCursor(cursor);
    }

    static String actionString(int action) {
        switch (action) {
            case 2: {
                return "MOVE";
            }
            case 3: {
                return "MOVE|COPY";
            }
            case 0x40000002: {
                return "MOVE|LINK";
            }
            case 0x40000003: {
                return "MOVE|COPY|LINK";
            }
            case 1: {
                return "COPY";
            }
            case 0x40000001: {
                return "COPY|LINK";
            }
            case 0x40000000: {
                return "LINK";
            }
        }
        return "NONE";
    }

    private void describe(String type, DragSourceEvent e) {
        DragSourceContext ds = e.getDragSourceContext();
        String msg = type;
        if (e instanceof DragSourceDragEvent) {
            DragSourceDragEvent ev = (DragSourceDragEvent)e;
            msg = msg + ": src=" + DragHandler.actionString(ds.getSourceActions()) + " usr=" + DragHandler.actionString(ev.getUserAction()) + " tgt=" + DragHandler.actionString(ev.getTargetActions()) + " act=" + DragHandler.actionString(ev.getDropAction()) + " mods=" + ev.getGestureModifiersEx();
        } else {
            msg = msg + ": e=" + e;
        }
        if (!msg.equals(this.lastAction)) {
            // empty if block
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
        this.describe("end", e);
        this.transferable = null;
        modifiers = 0;
        if (this.ghost != null) {
            this.ghost.dispose();
            this.ghost = null;
        }
        DragSource src = e.getDragSourceContext().getDragSource();
        src.removeDragSourceMotionListener(this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
        this.describe("enter", e);
        this.updateCursor(e);
        this.transferable.setDisallow(this.adjustDropAction(e) == 0);
    }

    @Override
    public void dragMouseMoved(DragSourceDragEvent e) {
        this.describe("move", e);
        if (this.ghost != null) {
            this.ghost.move(e.getLocation());
        }
        this.updateCursor(e);
        this.transferable.setDisallow(this.adjustDropAction(e) == 0);
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
        this.describe("over", e);
        this.updateCursor(e);
        this.transferable.setDisallow(this.adjustDropAction(e) == 0);
    }

    @Override
    public void dragExit(DragSourceEvent e) {
        this.describe("exit", e);
        this.updateCursor(e);
        this.transferable.setDisallow(false);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
        this.describe("change", e);
        modifiers = e.getGestureModifiersEx() & 0x23C0;
        this.updateCursor(e);
        this.transferable.setDisallow(this.adjustDropAction(e) == 0);
    }

    private class DelegatingTransferable
    implements Transferable {
        boolean disallow;
        Transferable delegate;

        public DelegatingTransferable(Transferable delegate) {
            this.delegate = delegate;
            this.disallow = delegate == null;
        }

        public boolean getDisallow() {
            return this.disallow;
        }

        public void setDisallow(boolean disallow) {
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.disallow ? new DataFlavor[]{} : this.delegate.getTransferDataFlavors();
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return !this.disallow && this.delegate.isDataFlavorSupported(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.disallow) {
                throw new IOException("Action disallowed");
            }
            return this.delegate.getTransferData(flavor);
        }
    }
}

