/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.export.format;

import com.macrofocus.util.swing.export.format.AbstractExportFormat;
import java.awt.Component;
import java.awt.Graphics;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public abstract class AbstractGraphicsExportFormat
extends AbstractExportFormat<Component> {
    public int getExportWidth(Component component) {
        if (component instanceof JTable) {
            JTable table = (JTable)component;
            return Math.max(table.getWidth(), table.getTableHeader().getWidth());
        }
        return component.getWidth();
    }

    public int getExportHeight(Component component) {
        if (component instanceof JTable) {
            JTable table = (JTable)component;
            return table.getTableHeader().getHeight() + table.getHeight();
        }
        return component.getHeight();
    }

    public void print(final Component component, final Graphics g) {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (component instanceof JTable) {
                        JTable table = (JTable)component;
                        table.getTableHeader().print(g);
                        g.translate(0, table.getTableHeader().getHeight());
                        component.print(g);
                    } else {
                        component.print(g);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

