/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.export.format;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.macrofocus.util.swing.export.format.DPI;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PNGFormatSettingsEditor {
    private JComboBox outputDPIComboBox;
    private JPanel settingsPanel;
    private JComboBox screenDPIComboBox;

    public PNGFormatSettingsEditor() {
        DPI retina;
        DPI screenDPI;
        this.$$$setupUI$$$();
        ArrayList<DPI> screenDPIs = new ArrayList<DPI>();
        screenDPIs.add(new DPI(72.0f));
        screenDPIs.add(new DPI(96.0f));
        screenDPIs.add(new DPI(120.0f));
        try {
            screenDPI = new DPI(Toolkit.getDefaultToolkit().getScreenResolution());
        }
        catch (HeadlessException e) {
            screenDPI = new DPI(72.0f);
        }
        if (!screenDPIs.contains(screenDPI)) {
            screenDPIs.add(screenDPI);
            Collections.sort(screenDPIs);
        }
        for (DPI dpi : screenDPIs) {
            this.screenDPIComboBox.addItem(dpi);
        }
        this.screenDPIComboBox.setSelectedItem(screenDPI);
        ArrayList<DPI> outputDPIs = new ArrayList<DPI>();
        outputDPIs.add(new DPI(32.4f));
        outputDPIs.add(new DPI(72.0f));
        outputDPIs.add(new DPI(96.0f));
        outputDPIs.add(new DPI(120.0f));
        outputDPIs.add(new DPI(150.0f));
        outputDPIs.add(new DPI(240.0f));
        outputDPIs.add(new DPI(300.0f));
        outputDPIs.add(new DPI(600.0f));
        outputDPIs.add(new DPI(1200.0f));
        if (!outputDPIs.contains(screenDPI)) {
            outputDPIs.add(screenDPI);
            Collections.sort(outputDPIs);
        }
        if (!outputDPIs.contains(retina = new DPI(screenDPI.getValue() * 2.0f))) {
            outputDPIs.add(retina);
            Collections.sort(outputDPIs);
        }
        for (DPI outputDPI : outputDPIs) {
            this.outputDPIComboBox.addItem(outputDPI);
        }
        this.outputDPIComboBox.setSelectedItem(screenDPI);
    }

    public DPI getScreenDPI() {
        return (DPI)this.screenDPIComboBox.getSelectedItem();
    }

    public DPI getOutputDPI() {
        return (DPI)this.outputDPIComboBox.getSelectedItem();
    }

    public void setScreenDPI(DPI dpi) {
        this.screenDPIComboBox.setSelectedItem(dpi);
    }

    public void setOutputDPI(DPI dpi) {
        this.outputDPIComboBox.setSelectedItem(dpi);
    }

    public JPanel getSettingsPanel() {
        return this.settingsPanel;
    }

    private void $$$setupUI$$$() {
        this.settingsPanel = new JPanel();
        this.settingsPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1));
        JLabel label1 = new JLabel();
        label1.setText("Output DPI: ");
        this.settingsPanel.add((Component)label1, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.settingsPanel.add((Component)spacer1, new GridConstraints(1, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.settingsPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.outputDPIComboBox = new JComboBox();
        this.settingsPanel.add((Component)this.outputDPIComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Screen DPI:");
        this.settingsPanel.add((Component)label2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.screenDPIComboBox = new JComboBox();
        this.settingsPanel.add((Component)this.screenDPIComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.settingsPanel;
    }
}

