/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.icon;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class BufferedImageView
extends JPanel {
    private BufferedImage image;
    private float alpha = 1.0f;

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            Graphics2D g2 = (Graphics2D)g;
            Dimension d = this.getSize();
            double xScale = d.getWidth() / (double)this.image.getWidth(this);
            double yScale = d.getHeight() / (double)this.image.getHeight(this);
            double scale = Math.min(xScale, yScale);
            g2.setComposite(AlphaComposite.getInstance(3, this.alpha));
            g2.drawImage(this.image, 0, 0, (int)((double)this.image.getWidth(this) * scale), (int)((double)this.image.getHeight(this) * scale), this);
        }
    }

    public void setImage(BufferedImage imageIcon) {
        this.image = imageIcon;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }
}

