/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import javax.swing.Icon;

public class SortArrowIcon
implements Icon {
    private boolean ascending = true;
    private int width = 8;
    private int height = 8;
    Color arrowColor = new Color(255, 255, 0);

    public SortArrowIcon(boolean ascending) {
        this.ascending = ascending;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int offset_x, int offset_y) {
        Graphics2D g2 = (Graphics2D)g;
        g.setColor(this.arrowColor);
        int centerX = this.width / 2;
        if (this.ascending) {
            Polygon polygon = new Polygon();
            polygon.addPoint(centerX + offset_x, offset_y);
            polygon.addPoint(offset_x, this.height + offset_y);
            polygon.addPoint(this.width + offset_x, this.height + offset_y);
            g2.fill(polygon);
        } else {
            Polygon polygon = new Polygon();
            polygon.addPoint(offset_x, offset_y + 1);
            polygon.addPoint(this.width + offset_x, offset_y + 1);
            polygon.addPoint(centerX + offset_x, this.height + offset_y);
            g2.fill(polygon);
        }
    }
}

