/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.plaf.action;

import com.macrofocus.util.swing.plaf.action.LookAndFeelAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class MetalLookAndFeelAction
extends LookAndFeelAction {
    private final String themeName;
    private MetalTheme theme;

    public MetalLookAndFeelAction() {
        super("metal", "Metal");
        this.themeName = "default";
    }

    public MetalLookAndFeelAction(String name, String label, String themeName) {
        super(name, label);
        this.themeName = themeName;
    }

    @Override
    public boolean exist() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            if (this.theme == null) {
                if (this.themeName.equals("ocean")) {
                    try {
                        Class<?> cl = Class.forName("javax.swing.plaf.metal.OceanTheme");
                        this.theme = (MetalTheme)cl.newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        this.theme = new DefaultMetalTheme();
                    }
                } else {
                    this.theme = new DefaultMetalTheme();
                }
            }
            MetalLookAndFeel.setCurrentTheme(this.theme);
            MetalLookAndFeel newLookAndFeel = new MetalLookAndFeel();
            UIManager.setLookAndFeel(newLookAndFeel);
            if (this.rootComponents != null) {
                for (Component rootComponent : (Iterable)this.rootComponents.get()) {
                    try {
                        SwingUtilities.updateComponentTreeUI(rootComponent);
                    }
                    catch (ExceptionInInitializerError e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't load Metal L&F " + e);
            e.printStackTrace();
        }
    }
}

