/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.plaf.action;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.util.swing.plaf.action.LookAndFeelAction;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessControlException;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class SyntheticaLookAndFeelAction
extends LookAndFeelAction {
    private final String className;
    private final boolean decorated;
    private final boolean useScreenMenuBar;

    public SyntheticaLookAndFeelAction(String name, String label, String className) {
        this(name, label, className, false);
    }

    public SyntheticaLookAndFeelAction(String name, String label, String className, boolean decorated) {
        this(name, label, className, decorated, SyntheticaLookAndFeelAction.useScreenMenuBar());
    }

    private static boolean useScreenMenuBar() {
        try {
            return System.getProperty("macrofocus.laf.useScreenMenuBar") == null || Boolean.parseBoolean(System.getProperty("macrofocus.laf.useScreenMenuBar"));
        }
        catch (AccessControlException e) {
            return true;
        }
    }

    public SyntheticaLookAndFeelAction(String name, String label, String className, boolean decorated, boolean useScreenMenuBar) {
        super(name, label);
        this.className = className;
        this.decorated = decorated;
        this.useScreenMenuBar = useScreenMenuBar;
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SyntheticaLookAndFeelAction.this.setSelected(SyntheticaLookAndFeelAction.this.active());
            }
        });
        this.setSelected(this.active());
        this.setEnabled(this.exist());
    }

    @Override
    public boolean exist() {
        Class<?> cl = null;
        try {
            cl = Class.forName(this.className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            return this.isApplet();
        }
        catch (UnsupportedClassVersionError e) {
            return false;
        }
        return cl != null;
    }

    @Override
    public boolean active() {
        return UIManager.getLookAndFeel().getClass().getName().equals(this.className);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.decorated) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        try {
            try {
                SyntheticaLookAndFeel.setLookAndFeel((String)this.className, (boolean)true, (boolean)false);
            }
            catch (AccessControlException e) {
                SyntheticaLookAndFeel.setLookAndFeel((String)this.className, (boolean)false, (boolean)false);
            }
            if ("zh".equals(Locale.getDefault().getLanguage()) || "ja".equals(Locale.getDefault().getLanguage())) {
                SyntheticaLookAndFeel.setFont((String)"Dialog", (int)12);
            }
            if (this.rootComponents != null) {
                for (Component rootComponent : (Iterable)this.rootComponents.get()) {
                    SwingUtilities.updateComponentTreeUI(rootComponent);
                }
            }
        }
        catch (NoClassDefFoundError e) {
            Logging.getInstance().process((Throwable)e);
        }
        catch (RuntimeException e) {
            Logging.getInstance().process((Throwable)e);
        }
        catch (Exception e) {
            Logging.getInstance().process((Throwable)e);
        }
        catch (Error e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    private static void setLookAndFeelWorkaround(String var0) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        Locale var1 = Locale.getDefault();
        boolean var2 = "tr".equalsIgnoreCase(var1.getLanguage());
        if (var2) {
            Locale.setDefault(Locale.US);
        }
        UIManager.setLookAndFeel(var0);
        if (var2) {
            Locale.setDefault(var1);
        }
    }

    @Override
    public String getClassname() {
        return this.className;
    }

    static {
        String[] li = new String[]{"Licensee=Macrofocus GmbH", "LicenseRegistrationNumber=553461323", "Product=Synthetica", "LicenseType=Small Business License", "ExpireDate=--.--.----", "MaxVersion=3.4.999"};
        UIManager.put("Synthetica.license.info", li);
        UIManager.put("Synthetica.license.key", "D2C7CF96-184EE0DA-E26EF58F-A2C4B533-B1072C89-5BA23EDC-5ABF766A-4694C509");
        String[] li2 = new String[]{"Licensee=Macrofocus GmbH", "LicenseRegistrationNumber=553461323", "Product=SyntheticaAddons", "LicenseType=Small Business License", "ExpireDate=--.--.----", "MaxVersion=3.4.999"};
        UIManager.put("SyntheticaAddons.license.info", li2);
        UIManager.put("SyntheticaAddons.license.key", "FE7EAEA2-89E80B79-ADAB408D-04EA60BE-56C27104-6888DBA2-731BF526-A2F0D3AD");
        UIManager.put("Synthetica.hiDpiImageScaleFactor", 100);
        UIManager.put("Synthetica.hiDpiImageThreshold", 50);
        UIManager.put("Synthetica.extendedFileChooser.rememberPreferences", false);
        UIManager.put("Synthetica.text.antialias", true);
    }
}

