/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.spinner;

import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.crossplatform.swing.BoundedIntervalAdapter;
import com.macrofocus.util.swing.spinner.SliderWithSpinnerModel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JWindow;
import javax.swing.SpinnerModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;

public final class EnhancedSlider
extends JPanel {
    private JSpinner spinner;
    private final JSlider slider;
    private SliderWithSpinnerModel model;
    private MutableBoundedInterval boundedInterval;
    private final int orientation;

    public EnhancedSlider() {
        this(new SliderWithSpinnerModel(new DefaultBoundedRangeModel(50, 0, 0, 100)), 1, false, false);
    }

    public EnhancedSlider(SliderWithSpinnerModel model, int orientation, boolean drawLabels, boolean showSpinner) {
        assert (model != null);
        assert (orientation == 0 || orientation == 1);
        this.model = model;
        this.orientation = orientation;
        this.setAlignmentY(0.0f);
        this.slider = this.createSlider(model.getBoundedRangeModel(), drawLabels);
        if (showSpinner) {
            this.spinner = EnhancedSlider.createSpinner(model.getSpinnerModel());
        }
        if (orientation == 1) {
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.slider);
            if (showSpinner) {
                this.add(this.spinner);
            }
        } else {
            this.setLayout(new BoxLayout(this, 0));
            if (showSpinner) {
                this.add(this.spinner);
            }
            this.add(this.slider);
        }
    }

    public int getValue() {
        return this.model.getBoundedRangeModel().getValue();
    }

    public void setValue(int value) {
        assert (this.model.getBoundedRangeModel().getMinimum() <= value && value <= this.model.getBoundedRangeModel().getMaximum());
        this.model.getBoundedRangeModel().setValue(value);
    }

    public int getMinimum() {
        return this.model.getBoundedRangeModel().getMinimum();
    }

    public int getMaximum() {
        return this.model.getBoundedRangeModel().getMaximum();
    }

    public void setMinimum(int minimum) {
        this.model.getBoundedRangeModel().setMinimum(minimum);
    }

    public void setMaximum(int maximum) {
        this.model.getBoundedRangeModel().setMaximum(maximum);
    }

    public void addChangeListener(ChangeListener listener) {
        this.slider.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.slider.removeChangeListener(listener);
    }

    private JSlider createSlider(BoundedRangeModel model, boolean drawLabels) {
        JSlider slider = new JSlider(model){
            private SliderPopupListener popupHandler;

            @Override
            public void updateUI() {
                this.removeMouseMotionListener(this.popupHandler);
                this.removeMouseListener(this.popupHandler);
                this.removeMouseWheelListener(this.popupHandler);
                super.updateUI();
                this.popupHandler = new SliderPopupListener();
                this.addMouseMotionListener(this.popupHandler);
                this.addMouseListener(this.popupHandler);
                this.addMouseWheelListener(this.popupHandler);
            }
        };
        slider.setOrientation(0);
        slider.setAlignmentY(0.0f);
        if (drawLabels) {
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            labelTable.put(model.getMinimum(), new JLabel(Integer.valueOf(model.getMinimum()).toString()));
            labelTable.put(model.getMaximum(), new JLabel(Integer.valueOf(model.getMaximum()).toString()));
            slider.setLabelTable(labelTable);
            slider.setPaintLabels(true);
        }
        return slider;
    }

    private static JSpinner createSpinner(SpinnerModel model) {
        JSpinner spinner = new JSpinner(model);
        JFormattedTextField hor_ftf = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
        hor_ftf.setEditable(true);
        return spinner;
    }

    public void setModel(MutableBoundedInterval boundedInterval) {
        this.boundedInterval = boundedInterval;
        this.model = new SliderWithSpinnerModel((BoundedRangeModel)new BoundedIntervalAdapter(boundedInterval, false));
        this.slider.setModel(this.model.getBoundedRangeModel());
        if (this.spinner != null) {
            this.spinner.setModel(this.model.getSpinnerModel());
        }
    }

    class SliderPopupListener
    extends MouseAdapter {
        private JWindow window;
        private JLabel label;
        private final Dimension size = new Dimension(60, 20);
        private Integer prevValue = null;

        protected void updateToolTip(MouseEvent me, boolean center) {
            Point pt;
            JSlider slider = (JSlider)me.getComponent();
            int intValue = slider.getValue();
            if (this.prevValue == null || !this.prevValue.equals(intValue)) {
                if (EnhancedSlider.this.boundedInterval != null) {
                    this.getLabel().setText(NumberFormat.getNumberInstance().format(EnhancedSlider.this.boundedInterval.getStart()));
                } else {
                    double p = ((double)slider.getValue() - (double)slider.getMinimum()) / ((double)slider.getMaximum() - (double)slider.getMinimum());
                    double percent = p - 0.5;
                    this.getLabel().setText(NumberFormat.getPercentInstance().format(percent));
                }
                this.prevValue = intValue;
            }
            if (!center) {
                pt = me.getPoint();
            } else {
                pt = me.getPoint();
                pt.x = slider.getWidth() / 2;
            }
            pt.y = -this.size.height;
            SwingUtilities.convertPointToScreen(pt, me.getComponent());
            pt.translate(-this.size.width / 2, 0);
            this.getWindow().setLocation(pt);
        }

        private JLabel getLabel() {
            if (this.label == null) {
                this.label = new JLabel("", 0);
                this.label.setOpaque(false);
                this.label.setBackground(UIManager.getColor("ToolTip.background"));
                this.label.setBorder(UIManager.getBorder("ToolTip.border"));
            }
            return this.label;
        }

        private JWindow getWindow() {
            if (this.window == null) {
                this.window = new JWindow();
                this.window.add(this.getLabel());
                this.window.setSize(this.size);
            }
            return this.window;
        }

        private void dispose() {
            if (this.window != null) {
                this.window.setVisible(false);
                this.window.dispose();
            }
            this.window = null;
            this.label = null;
            this.prevValue = null;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.getWindow().setVisible(true);
            this.updateToolTip(e, true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.dispose();
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            this.getWindow().setVisible(true);
            this.updateToolTip(me, false);
        }
    }
}

