/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.wizard;

import com.macrofocus.util.wizard.TaskEvent;
import com.macrofocus.util.wizard.TaskListener;
import com.macrofocus.util.wizard.TaskModel;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;

public abstract class AbstractTaskModel
implements TaskModel {
    private final Vector listeners = new Vector();
    private Vector buttons = new Vector();
    private JComponent component;
    private String title = null;
    private String description = null;

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public JButton getButton(int index) {
        return (JButton)this.buttons.elementAt(index);
    }

    @Override
    public int getButtonCount() {
        return this.buttons.size();
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void addTaskListener(TaskListener listener) {
        this.listeners.addElement(listener);
    }

    @Override
    public void removeTaskListener(TaskListener listener) {
        this.listeners.removeElement(listener);
    }

    protected void notifyTaskAborted(TaskEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TaskListener listener = (TaskListener)this.listeners.elementAt(i);
            listener.taskAborted(event);
        }
    }

    protected void notifyTaskCompleted(TaskEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TaskListener listener = (TaskListener)this.listeners.elementAt(i);
            listener.taskCompleted(event);
        }
    }

    protected TaskModel getSelf() {
        return this;
    }

    protected void insertButtonAt(JButton button, int index) {
        this.buttons.insertElementAt(button, index);
    }

    protected void addButton(JButton button) {
        this.buttons.addElement(button);
    }

    protected void setComponent(JComponent component) {
        this.component = component;
    }
}

