/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.wizard;

import com.macrofocus.layoutmanager.FixedProportionalConstraint;
import com.macrofocus.layoutmanager.HorizontalProportionalLayoutManager;
import com.macrofocus.layoutmanager.PreferredProportionalConstraint;
import com.macrofocus.layoutmanager.RelativeProportionalConstraint;
import com.macrofocus.layoutmanager.VerticalProportionalLayoutManager;
import com.macrofocus.util.wizard.TaskModel;
import com.macrofocus.util.wizard.Wizard;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;

public class SimpleWizard
extends Wizard {
    private JComponent taskContainer;
    private JComponent buttonContainer;
    private JFrame frame;
    private String applicationTitle;
    private JPanel headerContainer;
    private JLabel titleLabel;
    private JTextArea descriptionLabel;
    private JComponent logo;
    private Color backgroundColor = new Color(0, 102, 153);

    public SimpleWizard(JFrame frame, String applicationTitle) {
        this.frame = frame;
        this.applicationTitle = applicationTitle;
        this.setLayout((LayoutManager)new VerticalProportionalLayoutManager());
        this.headerContainer = new JPanel();
        this.headerContainer.setOpaque(true);
        this.headerContainer.setBackground(Color.white);
        this.taskContainer = new JPanel();
        this.buttonContainer = new JPanel();
        JPanel bottomContainer = new JPanel();
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(new Font("Arial", 1, 24));
        this.titleLabel.setBackground(Color.white);
        this.titleLabel.setForeground(Color.black);
        this.descriptionLabel = new JTextArea();
        this.descriptionLabel.setEditable(false);
        this.descriptionLabel.setFocusable(false);
        this.descriptionLabel.setBorder(null);
        this.descriptionLabel.setCaretPosition(0);
        this.descriptionLabel.setLineWrap(true);
        this.descriptionLabel.setWrapStyleWord(true);
        this.descriptionLabel.setFont(new Font("Arial", 0, 12));
        this.descriptionLabel.setBackground(Color.white);
        this.descriptionLabel.setForeground(Color.black);
        this.headerContainer.setLayout((LayoutManager)new VerticalProportionalLayoutManager());
        this.taskContainer.setLayout((LayoutManager)new HorizontalProportionalLayoutManager());
        this.buttonContainer.setLayout((LayoutManager)new HorizontalProportionalLayoutManager());
        bottomContainer.setLayout((LayoutManager)new VerticalProportionalLayoutManager());
        this.headerContainer.add((Component)this.titleLabel, new PreferredProportionalConstraint(16, 16, 16, 16));
        this.headerContainer.add((Component)this.descriptionLabel, new PreferredProportionalConstraint(0, 32, 16, 16));
        this.headerContainer.validate();
        this.add((Component)this.headerContainer, new PreferredProportionalConstraint());
        this.add((Component)new JSeparator(), new PreferredProportionalConstraint(0, 0, 0, 0));
        this.add((Component)this.taskContainer, new RelativeProportionalConstraint(16, 32, 16, 16));
        this.add((Component)new JSeparator(), new PreferredProportionalConstraint(0, 32, 0, 16));
        bottomContainer.add((Component)this.buttonContainer, new PreferredProportionalConstraint(4, 32, 4, 11));
        this.add((Component)bottomContainer, new PreferredProportionalConstraint());
        this.titleLabel.setVisible(false);
        this.descriptionLabel.setVisible(false);
        this.validate();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        super.paint(g2);
    }

    @Override
    public void setTaskModel(Object source, final TaskModel taskModel) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (taskModel.getTitle() != null) {
                    SimpleWizard.this.frame.setTitle(SimpleWizard.this.applicationTitle + " - " + taskModel.getTitle());
                    SimpleWizard.this.titleLabel.setText(taskModel.getTitle());
                    SimpleWizard.this.titleLabel.setVisible(true);
                } else {
                    SimpleWizard.this.frame.setTitle(SimpleWizard.this.applicationTitle);
                    SimpleWizard.this.titleLabel.setVisible(false);
                }
                if (taskModel.getDescription() != null) {
                    SimpleWizard.this.descriptionLabel.setText(taskModel.getDescription());
                    SimpleWizard.this.descriptionLabel.setVisible(true);
                } else {
                    SimpleWizard.this.descriptionLabel.setVisible(false);
                }
                SimpleWizard.this.headerContainer.repaint();
                SimpleWizard.this.taskContainer.setVisible(false);
                SimpleWizard.this.buttonContainer.setVisible(false);
                SimpleWizard.this.taskContainer.removeAll();
                SimpleWizard.this.taskContainer.setLayout(new OverlayLayout(SimpleWizard.this.taskContainer));
                SimpleWizard.this.taskContainer.add(taskModel.getComponent());
                SimpleWizard.this.taskContainer.validate();
                SimpleWizard.this.buttonContainer.removeAll();
                SimpleWizard.this.buttonContainer.setLayout((LayoutManager)new HorizontalProportionalLayoutManager());
                if (SimpleWizard.this.logo != null) {
                    SimpleWizard.this.buttonContainer.add((Component)SimpleWizard.this.logo, new FixedProportionalConstraint(170, 0, 0, 0, 0));
                }
                JPanel filler = new JPanel();
                filler.setOpaque(false);
                SimpleWizard.this.buttonContainer.add((Component)filler, new RelativeProportionalConstraint());
                for (int i = 0; i < taskModel.getButtonCount(); ++i) {
                    SimpleWizard.this.buttonContainer.add((Component)taskModel.getButton(i), new PreferredProportionalConstraint(5, 5, 5, 5));
                }
                SimpleWizard.this.buttonContainer.validate();
                SimpleWizard.this.taskContainer.setVisible(true);
                SimpleWizard.this.buttonContainer.setVisible(true);
                SimpleWizard.this.validate();
                SimpleWizard.this.repaint();
            }
        });
    }

    @Override
    public void setLogo(Object source, JComponent logo) {
        this.logo = logo;
    }
}

