/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.action.export;

import com.treemap.app.swing.action.export.TableWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class JSONTableWriter
implements TableWriter {
    private final FileWriter writer;
    private int columnCount;
    private Map<Integer, String> columnNames;
    private String newLine;
    private int row = 0;
    private int column = 0;
    private static DecimalFormat decimalFormat = new DecimalFormat("#################0.#################", new DecimalFormatSymbols(Locale.ENGLISH));

    public JSONTableWriter(FileWriter writer, int columnCount, String newLine) throws IOException {
        this.writer = writer;
        this.columnCount = columnCount;
        this.columnNames = new HashMap<Integer, String>();
        this.newLine = newLine;
        writer.write("{");
        writer.write(newLine);
        writer.write("\t\"data\": [");
        writer.write(newLine);
    }

    @Override
    public void writeColumnName(String name, boolean hasMore) throws IOException {
        this.columnNames.put(this.column, name);
        ++this.column;
    }

    @Override
    public void writeType(String name, boolean hasMore) throws IOException {
    }

    @Override
    public void writeCell(Object value) throws IOException {
        Object str;
        if (this.column == 0) {
            if (this.row > 1) {
                this.writer.write("},");
            }
            this.writer.write(this.newLine);
            this.writer.write("\t\t{");
        } else {
            this.writer.write(", ");
        }
        if (value == null) {
            str = "null";
        } else if (value instanceof Date) {
            str = "\"" + JSONTableWriter.dateToString((Date)value) + "\"";
        } else if (value instanceof Number) {
            str = JSONTableWriter.numberToString((Number)value);
        } else if (value instanceof Boolean) {
            str = value.toString();
        } else if (value instanceof String[]) {
            String[] array = (String[])value;
            str = "[";
            for (int i = 0; i < array.length; ++i) {
                String s = array[i];
                str = (String)str + "\"" + JSONTableWriter.quote(s) + "\"";
                if (i >= array.length - 1) continue;
                str = (String)str + ", ";
            }
            str = (String)str + "]";
        } else {
            str = value.toString();
            str = ((String)str).length() > 0 ? "\"" + JSONTableWriter.quote((String)str) + "\"" : "null";
        }
        this.writer.write("\"" + this.columnNames.get(this.column) + "\": ");
        this.writer.write((String)str);
    }

    private static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        block9: for (int i = 0; i < len; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void nextColumn(boolean hasMore) throws IOException {
        ++this.column;
    }

    @Override
    public void nextRow() throws IOException {
        this.column = 0;
        ++this.row;
    }

    @Override
    public void close() throws IOException {
        if (this.row > 1) {
            this.writer.write("}");
        }
        this.writer.write(this.newLine);
        this.writer.write("\t]");
        this.writer.write(this.newLine);
        this.writer.write("}");
        this.writer.close();
    }

    public static String numberToString(Number value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Double) {
            double v = value.doubleValue();
            if (Double.isNaN(v) || Double.isInfinite(v)) {
                return decimalFormat.format(value);
            }
            return new BigDecimal(v, new MathContext(15, RoundingMode.HALF_EVEN)).stripTrailingZeros().toPlainString();
        }
        if (value instanceof Float) {
            float v = value.floatValue();
            if (Float.isNaN(v) || Float.isInfinite(v)) {
                return decimalFormat.format(value);
            }
            return new BigDecimal(v, new MathContext(6, RoundingMode.HALF_EVEN)).stripTrailingZeros().toPlainString();
        }
        if (value instanceof Long) {
            long v = value.longValue();
            return Long.toString(v);
        }
        if (value instanceof Integer) {
            int v = value.intValue();
            return Integer.toString(v);
        }
        if (value instanceof Byte) {
            byte v = value.byteValue();
            return Byte.toString(v);
        }
        if (value instanceof Short) {
            short v = value.shortValue();
            return Short.toString(v);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        return value.toString();
    }

    public static String dateToString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat fullDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        if (date.getHours() != 0 || date.getMinutes() != 0 || date.getSeconds() != 0) {
            return fullDateFormat.format(date);
        }
        return dateFormat.format(date);
    }
}

