/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jidesoft.converter.ObjectConverter;
import com.macrofocus.combobox.MJYComboBox;
import com.macrofocus.combobox.MListComboBox;
import com.macrofocus.combobox.SmallColorJYComboBox;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.crossplatform.swing.ColorComboBoxModel;
import com.macrofocus.crossplatform.swing.FontComboBoxModel;
import com.macrofocus.crossplatform.swing.MJPanel;
import com.macrofocus.crossplatform.swing.MJSpinner;
import com.macrofocus.crossplatform.swing.PropertySpinnerNumberModel;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.labeling.EnhancedLabel;
import com.macrofocus.selection.swing.SingleSelectionComboBoxModel;
import com.macrofocus.swing.MDefaultOverlayable;
import com.macrofocus.swing.MOverlayableIconsFactory;
import com.treemap.Algorithm;
import com.treemap.AlgorithmFactory;
import com.treemap.LabelingFactory;
import com.treemap.NestingFactory;
import com.treemap.Ordering;
import com.treemap.OrderingFactory;
import com.treemap.ScaleFactory;
import com.treemap.TreeMapEvent;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapListener;
import com.treemap.TreeMapModel;
import com.treemap.app.swing.configuration.ConverterListCellRenderer;
import com.treemap.app.swing.configuration.LayoutSettingsPanel;
import com.treemap.app.swing.v4.settings.aggregation.MAggregationFactory;
import com.treemap.swing.SwingAlgorithmFactory;
import de.javasoft.combobox.JYComboBox;
import de.javasoft.combobox.controls.FontComboBoxEditor;
import de.javasoft.combobox.controls.FontComboBoxRenderer;
import de.javasoft.combobox.controls.FontPopupPanel;
import de.javasoft.switchbutton.JYSwitchButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GroupBySettingsPanel {
    private JPanel mainPanel;
    private JCheckBox overrideCommonSettings;
    private MJYComboBox layoutComboBox;
    private SmallColorJYComboBox backgroundComboBox;
    private SmallColorJYComboBox effectComboBox;
    private SmallColorJYComboBox foregroundComboBox;
    private MJYComboBox fontComboBox;
    private JSpinner minimumNumberOfCharactersSpinner;
    private MJYComboBox horizontalAlignmentComboBox;
    private MJYComboBox overflowComboBox;
    private MJYComboBox verticalAlgnmentComboBox;
    private MListComboBox aggregationComboBox;
    private MJYComboBox nestingComboBox;
    private MJYComboBox orderingComboBox;
    private MListComboBox scaleComboBox;
    private MJYComboBox placementComboBox;
    private SmallColorJYComboBox nestingBackgroundComboBox;
    private MJYComboBox horizontalVanishingPointComboBox;
    private MJYComboBox verticalVanishingPointComboBox;
    private JLabel vanishingPointLabel;
    private MJYComboBox orderingDirectionComboBox;
    private JButton resetButton;
    private JSpinner nestingAmountSpinner;
    private MDefaultOverlayable layoutPanel;
    private JLabel label;
    private final AlgorithmFactory algorithmFactory;
    private final TreeMapModel treeMapModel;
    private final TreeMapField field;
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public GroupBySettingsPanel(TreeMapModel treeMapModel, TreeMapField field, AlgorithmFactory algorithmFactory) {
        this.treeMapModel = treeMapModel;
        this.field = field;
        this.algorithmFactory = algorithmFactory;
        this.$$$setupUI$$$();
        final TreeMapFieldSettings settings = treeMapModel.getSettings().getFieldSettings(field);
        settings.getProperties().addPropertiesListener(new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                if ("overrideDefaults".equals("overrideDefaults")) {
                    GroupBySettingsPanel.this.overrideCommonSettings.setSelected(settings.isOverrideDefaults());
                }
            }
        });
        this.overrideCommonSettings.setSelected(settings.isOverrideDefaults());
        this.overrideCommonSettings.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                settings.setOverrideDefaults(GroupBySettingsPanel.this.overrideCommonSettings.isSelected());
            }
        });
        this.bindUI();
        this.fontComboBox.setRenderer((ListCellRenderer)new FontComboBoxRenderer(this.fontComboBox.getRenderer()));
        this.fontComboBox.setEditor((ComboBoxEditor)new FontComboBoxEditor(this.fontComboBox.getEditor(), null, false));
        this.fontComboBox.setPopupComponent((JComponent)new FontPopupPanel((JYComboBox)this.fontComboBox));
        this.effectComboBox.setAcceptNullValue(true);
        this.mainPanel.setBorder(new TitledBorder(""));
        this.foregroundComboBox.setColorValueVisible(false);
        this.resetButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                settings.reset();
            }
        }, (Object)this.resetButton));
        treeMapModel.addListener(new TreeMapListener(){

            public void tableModelChanged() {
            }

            public void treeMapChanged(TreeMapEvent event) {
                if (event.isLayoutChanged()) {
                    GroupBySettingsPanel.this.updateOverlay();
                }
            }
        });
        this.updateOverlay();
    }

    private void updateOverlay() {
        Algorithm parentAlgorithm = this.treeMapModel.getSettings().getDefaultFieldSettings().getAlgorithm();
        int index = -1;
        TreeMapField[] groupByTreeMapFields = this.treeMapModel.getSettings().getGroupByTreeMapFields();
        if (groupByTreeMapFields != null) {
            for (int i = 1; i < groupByTreeMapFields.length; ++i) {
                TreeMapField treeMapField = groupByTreeMapFields[i];
                if (treeMapField != this.field) continue;
                index = i;
            }
        }
        if (index > 0) {
            parentAlgorithm = this.treeMapModel.getSettings().getFieldSettings(groupByTreeMapFields[index - 1]).getAlgorithm();
        }
        Algorithm algorithm = this.treeMapModel.getSettings().getFieldSettings(this.field).getAlgorithm();
        boolean isCompatible = true;
        isCompatible = isCompatible && (algorithm != AlgorithmFactory.CIRCULAR || parentAlgorithm == AlgorithmFactory.CIRCULAR);
        isCompatible = isCompatible && algorithm != AlgorithmFactory.BAR;
        isCompatible = isCompatible && (algorithm != AlgorithmFactory.PIE || parentAlgorithm == AlgorithmFactory.CIRCULAR);
        isCompatible = isCompatible && (algorithm == AlgorithmFactory.CIRCULAR || algorithm == AlgorithmFactory.PIE || algorithm == SwingAlgorithmFactory.VORONOI || parentAlgorithm != AlgorithmFactory.CIRCULAR);
        isCompatible = isCompatible && (algorithm != SwingAlgorithmFactory.VORONOI || parentAlgorithm == SwingAlgorithmFactory.VORONOI);
        this.label.setToolTipText("Layout type is incompatible with parent.\nAreas of items across groups cannot be accurately compared");
        this.layoutPanel.setOverlayVisible(!isCompatible);
    }

    private void bindUI() {
        final TreeMapFieldSettings settings = this.treeMapModel.getSettings().getFieldSettings(this.field);
        this.layoutComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getAlgorithmProperty(), (Iterable)this.algorithmFactory.getAlgorithms()));
        this.aggregationComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getAggregationProperty(), (Iterable)MAggregationFactory.getInstance().getAggregations()));
        this.nestingComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getNestingProperty(), (Iterable)NestingFactory.getInstance().getNestings()));
        this.orderingComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getOrderingProperty(), (Iterable)OrderingFactory.getInstance().getOrderings()));
        this.orderingDirectionComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getOrderingDirectionProperty(), (Object[])Ordering.SortOrder.values()));
        this.horizontalVanishingPointComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getOrderingHorizontalVanishingPointProperty(), (Object[])new Integer[]{2, 0, 4}));
        this.horizontalVanishingPointComboBox.setRenderer(new ConverterListCellRenderer(this.horizontalVanishingPointComboBox.getRenderer(), (ObjectConverter)LayoutSettingsPanel.horitzonalAlignmentConverter));
        this.verticalVanishingPointComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getOrderingVerticalVanishingPointProperty(), (Object[])new Integer[]{1, 0, 3}));
        this.verticalVanishingPointComboBox.setRenderer(new ConverterListCellRenderer(this.verticalVanishingPointComboBox.getRenderer(), (ObjectConverter)LayoutSettingsPanel.verticalAlignmentConverter));
        this.scaleComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getScaleProperty(), (Iterable)ScaleFactory.getInstance().getScales()));
        this.minimumNumberOfCharactersSpinner.setModel((SpinnerModel)new PropertySpinnerNumberModel(settings.getHeaderMinimumCharactersToDisplayProperty()));
        this.placementComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getLabelingProperty(), (Iterable)LabelingFactory.getInstance().getLabelings()));
        this.horizontalAlignmentComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getHeaderHorizontalAlignmentProperty(), (Object[])new Integer[]{2, 0, 4}));
        this.horizontalAlignmentComboBox.setRenderer(new ConverterListCellRenderer(this.horizontalAlignmentComboBox.getRenderer(), (ObjectConverter)LayoutSettingsPanel.horitzonalAlignmentConverter));
        this.overflowComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getHeaderRenderingProperty(), (Object[])EnhancedLabel.Rendering.values()));
        this.verticalAlgnmentComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getHeaderVerticalAlignmentProperty(), (Object[])new Integer[]{1, 0, 3}));
        this.verticalAlgnmentComboBox.setRenderer(new ConverterListCellRenderer(this.verticalAlgnmentComboBox.getRenderer(), (ObjectConverter)LayoutSettingsPanel.verticalAlignmentConverter));
        this.backgroundComboBox.setModel(new ColorComboBoxModel(settings.getHeaderBackgroundProperty()));
        this.effectComboBox.setModel(new ColorComboBoxModel(settings.getHeaderEffectColorProperty()));
        FontComboBoxModel fontComboBoxModel = new FontComboBoxModel(settings.getHeaderFontProperty());
        this.fontComboBox.setModel((ComboBoxModel)fontComboBoxModel);
        this.foregroundComboBox.setModel(new ColorComboBoxModel(settings.getHeaderForegroundProperty()));
        this.nestingAmountSpinner.setModel((SpinnerModel)new PropertySpinnerNumberModel(settings.getNestingAmountProperty()));
        this.nestingBackgroundComboBox.setModel(new ColorComboBoxModel(settings.getNestingBackgroundProperty()));
        JComponent editor = this.nestingAmountSpinner.getEditor();
        JFormattedTextField tf = ((JSpinner.DefaultEditor)editor).getTextField();
        tf.setColumns(3);
        settings.getAlgorithmProperty().addPropertyListener((PropertyListener)new PropertyListener<Algorithm>(){

            public void propertyChanged(PropertyEvent<Algorithm> event) {
                GroupBySettingsPanel.this.updateVanishingPoint((TreeMapFieldSettings<Color, Font>)settings);
            }
        });
    }

    private void updateVanishingPoint(TreeMapFieldSettings<Color, Font> settings) {
        boolean enabled = settings.getAlgorithm() == AlgorithmFactory.SQUARIFIED || settings.getAlgorithm() == AlgorithmFactory.SQUARIFIEDPLUS;
        this.vanishingPointLabel.setEnabled(enabled);
        this.horizontalVanishingPointComboBox.setEnabled(enabled);
        this.verticalVanishingPointComboBox.setEnabled(enabled);
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private void createUIComponents() {
        this.mainPanel = new MJPanel();
        this.overrideCommonSettings = new JYSwitchButton();
        this.layoutComboBox = new MJYComboBox();
        this.label = new JLabel(MOverlayableIconsFactory.getAttention());
        this.layoutPanel = new MDefaultOverlayable((JComponent)this.layoutComboBox, (JComponent)this.label, 3);
        this.layoutPanel.setOverlayLocationInsets(new Insets(0, 0, 0, -24));
        this.minimumNumberOfCharactersSpinner = new MJSpinner();
        this.nestingAmountSpinner = new MJSpinner();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, 2));
        Spacer spacer1 = new Spacer();
        this.mainPanel.add((Component)spacer1, new GridConstraints(8, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, 2));
        this.mainPanel.add((Component)panel1, new GridConstraints(7, 0, 1, 2, 0, 3, 5, 3, new Dimension(0, -1), null, null, 0, true));
        panel1.setBorder(BorderFactory.createTitledBorder(null, "Header", 0, 0, null, null));
        JLabel label1 = new JLabel();
        label1.setText("Placement:");
        label1.setToolTipText("Placement");
        panel1.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Alignment:");
        label2.setToolTipText("Alignment");
        panel1.add((Component)label2, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JLabel label3 = new JLabel();
        label3.setText("Overflow:");
        label3.setToolTipText("Overflow");
        panel1.add((Component)label3, new GridConstraints(3, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        this.placementComboBox = new MJYComboBox();
        panel1.add((Component)this.placementComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(50, -1), null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.horizontalAlignmentComboBox = new MJYComboBox();
        panel2.add((Component)this.horizontalAlignmentComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), null, null, 0, false));
        this.verticalAlgnmentComboBox = new MJYComboBox();
        panel2.add((Component)this.verticalAlgnmentComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1));
        panel3.setToolTipText("Effect color");
        panel1.add((Component)panel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        JLabel label4 = new JLabel();
        label4.setIcon(new ImageIcon(this.getClass().getResource("/com/treemap/app/swing/configuration/font24.png")));
        label4.setText("");
        label4.setToolTipText("Font");
        panel3.add((Component)label4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1, false));
        this.fontComboBox = new MJYComboBox();
        panel3.add((Component)this.fontComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 5, 3, new Dimension(0, -1), null, null, 0, false));
        this.foregroundComboBox = new SmallColorJYComboBox();
        panel3.add((Component)this.foregroundComboBox, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 3, null, new Dimension(20, -1), null, 0, false));
        this.backgroundComboBox = new SmallColorJYComboBox();
        panel3.add((Component)this.backgroundComboBox, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 3, null, new Dimension(20, -1), null, 0, false));
        this.effectComboBox = new SmallColorJYComboBox();
        panel3.add((Component)this.effectComboBox, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 3, null, new Dimension(20, -1), null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel4, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.overflowComboBox = new MJYComboBox();
        panel4.add((Component)this.overflowComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(50, -1), null, 0, false));
        this.minimumNumberOfCharactersSpinner.setToolTipText("Minimum number of characters to display");
        panel4.add((Component)this.minimumNumberOfCharactersSpinner, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, new Dimension(0, -1), null, null, 0, false));
        JLabel label5 = new JLabel();
        label5.setText("Aggregation:");
        label5.setVisible(false);
        this.mainPanel.add((Component)label5, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JLabel label6 = new JLabel();
        label6.setText("Nesting: ");
        label6.setToolTipText("Nesting");
        this.mainPanel.add((Component)label6, new GridConstraints(3, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JLabel label7 = new JLabel();
        label7.setText("Ordering:");
        label7.setToolTipText("Ordering");
        this.mainPanel.add((Component)label7, new GridConstraints(4, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JLabel label8 = new JLabel();
        label8.setText("Scale:");
        label8.setVisible(false);
        this.mainPanel.add((Component)label8, new GridConstraints(6, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        this.aggregationComboBox = new MListComboBox();
        this.aggregationComboBox.setVisible(false);
        this.mainPanel.add((Component)this.aggregationComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.scaleComboBox = new MListComboBox();
        this.scaleComboBox.setVisible(false);
        this.mainPanel.add((Component)this.scaleComboBox, new GridConstraints(6, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JLabel label9 = new JLabel();
        label9.setText("Layout:");
        label9.setToolTipText("Layout");
        label9.setVisible(true);
        this.mainPanel.add((Component)label9, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JPanel panel5 = new JPanel();
        panel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel5, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        this.nestingComboBox = new MJYComboBox();
        panel5.add((Component)this.nestingComboBox, new GridConstraints(0, 0, 1, 1, 8, 3, 5, 0, new Dimension(0, -1), new Dimension(50, -1), null, 0, false));
        this.nestingBackgroundComboBox = new SmallColorJYComboBox();
        panel5.add((Component)this.nestingBackgroundComboBox, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 3, null, new Dimension(20, -1), null, 0, false));
        this.nestingAmountSpinner.setToolTipText("Nesting amount");
        panel5.add((Component)this.nestingAmountSpinner, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, new Dimension(0, -1), null, null, 0, false));
        this.vanishingPointLabel = new JLabel();
        this.vanishingPointLabel.setText("Vanishing Point:");
        this.vanishingPointLabel.setToolTipText("Alignment");
        this.mainPanel.add((Component)this.vanishingPointLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JPanel panel6 = new JPanel();
        panel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel6, new GridConstraints(5, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.horizontalVanishingPointComboBox = new MJYComboBox();
        panel6.add((Component)this.horizontalVanishingPointComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), null, null, 0, false));
        this.verticalVanishingPointComboBox = new MJYComboBox();
        panel6.add((Component)this.verticalVanishingPointComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), null, null, 0, false));
        JPanel panel7 = new JPanel();
        panel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel7, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.orderingComboBox = new MJYComboBox();
        panel7.add((Component)this.orderingComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(50, -1), null, 0, false));
        this.orderingDirectionComboBox = new MJYComboBox();
        panel7.add((Component)this.orderingDirectionComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(50, -1), null, 0, false));
        JPanel panel8 = new JPanel();
        panel8.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel8, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        this.overrideCommonSettings.setSelected(false);
        this.overrideCommonSettings.setText("Override Defaults");
        panel8.add((Component)this.overrideCommonSettings, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, new Dimension(0, -1), null, null, 1, false));
        Spacer spacer2 = new Spacer();
        panel8.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.resetButton = new JButton();
        this.resetButton.setEnabled(true);
        this.resetButton.setText("Reset");
        panel8.add((Component)this.resetButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 1, false));
        this.mainPanel.add((Component)this.layoutPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

