/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jidesoft.converter.EnumConverter;
import com.jidesoft.converter.ObjectConverter;
import com.macrofocus.combobox.MColorComboBox;
import com.macrofocus.combobox.MJYComboBox;
import com.macrofocus.combobox.MListComboBox;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.crossplatform.swing.ColorComboBoxModel;
import com.macrofocus.crossplatform.swing.FontComboBoxModel;
import com.macrofocus.crossplatform.swing.MJPanel;
import com.macrofocus.crossplatform.swing.MJSpinner;
import com.macrofocus.crossplatform.swing.PropertySpinnerNumberModel;
import com.macrofocus.labeling.EnhancedLabel;
import com.macrofocus.selection.swing.SingleSelectionComboBoxModel;
import com.treemap.AlgorithmFactory;
import com.treemap.LabelingFactory;
import com.treemap.NestingFactory;
import com.treemap.Ordering;
import com.treemap.OrderingFactory;
import com.treemap.ScaleFactory;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.app.swing.configuration.ConverterListCellRenderer;
import com.treemap.app.swing.configuration.SquarifiedPropertiesPanel;
import com.treemap.app.swing.configuration.TagCloudPropertiesPanel;
import com.treemap.app.swing.v4.settings.aggregation.MAggregationFactory;
import com.treemap.swing.SwingAlgorithmFactory;
import de.javasoft.combobox.JYComboBox;
import de.javasoft.combobox.controls.FontComboBoxEditor;
import de.javasoft.combobox.controls.FontComboBoxRenderer;
import de.javasoft.combobox.controls.FontPopupPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.OverlayLayout;
import javax.swing.SpinnerModel;
import javax.swing.border.TitledBorder;

public class LayoutSettingsPanel {
    public static final EnumConverter horitzonalAlignmentConverter = new EnumConverter("Horizontal", Integer.class, new Object[]{2, 0, 4}, new String[]{"Left", "Center", "Right"});
    public static final EnumConverter verticalAlignmentConverter = new EnumConverter("Vertical", Integer.class, new Object[]{1, 0, 3}, new String[]{"Top", "Center", "Bottom"});
    private JPanel mainPanel;
    private MListComboBox aggregationComboBox;
    private MListComboBox nestingComboBox;
    private MJYComboBox orderingComboBox;
    private MListComboBox scaleComboBox;
    private JSpinner minimumNumberOfCharactersSpinner;
    private MListComboBox placementComboBox;
    private MListComboBox horizontalAlignmentComboBox;
    private MListComboBox overflowComboBox;
    private MListComboBox verticalAlgnmentComboBox;
    private MColorComboBox backgroundComboBox;
    private MColorComboBox effectComboBox;
    private MJYComboBox fontComboBox;
    private MColorComboBox foregroundComboBox;
    private MJYComboBox horizontalVanishingPointComboBox;
    private MJYComboBox verticalVanishingPointComboBox;
    private JLabel vanishingPointLabel;
    private MJYComboBox orderingDirectionComboBox;
    private JPanel propertiesPanel;
    private MColorComboBox bgComboBox;
    private JLabel bgLabel;

    public LayoutSettingsPanel(TreeMapModel treeMapModel) {
        this.$$$setupUI$$$();
        this.fontComboBox.setRenderer((ListCellRenderer)new FontComboBoxRenderer(this.fontComboBox.getRenderer()));
        this.fontComboBox.setEditor((ComboBoxEditor)new FontComboBoxEditor(this.fontComboBox.getEditor(), null, false));
        this.fontComboBox.setPopupComponent((JComponent)new FontPopupPanel((JYComboBox)this.fontComboBox));
        final TreeMapFieldSettings settings = treeMapModel.getSettings().getDefaultFieldSettings();
        this.aggregationComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getAggregationProperty(), (Iterable)MAggregationFactory.getInstance().getAggregations()));
        this.nestingComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getNestingProperty(), (Iterable)NestingFactory.getInstance().getNestings()));
        this.orderingComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getOrderingProperty(), (Iterable)OrderingFactory.getInstance().getOrderings()));
        this.orderingDirectionComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getOrderingDirectionProperty(), (Object[])Ordering.SortOrder.values()));
        this.horizontalVanishingPointComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getOrderingHorizontalVanishingPointProperty(), (Object[])new Integer[]{2, 0, 4}));
        this.horizontalVanishingPointComboBox.setRenderer(new ConverterListCellRenderer(this.horizontalVanishingPointComboBox.getRenderer(), (ObjectConverter)horitzonalAlignmentConverter));
        this.verticalVanishingPointComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getOrderingVerticalVanishingPointProperty(), (Object[])new Integer[]{1, 0, 3}));
        this.verticalVanishingPointComboBox.setRenderer(new ConverterListCellRenderer(this.verticalVanishingPointComboBox.getRenderer(), (ObjectConverter)verticalAlignmentConverter));
        this.scaleComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getScaleProperty(), (Iterable)ScaleFactory.getInstance().getScales()));
        this.minimumNumberOfCharactersSpinner.setModel((SpinnerModel)new PropertySpinnerNumberModel(settings.getHeaderMinimumCharactersToDisplayProperty()));
        this.placementComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getLabelingProperty(), (Iterable)LabelingFactory.getInstance().getLabelings()));
        this.horizontalAlignmentComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getHeaderHorizontalAlignmentProperty(), (Object[])new Integer[]{2, 0, 4}));
        this.horizontalAlignmentComboBox.setConverter((ObjectConverter)horitzonalAlignmentConverter);
        this.overflowComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getHeaderRenderingProperty(), (Object[])EnhancedLabel.Rendering.values()));
        this.verticalAlgnmentComboBox.setModel((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getHeaderVerticalAlignmentProperty(), (Object[])new Integer[]{1, 0, 3}));
        this.verticalAlgnmentComboBox.setConverter((ObjectConverter)verticalAlignmentConverter);
        this.backgroundComboBox.setModel((ComboBoxModel)new ColorComboBoxModel(settings.getHeaderBackgroundProperty()));
        this.effectComboBox.setModel((ComboBoxModel)new ColorComboBoxModel(settings.getHeaderEffectColorProperty()));
        FontComboBoxModel headerFontComboBoxModel = new FontComboBoxModel(settings.getHeaderFontProperty());
        this.fontComboBox.setModel((ComboBoxModel)headerFontComboBoxModel);
        this.foregroundComboBox.setModel((ComboBoxModel)new ColorComboBoxModel(settings.getHeaderForegroundProperty()));
        this.bgComboBox.setModel((ComboBoxModel)new ColorComboBoxModel(treeMapModel.getSettings().getBackgroundProperty()));
        settings.getAlgorithmProperty().addPropertyListener(new PropertyListener(){

            public void propertyChanged(PropertyEvent event) {
                LayoutSettingsPanel.this.updateBackground((TreeMapFieldSettings<Color, Font>)settings);
                LayoutSettingsPanel.this.updateVanishingPoint((TreeMapFieldSettings<Color, Font>)settings);
            }
        });
        this.updateBackground((TreeMapFieldSettings<Color, Font>)settings);
        this.updateVanishingPoint((TreeMapFieldSettings<Color, Font>)settings);
        this.mainPanel.setBorder(new TitledBorder(""));
    }

    private void updateBackground(TreeMapFieldSettings<Color, Font> settings) {
        boolean enabled = settings.getAlgorithm() != null && !settings.getAlgorithm().isSpaceFilling();
        this.bgLabel.setEnabled(enabled);
        this.bgComboBox.setEnabled(enabled);
        this.bgComboBox.setEditable(enabled);
    }

    private void updateVanishingPoint(TreeMapFieldSettings<Color, Font> settings) {
        boolean enabled = settings.getAlgorithm() == AlgorithmFactory.SQUARIFIED || settings.getAlgorithm() == AlgorithmFactory.SQUARIFIEDPLUS;
        this.vanishingPointLabel.setEnabled(enabled);
        this.horizontalVanishingPointComboBox.setEnabled(enabled);
        this.verticalVanishingPointComboBox.setEnabled(enabled);
        this.propertiesPanel.removeAll();
        if (settings.getAlgorithm() == SwingAlgorithmFactory.TAG_CLOUD) {
            this.propertiesPanel.setLayout(new OverlayLayout(this.propertiesPanel));
            this.propertiesPanel.add(new TagCloudPropertiesPanel(settings.getAlgorithm()).getMainPanel());
            this.propertiesPanel.validate();
        } else if (settings.getAlgorithm() == AlgorithmFactory.SQUARIFIED || settings.getAlgorithm() == AlgorithmFactory.SQUARIFIEDPLUS) {
            this.propertiesPanel.setLayout(new OverlayLayout(this.propertiesPanel));
            this.propertiesPanel.add(new SquarifiedPropertiesPanel(settings.getAlgorithm()).getMainPanel());
            this.propertiesPanel.validate();
        }
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, 2));
        JLabel label1 = new JLabel();
        label1.setText("Aggregation:");
        label1.setVisible(false);
        this.mainPanel.add((Component)label1, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.mainPanel.add((Component)spacer1, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Nesting: ");
        label2.setVisible(false);
        this.mainPanel.add((Component)label2, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label3 = new JLabel();
        label3.setText("Ordering:");
        this.mainPanel.add((Component)label3, new GridConstraints(3, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label4 = new JLabel();
        label4.setText("Scale:");
        label4.setVisible(false);
        this.mainPanel.add((Component)label4, new GridConstraints(5, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        this.aggregationComboBox = new MListComboBox();
        this.aggregationComboBox.setVisible(false);
        this.mainPanel.add((Component)this.aggregationComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.nestingComboBox = new MListComboBox();
        this.nestingComboBox.setVisible(false);
        this.mainPanel.add((Component)this.nestingComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.scaleComboBox = new MListComboBox();
        this.scaleComboBox.setVisible(false);
        this.mainPanel.add((Component)this.scaleComboBox, new GridConstraints(5, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.setVisible(false);
        this.mainPanel.add((Component)panel1, new GridConstraints(7, 0, 1, 2, 0, 3, 5, 3, null, null, null, 0, true));
        panel1.setBorder(BorderFactory.createTitledBorder(null, "Header", 0, 0, null, null));
        JLabel label5 = new JLabel();
        label5.setText("Background:");
        panel1.add((Component)label5, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label6 = new JLabel();
        label6.setText("Effect Color:");
        panel1.add((Component)label6, new GridConstraints(1, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label7 = new JLabel();
        label7.setText("Font:");
        panel1.add((Component)label7, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label8 = new JLabel();
        label8.setText("Foreground:");
        panel1.add((Component)label8, new GridConstraints(3, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label9 = new JLabel();
        label9.setText("Placement:");
        panel1.add((Component)label9, new GridConstraints(4, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label10 = new JLabel();
        label10.setText("Horizontal Alignment:");
        panel1.add((Component)label10, new GridConstraints(5, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label11 = new JLabel();
        label11.setText("Min number of characters:");
        panel1.add((Component)label11, new GridConstraints(6, 0, 1, 1, 8, 0, 1, 0, new Dimension(0, -1), null, null, 0, false));
        JLabel label12 = new JLabel();
        label12.setText("Overflow:");
        panel1.add((Component)label12, new GridConstraints(7, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JLabel label13 = new JLabel();
        label13.setText("Vertical Algnment:");
        panel1.add((Component)label13, new GridConstraints(8, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        this.backgroundComboBox = new MColorComboBox();
        panel1.add((Component)this.backgroundComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 5, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.effectComboBox = new MColorComboBox();
        panel1.add((Component)this.effectComboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 5, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.foregroundComboBox = new MColorComboBox();
        panel1.add((Component)this.foregroundComboBox, new GridConstraints(3, 1, 1, 1, 0, 1, 5, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.fontComboBox = new MJYComboBox();
        panel1.add((Component)this.fontComboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 5, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        panel1.add((Component)this.minimumNumberOfCharactersSpinner, new GridConstraints(6, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.placementComboBox = new MListComboBox();
        panel1.add((Component)this.placementComboBox, new GridConstraints(4, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.horizontalAlignmentComboBox = new MListComboBox();
        panel1.add((Component)this.horizontalAlignmentComboBox, new GridConstraints(5, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.overflowComboBox = new MListComboBox();
        panel1.add((Component)this.overflowComboBox, new GridConstraints(7, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.verticalAlgnmentComboBox = new MListComboBox();
        panel1.add((Component)this.verticalAlgnmentComboBox, new GridConstraints(8, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.vanishingPointLabel = new JLabel();
        this.vanishingPointLabel.setText("Vanishing Point:");
        this.mainPanel.add((Component)this.vanishingPointLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel2, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.horizontalVanishingPointComboBox = new MJYComboBox();
        panel2.add((Component)this.horizontalVanishingPointComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.verticalVanishingPointComboBox = new MJYComboBox();
        panel2.add((Component)this.verticalVanishingPointComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel3, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.orderingComboBox = new MJYComboBox();
        panel3.add((Component)this.orderingComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.orderingDirectionComboBox = new MJYComboBox();
        panel3.add((Component)this.orderingDirectionComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.propertiesPanel = new JPanel();
        this.propertiesPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)this.propertiesPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.bgLabel = new JLabel();
        this.bgLabel.setText("Background:");
        this.mainPanel.add((Component)this.bgLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.bgComboBox = new MColorComboBox();
        this.mainPanel.add((Component)this.bgComboBox, new GridConstraints(6, 1, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        label1.setLabelFor((Component)this.aggregationComboBox);
        label2.setLabelFor((Component)this.nestingComboBox);
        label3.setLabelFor((Component)this.orderingComboBox);
        label4.setLabelFor((Component)this.scaleComboBox);
        label7.setLabelFor((Component)this.verticalAlgnmentComboBox);
        label9.setLabelFor((Component)this.placementComboBox);
        label10.setLabelFor((Component)this.horizontalAlignmentComboBox);
        label11.setLabelFor(this.minimumNumberOfCharactersSpinner);
        label12.setLabelFor((Component)this.overflowComboBox);
        label13.setLabelFor((Component)this.verticalAlgnmentComboBox);
        this.vanishingPointLabel.setLabelFor((Component)this.orderingComboBox);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private void createUIComponents() {
        this.mainPanel = new MJPanel();
        this.minimumNumberOfCharactersSpinner = new MJSpinner();
    }
}

