/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.ContextSensitiveCellRenderer;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableColumnChooser;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.swing.CornerScroller;
import com.macrofocus.crossplatform.swing.MJPanel;
import com.macrofocus.crossplatform.swing.MJScrollPane;
import com.macrofocus.labeling.EnhancedJLabel;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.TreeMapModel;
import com.treemap.app.swing.configuration.DetailsTableModel;
import com.treemap.app.swing.configuration.RowStripeSortableTable;
import com.treemap.details.Details;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class SwingDetails<N, Row, Column>
implements Details<JComponent, N, Row, Column, Color, Font> {
    static EditorContext editorContext = new EditorContext("DetailsPanel");
    private SortableTable sortableTable;
    private JPanel mainPanel;
    private JScrollPane scrollPane;

    public SwingDetails() {
        this.$$$setupUI$$$();
        this.sortableTable.setShowHorizontalLines(false);
        this.sortableTable.setColumnResizable(true);
        this.sortableTable.setColumnAutoResizable(true);
        this.sortableTable.setAutoscrolls(true);
        this.sortableTable.setShowGrid(false);
        this.sortableTable.setIntercellSpacing(new Dimension(0, 0));
        this.sortableTable.setRowAutoResizes(true);
        this.sortableTable.setVariousRowHeights(true);
        CellRendererManager.registerRenderer(String.class, (TableCellRenderer)new MultiLineCellRenderer(), (EditorContext)editorContext);
        CellRendererManager.registerRenderer(String[].class, (TableCellRenderer)new MultiLineCellRenderer(), (EditorContext)editorContext);
        AbstractButton tableColumnChooserButton = TableColumnChooser.getTableColumnChooserButton((JTable)this.sortableTable);
        tableColumnChooserButton.setContentAreaFilled(false);
        this.scrollPane.setCorner("UPPER_RIGHT_CORNER", tableColumnChooserButton);
        CornerScroller detailsScroller = new CornerScroller(this.scrollPane);
        detailsScroller.setSelectionBorderColor(Color.GRAY);
        this.scrollPane.setCorner("LOWER_RIGHT_CORNER", (Component)detailsScroller);
        this.sortableTable.setOpaque(false);
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public void setModel(TreeMapModel model) {
        DetailsTableModel tableModel = new DetailsTableModel(model);
        this.sortableTable.setModel(tableModel);
        TableUtils.autoResizeColumn((JTable)this.sortableTable, (int)0, (boolean)false, (boolean)false);
    }

    private void createUIComponents() {
        this.mainPanel = new MJPanel();
        this.scrollPane = new MJScrollPane();
        this.sortableTable = new RowStripeSortableTable();
    }

    public JComponent getNativeComponent() {
        return this.getMainPanel();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)this.scrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        this.scrollPane.setViewportView((Component)this.sortableTable);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    public static class MultiLineCellRenderer
    extends EnhancedJLabel
    implements TableCellRenderer {
        ContextSensitiveCellRenderer defaultCellRenderer = new ContextSensitiveCellRenderer();

        public MultiLineCellRenderer() {
            this.setOpaque(true);
            this.setRendering(EnhancedLabel.Rendering.WordWrap);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(obj == null ? "" : obj.toString());
            this.setFont(table.getFont());
            int w = table.getColumnModel().getColumn(column).getWidth();
            this.setDesiredSize(new Dimension(w, 1000));
            JLabel label = (JLabel)this.defaultCellRenderer.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            this.setForeground(label.getForeground());
            this.setBackground(label.getBackground());
            this.setBorder(label.getBorder());
            return this;
        }
    }
}

