/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.document;

import com.macrofocus.util.file.FileHelper;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.file.filter.MacrofocusTreeMapFileFilter;
import com.macrofocus.util.file.filter.MacrofocusTreeMapSettingsFileFilter;
import com.macrofocus.util.swing.FileChooserFactory;
import com.macrofocus.util.swing.export.format.FileProvider;
import com.treemap.app.document.TreeMapDocument;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class SettingsFileChooserFactory
extends FileChooserFactory {
    private final TreeMapDocument document;
    private final FileProvider<File> fileProvider;
    private final boolean expertMode;
    private static MacrofocusTreeMapSettingsFileFilter macrofocusTreeMapSettingsFileFilter = new MacrofocusTreeMapSettingsFileFilter();
    private static MacrofocusTreeMapFileFilter macrofocusTreeMapFileFilter = new MacrofocusTreeMapFileFilter();

    public SettingsFileChooserFactory(TreeMapDocument document, FileProvider<File> fileProvider, boolean expertMode) {
        this.document = document;
        this.fileProvider = fileProvider;
        this.expertMode = expertMode;
    }

    public JFileChooser getFileChooser() {
        JFileChooser fileChooser = super.getFileChooser();
        if (fileChooser.getSelectedFile() == null) {
            File file = (File)this.fileProvider.getFile();
            FileFilter fileFilter = fileChooser.getFileFilter();
            if (fileFilter instanceof AbstractFileFilter) {
                file = FileHelper.replaceSuffix((File)file, (String)((AbstractFileFilter)fileFilter).getDefaultExtension());
            }
            fileChooser.setSelectedFile(file);
        }
        return fileChooser;
    }

    protected JFileChooser createFileChooser() {
        JFileChooser fileChooser = super.createFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter((FileFilter)macrofocusTreeMapSettingsFileFilter);
        fileChooser.addChoosableFileFilter((FileFilter)macrofocusTreeMapFileFilter);
        if (this.expertMode) {
            // empty if block
        }
        fileChooser.setFileFilter((FileFilter)macrofocusTreeMapSettingsFileFilter);
        return fileChooser;
    }
}

