/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.document.export;

import com.treemap.app.swing.document.export.TableWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DelimitedTableWriter
implements TableWriter {
    private final FileWriter writer;
    private int columnCount;
    private String delimiter;
    private String newLine;
    private int row = 0;
    private int column = 0;

    public DelimitedTableWriter(FileWriter writer, int columnCount, String delimiter, String newLine) {
        this.writer = writer;
        this.columnCount = columnCount;
        this.delimiter = delimiter;
        this.newLine = newLine;
    }

    @Override
    public void writeColumnName(String value, boolean hasMore) throws IOException {
        if (value != null) {
            if (((String)value).contains(this.delimiter) || ((String)value).contains("\"") || ((String)value).contains("\n")) {
                value = "\"" + ((String)value).replaceAll("\"", "\"\"") + "\"";
            }
            this.writer.write((String)value);
        }
        this.nextColumn(hasMore);
    }

    @Override
    public void writeType(String value, boolean hasMore) throws IOException {
        if (value != null) {
            if (((String)value).contains(this.delimiter) || ((String)value).contains("\"") || ((String)value).contains("\n")) {
                value = "\"" + ((String)value).replaceAll("\"", "\"\"") + "\"";
            }
            this.writer.write((String)value);
        }
        this.nextColumn(hasMore);
    }

    @Override
    public void writeCell(Object value) throws IOException {
        if (value != null) {
            Object str;
            if (value instanceof String[]) {
                String[] array = (String[])value;
                str = "";
                for (int i = 0; i < array.length; ++i) {
                    String s = array[i];
                    str = (String)str + s;
                    if (i >= array.length - 1) continue;
                    str = (String)str + ".";
                }
            } else {
                if (value instanceof Number) {
                    DecimalFormat df;
                    double rint;
                    double d = ((Number)value).doubleValue();
                    if (d == (rint = Math.rint(d))) {
                        df = new DecimalFormat("#", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                        df.setMaximumFractionDigits(0);
                    } else {
                        df = new DecimalFormat("#.", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                        df.setMaximumFractionDigits(340);
                    }
                    str = df.format(value);
                } else if (value instanceof Date) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat();
                    str = dateFormat.format(value);
                } else {
                    str = value.toString();
                }
                if (((String)str).contains(this.delimiter) || ((String)str).contains("\"") || ((String)str).contains("\n")) {
                    str = "\"" + ((String)str).replaceAll("\"", "\"\"") + "\"";
                }
            }
            this.writer.write((String)str);
        }
    }

    @Override
    public void nextColumn(boolean hasMore) throws IOException {
        ++this.column;
        if (hasMore) {
            this.writer.write(this.delimiter);
        }
    }

    @Override
    public void nextRow() throws IOException {
        this.column = 0;
        ++this.row;
        this.writer.write(this.newLine);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

