/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.document.export;

import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.file.FileHelper;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.logging.SwingLogging;
import com.macrofocus.util.swing.FileChooserFactory;
import com.macrofocus.util.swing.export.ExportDialog;
import com.macrofocus.util.swing.export.format.AbstractExportFormat;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.macrofocus.util.swing.export.format.ExportFormat;
import com.macrofocus.util.swing.export.format.FileProvider;
import com.treemap.app.document.TreeMapDocument;
import com.treemap.app.swing.document.export.ArrowExportFormat;
import com.treemap.app.swing.document.export.CSVExportFormat;
import com.treemap.app.swing.document.export.ExcelExportFormat;
import com.treemap.app.swing.document.export.JSONExportFormat;
import com.treemap.app.swing.document.export.ParquetExportFormat;
import com.treemap.app.swing.document.export.TabDelimitedExportFormat;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class ExportDataAction
extends AbstractAction {
    private Type type = Type.JFileChooserWithAccessory;
    private final JComponent rootPane;
    private ContentProvider<TreeMapDocument> contentProvider;
    private FileProvider<File> fileProvider;
    private ExportDialog exportDialog;
    private final ExportFormat<TreeMapDocument>[] exportFormats;
    private FileChooserFactory fileChooserFactory = new FileChooserFactory(){

        public JFileChooser getFileChooser() {
            JFileChooser fileChooser = super.getFileChooser();
            if (fileChooser.getSelectedFile() == null) {
                File file = (File)ExportDataAction.this.fileProvider.getFile();
                FileFilter fileFilter = fileChooser.getFileFilter();
                if (fileFilter instanceof AbstractFileFilter) {
                    file = FileHelper.replaceSuffix((File)file, (String)((AbstractFileFilter)fileFilter).getDefaultExtension());
                }
                fileChooser.setSelectedFile(file);
            }
            return fileChooser;
        }

        protected JFileChooser createFileChooser() {
            final JFileChooser fileChooser = super.createFileChooser();
            fileChooser.setDialogTitle("Export Data");
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileSelectionMode(0);
            fileChooser.setAcceptAllFileFilterUsed(false);
            if (ExportDataAction.this.type == Type.JFileChooserWithAccessory) {
                fileChooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        FileFilter fileFilter = fileChooser.getFileFilter();
                        JComponent settings = null;
                        for (ExportFormat<TreeMapDocument> exportFormat : ExportDataAction.this.exportFormats) {
                            if (!exportFormat.isValid() || exportFormat.getFileFilter() != fileFilter) continue;
                            settings = (JComponent)exportFormat.getSettingsPanel();
                        }
                        fileChooser.setAccessory(settings);
                        fileChooser.validate();
                    }
                });
            }
            ExportFormat<TreeMapDocument> first = null;
            for (ExportFormat<TreeMapDocument> exportFormat : ExportDataAction.this.exportFormats) {
                if (!exportFormat.isValid()) continue;
                if (first == null) {
                    first = exportFormat;
                }
                fileChooser.addChoosableFileFilter((FileFilter)exportFormat.getFileFilter());
            }
            if (first != null) {
                fileChooser.setFileFilter((FileFilter)first.getFileFilter());
            }
            return fileChooser;
        }
    };

    public ExportDataAction(JComponent rootPane, final PropertiesModel propertiesModel, boolean expertMode) {
        this.rootPane = rootPane;
        this.exportFormats = ExportDataAction.getExportFormats(expertMode);
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    ExportDataAction.this.updateProperties(propertiesModel);
                }
            });
        }
    }

    public static ExportFormat<TreeMapDocument>[] getExportFormats(boolean expert) {
        ArrayList<AbstractExportFormat> list = new ArrayList<AbstractExportFormat>();
        try {
            list.add(new CSVExportFormat());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            list.add(new TabDelimitedExportFormat());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            list.add(new ExcelExportFormat());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            list.add(new JSONExportFormat());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            list.add(new ArrowExportFormat());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            list.add(new ParquetExportFormat());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return list.toArray(new ExportFormat[list.size()]);
    }

    public void setContent(ContentProvider<TreeMapDocument> component, FileProvider<File> fileProvider) {
        this.contentProvider = component;
        this.fileProvider = fileProvider;
        this.setEnabled(this.contentProvider != null);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            if (this.exportDialog == null) {
                this.exportDialog = this.createExportDialog(this.rootPane);
            }
            if (this.type == Type.ExportDialog) {
                this.exportDialog.setContent(this.contentProvider);
                this.exportDialog.pack();
                this.exportDialog.setLocationRelativeTo((Component)this.rootPane);
                this.exportDialog.setVisible(true);
            } else {
                JFileChooser fileChooser = this.fileChooserFactory.getFileChooser();
                fileChooser.rescanCurrentDirectory();
                int returnVal = fileChooser.showSaveDialog(this.rootPane);
                File file = fileChooser.getSelectedFile();
                FileFilter fileFilter = fileChooser.getFileFilter();
                if (returnVal == 0) {
                    int input;
                    if (!fileFilter.accept(file) && fileFilter instanceof AbstractFileFilter) {
                        file = FileHelper.replaceSuffix((File)file, (String)((AbstractFileFilter)fileFilter).getDefaultExtension());
                    }
                    if (file.exists() && (input = JOptionPane.showConfirmDialog(this.rootPane, "File " + file.getName() + " already exist! Overwrite?", "File already exist", 0, 2)) == 1) {
                        return;
                    }
                    for (ExportFormat<TreeMapDocument> exportFormat : this.exportFormats) {
                        if (!exportFormat.isValid() || exportFormat.getFileFilter() == null || !exportFormat.getFileFilter().equals((Object)fileFilter)) continue;
                        try {
                            exportFormat.save(this.contentProvider, file);
                        }
                        catch (IOException e) {
                            SwingLogging.getInstance().process((Component)this.rootPane, (Throwable)e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            SwingLogging.getInstance().process((Component)this.rootPane, (Throwable)e);
        }
    }

    protected ExportDialog createExportDialog(Component parent) throws HeadlessException {
        Window window = SwingUtilities.getWindowAncestor(parent);
        return new ExportDialog(window, this.exportFormats);
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        Object name = "Export Data";
        if (propertiesModel != null && propertiesModel.isAvailable("action.exportdata.label")) {
            name = (String)propertiesModel.getValue("action.exportdata.label");
        }
        name = (String)name + "...";
        this.putValue("Name", name);
    }

    public static enum Type {
        JFileChooser,
        JFileChooserWithAccessory,
        ExportDialog;

    }
}

