/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.importer;

import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.data.reader.PerfectDataReader;
import com.macrofocus.data.reader.TokenizerFactory;
import com.macrofocus.data.typemap.DefaultTypemapModel;
import com.macrofocus.data.typemap.TypemapModel;
import com.macrofocus.molap.aggregates.AggregateDataFrame;
import com.macrofocus.molap.aggregates.aggregation.Aggregation;
import com.macrofocus.molap.aggregates.aggregation.SumAggregation;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.dataframe.SingleSortKey;
import com.macrofocus.molap.dataframe.SortKey;
import com.macrofocus.molap.dataframe.SortOrder;
import com.macrofocus.molap.dataframe.swing.SwingDataFrameFactory;
import com.macrofocus.molap.exporter.java.SwingDataFrameExporter;
import com.macrofocus.molap.series.RenamedSeries;
import com.macrofocus.molap.series.Series;
import com.macrofocus.util.file.CharsetToolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.lbzip2.LBzip2InputStream;

public class Export {
    final String localStore = "/Users/luc/macrofocus/dataset/treemap/Export";

    public Export() throws IOException {
        File dir = new File("/Users/luc/macrofocus/dataset/treemap/Export");
        if (!dir.exists()) {
            dir.mkdir();
        }
        this.download(dir);
    }

    protected void download(File dir) throws IOException {
        MutableDataFrame importExportSITC2012DataFrame;
        String[] files;
        String importExportSITC = "year_origin_destination_sitc.tsv";
        String importExportHS = "year_origin_destination_hs.tsv";
        String country = "country.tsv";
        String sitc = "sitc4.tsv";
        String hs = "hs4.tsv";
        for (String file : files = new String[]{"year_origin_destination_sitc.tsv", "year_origin_destination_hs.tsv", "country.tsv", "sitc4.tsv", "hs4.tsv"}) {
            if (new File(dir, file + ".gz").exists()) continue;
            File target = new File(dir, file + ".bz2");
            if (!target.exists()) {
                URL url = new URL("http://atlas.media.mit.edu/static/db/raw/" + file + ".bz2");
                Files.copy(url.openStream(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            Export.convertToGzip(target, new File(dir, file + ".gz"));
        }
        File serialized2012File = new File(dir, "origin_destination_sitc_2012.tsv.ser");
        if (!serialized2012File.exists()) {
            MutableDataFrame importExportSITCDataFrame;
            File serializedFile = new File(dir, "year_origin_destination_sitc.tsv.ser");
            if (!serializedFile.exists()) {
                DefaultTypemapModel instance = DefaultTypemapModel.getInstance();
                importExportSITCDataFrame = SwingDataFrameFactory.fromTSV((URL)new File(dir, "year_origin_destination_sitc.tsv.gz").toURI().toURL(), (TypemapModel.Builder[])new TypemapModel.Builder[]{instance.getBuilder(Integer.class), instance.getBuilder(String.class), instance.getBuilder(String.class), instance.getBuilder(Integer.class), instance.getBuilder(Float.class), instance.getBuilder(Float.class)});
                System.out.println("year_origin_destination_sitc.tsv: " + importExportSITCDataFrame.getRowCount() + "x" + importExportSITCDataFrame.getColumnCount());
                SwingDataFrameExporter.exportSerialize((DataFrame)importExportSITCDataFrame, (File)serializedFile);
            } else {
                importExportSITCDataFrame = SwingDataFrameFactory.fromSerialize((URL)serializedFile.toURI().toURL());
            }
            Aggregation exportAggregation = importExportSITCDataFrame.getSum((Object)"export_val").as("export_val");
            Aggregation importAggregation = importExportSITCDataFrame.getSum((Object)"import_val").as("import_val");
            AggregateDataFrame aggregateDataFrame = importExportSITCDataFrame.aggregate(new Aggregation[]{exportAggregation, importAggregation});
            importExportSITC2012DataFrame = aggregateDataFrame.drillDown(new Object[]{"year"}).slice((Object)2012).drillDown(new Object[]{"origin", "destination", "sitc4"});
            SwingDataFrameExporter.exportSerialize((DataFrame)importExportSITC2012DataFrame, (File)serialized2012File);
            System.out.println("Exported " + importExportSITC2012DataFrame.getRowCount() + "x" + importExportSITC2012DataFrame.getColumnCount() + " to " + serialized2012File);
        } else {
            importExportSITC2012DataFrame = SwingDataFrameFactory.fromSerialize((URL)serialized2012File.toURI().toURL());
            System.out.println("Imported " + importExportSITC2012DataFrame.getRowCount() + "x" + importExportSITC2012DataFrame.getColumnCount() + " to " + serialized2012File);
        }
        SumAggregation exportAggregation = importExportSITC2012DataFrame.getSum((Object)"export_val");
        SumAggregation importAggregation = importExportSITC2012DataFrame.getSum((Object)"import_val");
        AggregateDataFrame aggregateDataFrame = importExportSITC2012DataFrame.aggregate(new Aggregation[]{exportAggregation, importAggregation});
        AggregateDataFrame sticDataFrame = aggregateDataFrame.drillDown(new Object[]{"sitc4"});
        DefaultDataFrame bakeryDataFrame = new DefaultDataFrame(sticDataFrame.slice((Object)484).drillDown(new Object[]{"origin", "destination"}).orderRows(new SortKey[]{new SingleSortKey((Object)"Sum(export_val)", SortOrder.ASCENDING)}));
        DataFrame countryDataFrame = SwingDataFrameFactory.fromTSV((URL)new File(dir, "country.tsv.gz").toURI().toURL(), (TypemapModel.Builder[])new TypemapModel.Builder[0]).removeDuplicates((Object[])new String[]{"id"}).reindexRowsUsingColumns((Object[])new String[]{"id"});
        bakeryDataFrame = new DefaultDataFrame(bakeryDataFrame.join((Series)new RenamedSeries((Object)"originName", countryDataFrame.getColumn((Object)"name")), (Object[])new String[]{"origin"}).join((Series)new RenamedSeries((Object)"destinationName", countryDataFrame.getColumn((Object)"name")), (Object[])new String[]{"destination"}));
        bakeryDataFrame.print();
        SwingDataFrameExporter.exportExcel((DataFrame)bakeryDataFrame, (File)new File(dir, "bakeryProducts_origin_destination_sitc_2012.xls"));
        System.exit(0);
        MutableDataFrame sitc4DataFrame = SwingDataFrameFactory.fromTSV((URL)new File(dir, "sitc4.tsv.gz").toURI().toURL(), (TypemapModel.Builder[])new TypemapModel.Builder[0]).reindexRowsUsingColumn((Object)"id");
        sitc4DataFrame.print();
        for (Object row : countryDataFrame.rows()) {
            String id = (String)countryDataFrame.getValueAt(row, (Object)"id");
            String name = (String)countryDataFrame.getValueAt(row, (Object)"name");
            System.out.println("Processing " + name + " (" + id + ")");
            DataFrame countryExportDataFrame = sticDataFrame.drillDown(new Object[]{"origin"}).slice((Object)id).orderRows(new SortKey[]{new SingleSortKey((Object)"Sum(export_val)", SortOrder.ASCENDING)});
            DataFrame countryImportDataFrame = sticDataFrame.drillDown(new Object[]{"destination"}).slice((Object)id).orderRows(new SortKey[]{new SingleSortKey((Object)"Sum(export_val)", SortOrder.ASCENDING)});
            if (countryExportDataFrame.getRowCount() <= 0) continue;
            Object exportKey = countryExportDataFrame.getRowKey(countryExportDataFrame.getRowCount() - 1);
            Object importKey = countryImportDataFrame.getRowKey(countryImportDataFrame.getRowCount() - 1);
            Object exportSitc4 = countryExportDataFrame.getValueAt(exportKey, (Object)"sitc4");
            Object importSitc4 = countryImportDataFrame.getValueAt(importKey, (Object)"sitc4");
            System.out.println("Export: " + sitc4DataFrame.getValueAt(exportSitc4, (Object)"name") + " (" + exportSitc4 + ") (" + countryExportDataFrame.getValueAt(exportKey, (Object)"Sum(export_val)") + ")");
            System.out.println("Import: " + sitc4DataFrame.getValueAt(importSitc4, (Object)"name") + " (" + importSitc4 + ") (" + countryImportDataFrame.getValueAt(importKey, (Object)"Sum(export_val)") + ")");
        }
    }

    public static void main(String[] args) {
        try {
            new Export();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void convertToGzip(File target, File file) throws IOException {
        long now = System.currentTimeMillis();
        int buffersize = 8192;
        FileInputStream fin = new FileInputStream(target);
        BufferedInputStream in = new BufferedInputStream(fin);
        GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(file)){
            {
                this.def.setLevel(9);
            }
        };
        LBzip2InputStream bzIn = new LBzip2InputStream((InputStream)in);
        byte[] buffer = new byte[buffersize];
        int n = 0;
        while (-1 != (n = bzIn.read(buffer))) {
            out.write(buffer, 0, n);
        }
        out.close();
        bzIn.close();
        System.out.println("Converted " + target.getName() + " to " + file.getName() + " in " + (System.currentTimeMillis() - now) / 1000L + " s");
    }

    public static void benchmarkBz2(File target) throws IOException {
        long now = System.currentTimeMillis();
        FileInputStream fin = new FileInputStream(target);
        BufferedInputStream in = new BufferedInputStream(fin);
        LBzip2InputStream bzIn = new LBzip2InputStream((InputStream)in);
        int i = 0;
        PerfectDataReader dr = new PerfectDataReader((Reader)new CharsetToolkit(new BufferedInputStream((InputStream)bzIn)).getReader(), TokenizerFactory.getTabDelimitedInstance(), true, false, "String");
        while (dr.hasMoreRow()) {
            ++i;
            dr.nextRow();
        }
        System.out.println(target.getName() + ": " + i + " lines in " + (System.currentTimeMillis() - now) / 1000L + " s");
    }

    public static void benchmarkGzip(File target) throws IOException {
        long now = System.currentTimeMillis();
        FileInputStream fin = new FileInputStream(target);
        BufferedInputStream in = new BufferedInputStream(fin);
        GZIPInputStream bzIn = new GZIPInputStream(in);
        int i = 0;
        PerfectDataReader dr = new PerfectDataReader((Reader)new CharsetToolkit(new BufferedInputStream(bzIn)).getReader(), TokenizerFactory.getTabDelimitedInstance(), true, false, "String");
        while (dr.hasMoreRow()) {
            ++i;
            dr.nextRow();
        }
        System.out.println(target.getName() + ": " + i + " lines in " + (System.currentTimeMillis() - now) / 1000L + " s");
    }
}

