/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.importer;

import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.common.file.FileType;
import com.macrofocus.common.file.TreeMapFileType;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.data.source.TabDelimitedDataSource;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.CPImageFactory;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.igraphics.swing.SwingFont;
import com.macrofocus.igraphics.swing.SwingImageFactory;
import com.macrofocus.labeling.EnhancedLabel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.dataframe.SingleSortKey;
import com.macrofocus.molap.dataframe.SortKey;
import com.macrofocus.molap.dataframe.SortOrder;
import com.macrofocus.molap.dataframe.WrappedDataFrame;
import com.macrofocus.molap.dataframe.swing.SwingDataFrameFactory;
import com.macrofocus.molap.exporter.java.SwingDataFrameExporter;
import com.macrofocus.molap.expression.ExpressionCalculatedColumn;
import com.macrofocus.palette.MutablePalette;
import com.macrofocus.palette.swing.SwingPaletteFactory;
import com.treemap.AggregationFactory;
import com.treemap.RenderingFactory;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.app.document.TreeMapDocument;
import com.treemap.app.swing.document.SwingTreeMapApplication;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class Global2000 {
    private static final boolean DOWNLOAD = true;
    Map<String, String> industrySector = new HashMap<String, String>();
    Map<String, String> countryContinent = new HashMap<String, String>();
    final String localStore = "/Users/luc/macrofocus/dataset/treemap/Forbes Global 2000 - 2022";

    public Global2000() {
        String AFRICA = "Africa";
        String EUROPE = "Europe";
        String ASIA = "Asia";
        String NORTH_AMERICA = "North America";
        String SOUTH_AMERICA = "South America";
        String AUSTRALIA = "Australia";
        this.countryContinent.put("Argentina", "South America");
        this.countryContinent.put("Australia", "Australia");
        this.countryContinent.put("Austria", "Europe");
        this.countryContinent.put("Bahrain", "Asia");
        this.countryContinent.put("Belgium", "Europe");
        this.countryContinent.put("Bermuda", "North America");
        this.countryContinent.put("Brazil", "South America");
        this.countryContinent.put("Canada", "North America");
        this.countryContinent.put("Cayman Islands", "North America");
        this.countryContinent.put("Chile", "South America");
        this.countryContinent.put("China", "Asia");
        this.countryContinent.put("Colombia", "South America");
        this.countryContinent.put("Cyprus", "Europe");
        this.countryContinent.put("Czech Republic", "Europe");
        this.countryContinent.put("Denmark", "Europe");
        this.countryContinent.put("Egypt", "Africa");
        this.countryContinent.put("Finland", "Europe");
        this.countryContinent.put("France", "Europe");
        this.countryContinent.put("Germany", "Europe");
        this.countryContinent.put("Greece", "Europe");
        this.countryContinent.put("Hong Kong", "Asia");
        this.countryContinent.put("Hungary", "Europe");
        this.countryContinent.put("India", "Asia");
        this.countryContinent.put("Indonesia", "Asia");
        this.countryContinent.put("Ireland", "Europe");
        this.countryContinent.put("Israel", "Asia");
        this.countryContinent.put("Italy", "Europe");
        this.countryContinent.put("Japan", "Asia");
        this.countryContinent.put("Jordan", "Asia");
        this.countryContinent.put("Kazakhstan", "Asia");
        this.countryContinent.put("Kenya", "Africa");
        this.countryContinent.put("Kuwait", "Asia");
        this.countryContinent.put("Lebanon", "Asia");
        this.countryContinent.put("Luxembourg", "Europe");
        this.countryContinent.put("Malaysia", "Asia");
        this.countryContinent.put("Mauritius", "Africa");
        this.countryContinent.put("Mexico", "North America");
        this.countryContinent.put("Monaco", "Europe");
        this.countryContinent.put("Morocco", "Africa");
        this.countryContinent.put("Netherlands", "Europe");
        this.countryContinent.put("Nigeria", "Africa");
        this.countryContinent.put("Norway", "Europe");
        this.countryContinent.put("Oman", "Asia");
        this.countryContinent.put("Pakistan", "Asia");
        this.countryContinent.put("Peru", "South America");
        this.countryContinent.put("Philippines", "Asia");
        this.countryContinent.put("Poland", "Europe");
        this.countryContinent.put("Portugal", "Europe");
        this.countryContinent.put("Puerto Rico", "North America");
        this.countryContinent.put("Qatar", "Asia");
        this.countryContinent.put("Russia", "Asia");
        this.countryContinent.put("Saudi Arabia", "Asia");
        this.countryContinent.put("Singapore", "Asia");
        this.countryContinent.put("South Africa", "Africa");
        this.countryContinent.put("South Korea", "Asia");
        this.countryContinent.put("Spain", "Europe");
        this.countryContinent.put("Sweden", "Europe");
        this.countryContinent.put("Switzerland", "Europe");
        this.countryContinent.put("Taiwan", "Asia");
        this.countryContinent.put("Thailand", "Asia");
        this.countryContinent.put("Togo", "Africa");
        this.countryContinent.put("Turkey", "Europe");
        this.countryContinent.put("United Arab Emirates", "Asia");
        this.countryContinent.put("United Kingdom", "Europe");
        this.countryContinent.put("United States", "North America");
        this.countryContinent.put("Venezuela", "South America");
        this.countryContinent.put("Vietnam", "Asia");
        String ENERGY = "Energy";
        String MATERIALS = "Materials";
        String INDUSTRIALS = "Industrials";
        String CONSUMER_DISCRETIONARY = "Consumer Discretionary";
        String CONSUMER_STAPLES = "Consumer Staples";
        String HEALTH_CARE = "Health Care";
        String FINANCIALS = "Financials";
        String INFORMATION_TECHNOLOGY = "Information Technology";
        String TELECOMUNICATION_SERVICES = "Telecommunication Services";
        String UTILITIES = "Utilities";
        this.industrySector.put("Advertising", "Consumer Discretionary");
        this.industrySector.put("Aerospace & Defense", "Industrials");
        this.industrySector.put("Air Courier", "Industrials");
        this.industrySector.put("Airline", "Industrials");
        this.industrySector.put("Aluminum", "Materials");
        this.industrySector.put("Apparel/Accessories", "Consumer Discretionary");
        this.industrySector.put("Apparel/Footwear Retail", "Consumer Discretionary");
        this.industrySector.put("Auto & Truck Manufacturers", "Consumer Discretionary");
        this.industrySector.put("Auto & Truck Parts", "Consumer Discretionary");
        this.industrySector.put("Automotive", "Consumer Discretionary");
        this.industrySector.put("Banking", "Financials");
        this.industrySector.put("Beverages", "Consumer Staples");
        this.industrySector.put("Biotechs", "Health Care");
        this.industrySector.put("Broadcasting & Cable", "Consumer Discretionary");
        this.industrySector.put("Business Services & Supplies", "Consumer Discretionary");
        this.industrySector.put("Business & Personal Services", "Consumer Discretionary");
        this.industrySector.put("Business Products & Supplies", "Industrials");
        this.industrySector.put("Capital Goods", "Financials");
        this.industrySector.put("Casinos & Gaming", "Consumer Discretionary");
        this.industrySector.put("Chemicals", "Materials");
        this.industrySector.put("Communications Equipment", "Information Technology");
        this.industrySector.put("Computer & Electronics Retail", "Information Technology");
        this.industrySector.put("Computer Hardware", "Information Technology");
        this.industrySector.put("Computer Services", "Information Technology");
        this.industrySector.put("Computer Storage Devices", "Information Technology");
        this.industrySector.put("Conglomerates", "Industrials");
        this.industrySector.put("Construction", "Materials");
        this.industrySector.put("Construction Materials", "Materials");
        this.industrySector.put("Construction Services", "Industrials");
        this.industrySector.put("Consumer Durables", "Consumer Discretionary");
        this.industrySector.put("Consumer Electronics", "Consumer Discretionary");
        this.industrySector.put("Consumer Financial Services", "Financials");
        this.industrySector.put("Containers & Packaging", "Materials");
        this.industrySector.put("Department Stores", "Consumer Discretionary");
        this.industrySector.put("Discount Stores", "Consumer Discretionary");
        this.industrySector.put("Diversified Chemicals", "Materials");
        this.industrySector.put("Diversified Financials", "Financials");
        this.industrySector.put("Diversified Insurance", "Financials");
        this.industrySector.put("Diversified Metals & Mining", "Materials");
        this.industrySector.put("Diversified Utilities", "Utilities");
        this.industrySector.put("Drug Retail", "Consumer Staples");
        this.industrySector.put("Drugs & Biotechnology", "Health Care");
        this.industrySector.put("Electric Utilities", "Utilities");
        this.industrySector.put("Electrical Equipment", "Industrials");
        this.industrySector.put("Electronics", "Information Technology");
        this.industrySector.put("Environmental & Waste", "Industrials");
        this.industrySector.put("Food & Drink", "Consumer Staples");
        this.industrySector.put("Food, Drink & Tobacco", "Consumer Staples");
        this.industrySector.put("Food Markets", "Consumer Staples");
        this.industrySector.put("Food Processing", "Consumer Staples");
        this.industrySector.put("Food Retail", "Consumer Staples");
        this.industrySector.put("Forest Products", "Materials");
        this.industrySector.put("Furniture & Fixtures", "Consumer Discretionary");
        this.industrySector.put("Precision Healthcare Equipment", "Health Care");
        this.industrySector.put("Health Care Equipment & Services", "Health Care");
        this.industrySector.put("Healthcare Services", "Health Care");
        this.industrySector.put("Heavy Equipment", "Industrials");
        this.industrySector.put("Home Improvement Retail", "Consumer Discretionary");
        this.industrySector.put("Hotels, Restaurants & Leisure", "Consumer Discretionary");
        this.industrySector.put("Hotels & Motels", "Consumer Discretionary");
        this.industrySector.put("Household Appliances", "Consumer Discretionary");
        this.industrySector.put("Household/Personal Care", "Consumer Staples");
        this.industrySector.put("Household & Personal Products", "Consumer Staples");
        this.industrySector.put("Insurance Brokers", "Financials");
        this.industrySector.put("Insurance", "Financials");
        this.industrySector.put("Internet & Catalog Retail", "Consumer Discretionary");
        this.industrySector.put("Investment Services", "Financials");
        this.industrySector.put("Iron & Steel", "Materials");
        this.industrySector.put("IT Software & Services", "Information Technology");
        this.industrySector.put("Life & Health Insurance", "Financials");
        this.industrySector.put("Major Banks", "Financials");
        this.industrySector.put("Managed Health Care", "Health Care");
        this.industrySector.put("Materials", "Materials");
        this.industrySector.put("Medical Equipment & Supplies", "Health Care");
        this.industrySector.put("Media", "Consumer Discretionary");
        this.industrySector.put("Natural Gas Utilities", "Utilities");
        this.industrySector.put("Oil & Gas Operations", "Energy");
        this.industrySector.put("Oil Services & Equipment", "Energy");
        this.industrySector.put("Other Industrial Equipment", "Industrials");
        this.industrySector.put("Other Transportation", "Industrials");
        this.industrySector.put("Paper & Paper Products", "Materials");
        this.industrySector.put("Pharmaceuticals", "Health Care");
        this.industrySector.put("Precision Healthcare Equipment", "Health Care");
        this.industrySector.put("Printing & Publishing", "Consumer Discretionary");
        this.industrySector.put("Property & Casualty Insurance", "Financials");
        this.industrySector.put("Railroads", "Industrials");
        this.industrySector.put("Real Estate", "Financials");
        this.industrySector.put("Recreational Products", "Consumer Discretionary");
        this.industrySector.put("Regional Banks", "Financials");
        this.industrySector.put("Rental & Leasing", "Financials");
        this.industrySector.put("Restaurants", "Consumer Discretionary");
        this.industrySector.put("Retailing", "Consumer Staples");
        this.industrySector.put("Security Systems", "Industrials");
        this.industrySector.put("Semiconductors", "Information Technology");
        this.industrySector.put("Software & Programming", "Information Technology");
        this.industrySector.put("Specialized Chemicals", "Materials");
        this.industrySector.put("Specialty Stores", "Consumer Discretionary");
        this.industrySector.put("Technology Hardware & Equipment", "Information Technology");
        this.industrySector.put("Telecommunications services", "Telecommunication Services");
        this.industrySector.put("Telecommunications Services", "Telecommunication Services");
        this.industrySector.put("Thrifts & Mortgage Finance", "Financials");
        this.industrySector.put("Tobacco", "Consumer Staples");
        this.industrySector.put("Trading Companies", "Industrials");
        this.industrySector.put("Transportation", "Industrials");
        this.industrySector.put("Trucking", "Industrials");
        this.industrySector.put("Utilities", "Utilities");
        File tabDelimitedFile = new File("/Users/luc/macrofocus/dataset/treemap/Forbes Global 2000 - 2022.txt");
        File csvFile = new File("/Users/luc/macrofocus/dataset/treemap/Forbes Global 2000 - 2022.csv");
        try {
            System.setProperty("http.agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:40.0) Gecko/20100101 Firefox/40.1");
            URL url = new URL("https://www.forbes.com/ajax/list/data?year=2022&uri=global2000&type=organization");
            MutableDataFrame dataFrame = SwingDataFrameFactory.getInstance().fromJSON(url);
            System.out.println("Original columns");
            for (String column : dataFrame.columns()) {
                System.out.println(column + ": " + dataFrame.getColumnClass((Object)column));
            }
            System.out.println("Successfully scrapped " + dataFrame.getRowCount() + " companies");
            WrappedDataFrame derivedDataFrame = new WrappedDataFrame((DataFrame)dataFrame);
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"name", (Object)"Company")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn<Integer, String, Object>((DataFrame)dataFrame, "marketValue", "Market Value"){

                public Object getValue(WrappedDataFrame<Integer, String, Object> dataFrame, Integer row) {
                    Number value = (Number)super.getValue(dataFrame, (Object)row);
                    return value != null ? Double.valueOf(value.doubleValue() / 1000.0) : null;
                }
            }});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn<Integer, String, Object>((DataFrame)dataFrame, "revenue", "Revenue"){

                public Object getValue(WrappedDataFrame<Integer, String, Object> dataFrame, Integer row) {
                    Number value = (Number)super.getValue(dataFrame, (Object)row);
                    return value != null ? Double.valueOf(value.doubleValue() / 1000.0) : null;
                }
            }});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn<Integer, String, Object>((DataFrame)dataFrame, "profits", "Profits"){

                public Object getValue(WrappedDataFrame<Integer, String, Object> dataFrame, Integer row) {
                    Number value = (Number)super.getValue(dataFrame, (Object)row);
                    return value != null ? Double.valueOf(value.doubleValue() / 1000.0) : null;
                }
            }});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn<Integer, String, Object>((DataFrame)dataFrame, "assets", "Assets"){

                public Object getValue(WrappedDataFrame<Integer, String, Object> dataFrame, Integer row) {
                    Number value = (Number)super.getValue(dataFrame, (Object)row);
                    return value != null ? Double.valueOf(value.doubleValue() / 1000.0) : null;
                }
            }});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"rank", (Object)"Rank")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DerivedColumn<Integer, String, Object>("Sector", String.class){

                public Object getValue(WrappedDataFrame<Integer, String, Object> dataFrame, Integer row) {
                    Object industry = dataFrame.getValueAt((Object)row, (Object)"Industry");
                    String sector = Global2000.this.industrySector.get(industry);
                    if (sector != null) {
                        return sector;
                    }
                    System.err.println("Could not find sector for industry " + industry);
                    return null;
                }
            }});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"industry", (Object)"Industry")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DerivedColumn<Integer, String, Object>("Continent", String.class){

                public Object getValue(WrappedDataFrame<Integer, String, Object> dataFrame, Integer row) {
                    Object country = dataFrame.getValueAt((Object)row, (Object)"Country");
                    String continent = Global2000.this.countryContinent.get(country);
                    if (continent != null) {
                        return continent;
                    }
                    System.err.println("Could not find continent for country " + country);
                    return null;
                }
            }});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"country", (Object)"Country")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"headquarters", (Object)"Headquarters")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"state", (Object)"State")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn((DataFrame)dataFrame, (Object)"ceo", (Object)"CEO")});
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DataFrameColumn<Integer, String, Object>((DataFrame)dataFrame, "uri", "Forbes Webpage"){

                public Object getValue(WrappedDataFrame<Integer, String, Object> dataFrame, Integer row) {
                    return "http://www.forbes.com/companies/" + super.getValue(dataFrame, (Object)row) + "/";
                }
            }});
            dataFrame = derivedDataFrame.orderRows(new SortKey[]{new SingleSortKey((Object)"Rank", SortOrder.ASCENDING)});
            SwingDataFrameExporter.exportCSV((DataFrame)dataFrame, (File)csvFile);
            SwingDataFrameExporter.exportTSV((DataFrame)dataFrame, (File)tabDelimitedFile);
            SwingDataFrameExporter.exportExcel((DataFrame)dataFrame, (File)new File("/Users/luc/macrofocus/dataset/treemap/Forbes Global 2000 - 2022.xls"));
            SwingDataFrameExporter.exportJSON((DataFrame)dataFrame, (File)new File("/Users/luc/macrofocus/dataset/treemap/Forbes Global 2000 - 2022.json"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TabDelimitedDataSource dataSource = new TabDelimitedDataSource(tabDelimitedFile);
        try {
            MutableDataFrame tableDataFrame = dataSource.loadDataFrame(null);
            for (String s : tableDataFrame.columns()) {
                System.out.println(s + ": " + tableDataFrame.getColumnClass((Object)s));
            }
            File file = new File("/Users/luc/macrofocus/dataset/treemap/Forbes Global 2000 - 2022.mtm");
            TreeMapDocument document = new TreeMapDocument("Forbes Global 2000 - 2021", file.toURI().toURL().toExternalForm(), (DataFrame)tableDataFrame, null, (CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), (CPImageFactory)SwingImageFactory.getInstance());
            WrappedDataFrame dataFrame = document.getDataFrame();
            TreeMapModel treeMapModel = document.getTreeMapModel();
            TreeMapFieldSettings sector = treeMapModel.getSettings().getFieldSettings(treeMapModel.getTreeMapField((Object)"Sector"));
            sector.setHeaderFont((CPFont)new SwingFont("Tahoma", 1, 13));
            sector.setHeaderForeground((CPColor)new SwingColor(127, 127, 127));
            TreeMapFieldSettings industry = treeMapModel.getSettings().getFieldSettings(treeMapModel.getTreeMapField((Object)"Industry"));
            industry.setHeaderFont((CPFont)new SwingFont("Tahoma", 0, 11));
            industry.setHeaderForeground((CPColor)new SwingColor(92, 92, 92));
            TreeMapFieldSettings continent = treeMapModel.getSettings().getFieldSettings(treeMapModel.getTreeMapField((Object)"Continent"));
            continent.setHeaderFont((CPFont)new SwingFont("Tahoma", 1, 13));
            continent.setHeaderForeground((CPColor)new SwingColor(127, 127, 127));
            TreeMapFieldSettings country = treeMapModel.getSettings().getFieldSettings(treeMapModel.getTreeMapField((Object)"Country"));
            country.setHeaderFont((CPFont)new SwingFont("Tahoma", 0, 11));
            country.setHeaderForeground((CPColor)new SwingColor(92, 92, 92));
            treeMapModel.getSettings().setGroupByByNames(new String[]{"Sector", "Industry"});
            treeMapModel.getSettings().setColorByName("Profits");
            TreeMapFieldSettings profits = treeMapModel.getSettings().getFieldSettings(treeMapModel.getTreeMapField((Object)"Profits"));
            MutableColorMap profitsColorMap = treeMapModel.getPredefinedColorMap((Object)"Profits");
            profitsColorMap.setPalette((MutablePalette)SwingPaletteFactory.getInstance().get("negpos").getPalette());
            profits.setColorMap(profitsColorMap);
            treeMapModel.setFormatPattern(dataFrame.getColumnAddress((Object)"Market Value"), "#,##0.00 $bil");
            treeMapModel.setFormatPattern(dataFrame.getColumnAddress((Object)"Revenue"), "#,##0.00 $bil");
            treeMapModel.setFormatPattern(dataFrame.getColumnAddress((Object)"Profits"), "#,##0.00 $bil");
            treeMapModel.setFormatPattern(dataFrame.getColumnAddress((Object)"Assets"), "#,##0.00 $bil");
            dataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new ExpressionCalculatedColumn((Object)"Profits as % of Assets", "[Profits] / [Assets]")});
            dataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new ExpressionCalculatedColumn((Object)"Profits as % of Revenue", "[Profits] / [Revenue]")});
            treeMapModel.setFormatPattern(dataFrame.getColumnAddress((Object)"Profits as % of Assets"), "#%");
            treeMapModel.setFormatPattern(dataFrame.getColumnAddress((Object)"Profits as % of Revenue"), "#%");
            treeMapModel.getSettings().getFieldSettings(treeMapModel.getTreeMapFieldByName("Profits as % of Assets")).setAggregation(AggregationFactory.SIZE_WEIGHTED_AGGREGATION);
            treeMapModel.getSettings().getFieldSettings(treeMapModel.getTreeMapFieldByName("Profits as % of Revenue")).setAggregation(AggregationFactory.SIZE_WEIGHTED_AGGREGATION);
            for (int c = 0; c < treeMapModel.getColumnCount(); ++c) {
                TreeMapField field = treeMapModel.getTreeMapField(c);
                treeMapModel.getSettings().setShowPopup(field, !field.getName().equals("Forbes Webpage") && !field.getName().equals("Rank"));
                treeMapModel.getSettings().getFieldSettings(field).setShowLabel(true);
            }
            treeMapModel.getSettings().getDefaultFieldSettings().setNestingBackground(SwingFactory.getInstance().createRGBColor(240, 240, 240));
            TreeMapFieldSettings company = treeMapModel.getSettings().getFieldSettings(treeMapModel.getTreeMapField((Object)"Company"));
            company.setOverrideDefaults(true);
            company.setLabelingShrinkTextToFitShape(Boolean.valueOf(true));
            company.setLabelingResizeTextToFitShape(Boolean.valueOf(false));
            company.setLabelingContrastEnhancement(EnhancedLabel.ContrastEnhancement.Complement);
            company.setLabelingRendering(EnhancedLabel.Rendering.Clip);
            company.setLabelingHorizontalAlignment(0);
            company.setLabelingVerticalAlignment(0);
            company.setLabelingFont(SwingFactory.getInstance().createFont("Tahoma", 0, 14));
            treeMapModel.getSettings().setRendering(RenderingFactory.CUSHION);
            treeMapModel.getSettings().getDefaultFieldSettings().setBorderThickness(0.1);
            treeMapModel.getSettings().setLightSourceAmbient(0.7);
            SwingTreeMapApplication.saveDocument(document, file, (FileType)TreeMapFileType.getInstance());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    String unescape(String s) {
        s = s.replace("%20", " ");
        s = StringEscapeUtils.unescapeHtml((String)s);
        return s;
    }

    Number toBillions(String s) {
        s = s.replace(",", "");
        if ((s = s.replace("$", "")).endsWith("B")) {
            if ((s = s.replace("B", "")).equals("- ")) {
                return null;
            }
            return Double.parseDouble(s);
        }
        if (s.endsWith("M")) {
            s = s.replace("M", "");
            return new BigDecimal(Double.parseDouble(s)).divide(new BigDecimal(1000), 4, 4).doubleValue();
        }
        return null;
    }

    public static void main(String[] args) {
        new Global2000();
    }
}

