/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.presentation.implementation;

import com.macrofocus.common.interval.Interval;
import com.macrofocus.math.stat.Histogram;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisModel;
import com.macrofocus.soom.lens.coordinate.OptimizedCoordinateAxisModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class HistogramView
extends JPanel {
    private final Color lineColor = Color.lightGray;
    private final Color outlineColor = Color.black;
    private final Color fillColor = Color.lightGray;
    private final Color filteredOutlineColor = Color.lightGray;
    private final Orientation orientation;
    private Histogram histogram;
    private Interval rangeModel;
    private final CoordinateAxisModel coordinateAxis;

    public HistogramView(Orientation orientation) {
        this.orientation = orientation;
        this.coordinateAxis = new OptimizedCoordinateAxisModel(0.0, 1.0);
        this.coordinateAxis.setWorldCoordinatesInverted(orientation.equals((Object)Orientation.VERTICAL));
    }

    public void setHistogram(Histogram histogram) {
        this.histogram = histogram;
        if (this.histogram != null) {
            this.coordinateAxis.setWorldMin(histogram.getMinValue());
            this.coordinateAxis.setWorldMax(histogram.getMaxValue());
        }
    }

    public void setRangeModel(Interval rangeModel) {
        this.rangeModel = rangeModel;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.histogram != null) {
            Graphics2D g2 = (Graphics2D)g;
            Dimension d = this.getSize();
            switch (this.orientation) {
                case VERTICAL: {
                    this.coordinateAxis.setScreenSize(d.height);
                    boolean x1 = false;
                    int x2 = d.width;
                    g.setColor(this.lineColor);
                    g.drawLine(-1, 0, -1, this.coordinateAxis.getScreenSize() - 1);
                    int max_width = x2 - 0 + 1;
                    int max_count = this.histogram.getMaxCount();
                    int x_prev = 0;
                    for (int j = 0; j < this.histogram.getNumberOfBins(); ++j) {
                        if (this.histogram.getCountAtBin(j) <= 0) continue;
                        int width = this.histogram.getCountAtBin(j) * max_width / max_count;
                        double binMinValue = this.histogram.getBinMinValue(j);
                        double binMaxValue = this.histogram.getBinMaxValue(j);
                        int y1 = this.coordinateAxis.worldToScreen(binMinValue);
                        int y2 = this.coordinateAxis.worldToScreen(binMaxValue);
                        boolean filtered = !this.rangeModel.isInverted() ? this.rangeModel != null && (this.rangeModel.getStart() > binMinValue || this.rangeModel.getEnd() < binMaxValue) : this.rangeModel != null && this.rangeModel.getStart() > binMinValue && this.rangeModel.getEnd() < binMaxValue;
                        g.setColor(this.fillColor);
                        g.fillRect(0, y2, width, y1 - y2);
                        if (filtered) {
                            g.setColor(this.filteredOutlineColor);
                        } else {
                            g.setColor(this.outlineColor);
                        }
                        g.drawLine(x_prev, y1, 0 + width, y1);
                        g.drawLine(0 + width, y1, 0 + width, y2);
                        if (j == this.histogram.getNumberOfBins() - 1 || this.histogram.getCountAtBin(j + 1) == 0) {
                            g.drawLine(0 + width, y2, 0, y2);
                            x_prev = 0;
                            continue;
                        }
                        x_prev = 0 + width;
                    }
                    break;
                }
                case HORIZONTAL: {
                    this.coordinateAxis.setScreenSize(d.width);
                    boolean y1 = false;
                    int y2 = d.height;
                    g.setColor(this.lineColor);
                    g.drawLine(0, y2 - 1, this.coordinateAxis.getScreenSize() - 1, y2 - 1);
                    int max_height = y2 - 0 - 1;
                    int max_count = this.histogram.getMaxCount();
                    int x_prev = 0;
                    for (int j = 0; j < this.histogram.getNumberOfBins(); ++j) {
                        if (this.histogram.getCountAtBin(j) <= 0) continue;
                        int height = this.histogram.getCountAtBin(j) * max_height / max_count;
                        double binMinValue = this.histogram.getBinMinValue(j);
                        double binMaxValue = this.histogram.getBinMaxValue(j);
                        int x1 = this.coordinateAxis.worldToScreen(binMinValue);
                        int x2 = this.coordinateAxis.worldToScreen(binMaxValue);
                        boolean filtered = !this.rangeModel.isInverted() ? this.rangeModel != null && (this.rangeModel.getStart() > binMinValue || this.rangeModel.getEnd() < binMaxValue) : this.rangeModel != null && this.rangeModel.getStart() > binMinValue && this.rangeModel.getEnd() < binMaxValue;
                        g.setColor(this.fillColor);
                        g.fillRect(x1, d.height - height, x2 - x1, height);
                        if (filtered) {
                            g.setColor(this.filteredOutlineColor);
                        } else {
                            g.setColor(this.outlineColor);
                        }
                        int h = d.height - (0 + height) - 1;
                        g.drawLine(x1, d.height - x_prev, x1, h);
                        g.drawLine(x1, h, x2, h);
                        if (j == this.histogram.getNumberOfBins() - 1 || this.histogram.getCountAtBin(j + 1) == 0) {
                            g.drawLine(x2, h, x2, d.height - 0);
                            x_prev = 0;
                            continue;
                        }
                        x_prev = 0 + height;
                    }
                    break;
                }
            }
        }
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

