/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.presentation.implementation;

import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.swing.PartialLineBorder;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.filter.FilterEvent;
import com.macrofocus.filter.FilterListener;
import com.treemap.TreeMapModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;

public class PathPanel<N>
extends JPanel {
    private final Timer timer;
    private TreeMapModel<N, ?, ?, Color, Font> model;
    private static final ImageIcon arrowIcon = JideIconsFactory.getImageIcon((String)"jide/direction_right.gif");
    private final Dimension minimumSize;
    final SingleSelectionListener<N> probingListener = new SingleSelectionListener<N>(){

        public void selectionChanged(SingleSelectionEvent<N> treeMapNodeSingleSelectionEvent) {
            PathPanel.this.scheduleUpdatePathPanel();
        }
    };
    final SelectionListener<N> selectionListener = new SelectionListener<N>(){

        public void selectionChanged(SelectionEvent<N> treeMapNodeSingleSelectionEvent) {
            PathPanel.this.scheduleUpdatePathPanel();
        }
    };
    final FilterListener<N> filterListener = new FilterListener<N>(){

        public void filterChanged(FilterEvent<N> event) {
            PathPanel.this.scheduleUpdatePathPanel();
        }
    };

    public PathPanel() {
        BoxLayout layout = new BoxLayout(this, 0);
        this.setLayout(layout);
        this.timer = new Timer(30, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathPanel.this.updatePath();
            }
        });
        this.timer.setRepeats(false);
        this.timer.setCoalesce(true);
        this.addLabel("Dummy");
        this.minimumSize = super.getPreferredSize();
        this.setOpaque(false);
        this.updatePath();
    }

    private void scheduleUpdatePathPanel() {
        this.timer.restart();
    }

    public void setModel(TreeMapModel<N, ?, ?, Color, Font> treeMapModel) {
        if (this.model != null) {
            this.model.getProbing().removeSingleSelectionListener(this.probingListener);
            this.model.getSelection().removeSelectionListener(this.selectionListener);
            this.model.getFilter().removeFilterListener(this.filterListener);
        }
        this.model = treeMapModel;
        if (this.model != null) {
            treeMapModel.getProbing().addSingleSelectionListener(this.probingListener);
            treeMapModel.getSelection().addSelectionListener(this.selectionListener);
            treeMapModel.getFilter().addFilterListener(this.filterListener);
        }
        this.updatePath();
    }

    private void updatePath() {
        this.removeAll();
        if (this.model != null) {
            MutableSingleSelection probingModel = this.model.getProbing();
            if (probingModel != null && probingModel.isActive()) {
                ArrayList<Object[]> paths = new ArrayList<Object[]>();
                if (probingModel != null && probingModel.isActive()) {
                    ArrayList<Object> path = new ArrayList<Object>();
                    Object leaf = probingModel.getSelected();
                    do {
                        path.add(0, leaf);
                    } while ((leaf = this.model.getParent(leaf)) != null);
                    paths.add(path.toArray());
                }
                ArrayList<Object> lcd = new ArrayList<Object>();
                int depth = 0;
                if (paths.size() > 0) {
                    boolean found = true;
                    do {
                        Object current = null;
                        for (Object[] path : paths) {
                            if (!(found &= path.length > depth)) continue;
                            if (current != null) {
                                if (current == path[depth]) continue;
                                found = false;
                                continue;
                            }
                            current = path[depth];
                        }
                        if (found && depth > 0) {
                            lcd.add(current);
                        }
                        ++depth;
                    } while (found);
                }
                for (int i = 0; i < lcd.size(); ++i) {
                    Object node = lcd.get(i);
                    this.addLabel(this.model.getLabelName(node));
                    if (i >= lcd.size() - 1) continue;
                    this.add(new JLabel(arrowIcon));
                }
            } else {
                int visibleCount;
                Object visible = this.model.getFilter().getFilteredCount() > 0 ? visibleCount + " " + ((visibleCount = this.model.getDataFrame().getRowCount() - this.model.getFilter().getFilteredCount()) > 1 ? "are" : "is") : "all are";
                JLabel label = new JLabel("Of " + this.model.getDataFrame().getRowCount() + " items, " + (String)visible + " visible, and " + this.model.getSelection().getSelectedCount() + " " + (this.model.getSelection().getSelectedCount() > 1 ? "are" : "is") + " selected");
                this.add(label);
            }
        }
        this.validate();
        this.repaint();
    }

    private void addLabel(String name) {
        JLabel label = new JLabel(name){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(0, this.getPreferredSize().height);
            }
        };
        label.setBorder(BorderFactory.createCompoundBorder((Border)new PartialLineBorder(Color.gray, 1, true), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.add(label);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(1, this.minimumSize.height);
    }
}

