/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.presentation.implementation;

import com.macrofocus.layoutmanager.FixedProportionalConstraint;
import com.macrofocus.layoutmanager.HorizontalProportionalLayoutManager;
import com.macrofocus.layoutmanager.MinimumProportionalConstraint;
import com.macrofocus.layoutmanager.VerticalProportionalLayoutManager;
import com.macrofocus.plot.SwingAxisPlotPanel;
import com.macrofocus.slider.BoundedIntervalRangeSliderAdapter;
import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.SliderView;
import com.macrofocus.slider.swing.JRangeSlider;
import com.macrofocus.slider.swing.SimpleRangeSliderController;
import com.macrofocus.slider.swing.TrapezoidRangeSlider;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapPanel;
import com.treemap.TreeMapView;
import com.treemap.app.swing.presentation.implementation.PathPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.print.Printable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SwingTreeMapPanel
extends JPanel
implements TreeMapPanel<JComponent> {
    private final TreeMapView<JComponent, ?, ?, ?, Color, Font> treeMap;
    private final PathPanel pathPanel;

    public SwingTreeMapPanel(TreeMapView<JComponent, ?, ?, ?, Color, Font> treeMap) {
        this.treeMap = treeMap;
        this.setLayout(new BorderLayout());
        SwingAxisPlotPanel axisPlotPanel = new SwingAxisPlotPanel();
        this.add((Component)axisPlotPanel.getNativeComponent(), "Center");
        axisPlotPanel.addComponent((Object)((JComponent)treeMap.getNativeComponent()));
        axisPlotPanel.setShowTopTimeAxis(true);
        axisPlotPanel.setTopAxisVisible(true);
        BoundedIntervalRangeSliderAdapter xSliderModel = new BoundedIntervalRangeSliderAdapter(treeMap.getXRangeModel(), 0.0, 0.0);
        JRangeSlider xRangeSlider = new JRangeSlider((RangeSliderModel)xSliderModel, 0);
        TrapezoidRangeSlider xZoomTrapezoid = new TrapezoidRangeSlider(xRangeSlider);
        xZoomTrapezoid.setOpaque(true);
        JPanel xRange = new JPanel();
        xRange.setLayout((LayoutManager)new VerticalProportionalLayoutManager());
        xRange.add((Component)xRangeSlider, new MinimumProportionalConstraint(0, 0, 0, 0));
        xRange.add((Component)xZoomTrapezoid, new FixedProportionalConstraint(12, 0, 0, 0, 0));
        new SimpleRangeSliderController((SliderView)xRangeSlider, true);
        axisPlotPanel.addTopTimeAxisComponent((Object)xRange);
        axisPlotPanel.setRightAxisVisible(true);
        BoundedIntervalRangeSliderAdapter ySliderModel = new BoundedIntervalRangeSliderAdapter(treeMap.getYRangeModel(), 0.0, 0.0);
        JRangeSlider yRangeSlider = new JRangeSlider((RangeSliderModel)ySliderModel, 1);
        TrapezoidRangeSlider yZoomTrapezoid = new TrapezoidRangeSlider(yRangeSlider);
        yZoomTrapezoid.setOpaque(true);
        JPanel yRange = new JPanel();
        yRange.setLayout((LayoutManager)new HorizontalProportionalLayoutManager());
        yRange.add((Component)yZoomTrapezoid, new FixedProportionalConstraint(12, 0, 0, 0, 0));
        yRange.add((Component)yRangeSlider, new MinimumProportionalConstraint(0, 0, 0, 0));
        new SimpleRangeSliderController((SliderView)yRangeSlider, true);
        axisPlotPanel.addRightYAxisComponent((Object)yRange);
        this.pathPanel = new PathPanel();
        this.pathPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0));
        this.add((Component)this.pathPanel, "South");
        this.pathPanel.setVisible(false);
    }

    public void setModel(TreeMapModel model) {
        this.treeMap.setModel(model);
        this.pathPanel.setModel(model);
    }

    public TreeMapView<JComponent, ?, ?, ?, Color, Font> getTreeMapView() {
        return this.treeMap;
    }

    public Printable getPrintable() {
        return null;
    }

    public JComponent getNativeComponent() {
        return this;
    }
}

