/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.presentation.implementation.treedee;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.awt.TextRenderer;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Rectangle2D;
import com.treemap.NoTreeMapField;
import com.treemap.ThreeDTreeMapView;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import com.treemap.app.swing.presentation.implementation.treedee.ThreeDeeListener;
import com.treemap.app.swing.presentation.implementation.treedee.TreeDeeModel;
import com.treemap.app.swing.presentation.implementation.treedee.TreeDeeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class OpenGLPanel<N, Row, Column>
extends GLCanvas
implements TreeDeeView<N, Row, Column>,
ThreeDTreeMapView<N, Row, Column, Color, Font, Component> {
    private boolean _showTiming = true;
    private static double DEFAULT_HEIGHT = 0.0;
    public float xrot = 0.0f;
    public float yrot = 0.0f;
    private GL2 gl;
    private int[] viewport = new int[4];
    private double[] modelview = new double[16];
    private double[] projection = new double[16];
    private TreeDeeModel<N, Row, Column> treeDeeModel;
    private GLU glu = new GLU();
    private final int fontSize = 16;
    private Projection perspectiveMode = Projection.OrthographicCavalier;
    private TextRenderer renderer;

    public OpenGLPanel(GLCapabilities capabilities) {
        super((GLCapabilitiesImmutable)capabilities);
        this.addGLEventListener(new GLEventListener(){

            public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
                OpenGLPanel.this.setup(drawable.getGL().getGL2(), width, height);
            }

            public void init(GLAutoDrawable drawable) {
                OpenGLPanel.this.renderer = new TextRenderer(new Font("SansSerif", 0, 16));
                GL gl = drawable.getGL();
                gl.glEnable(2929);
                gl.glEnable(2881);
                gl.glHint(3152, 4354);
                gl.glHint(3155, 4354);
                gl.glEnable(6145);
                gl.glEnable(32925);
                gl.getGL2().glShadeModel(7425);
                gl.glHint(3153, 4354);
                gl.glHint(3154, 4354);
                gl.glHint(3155, 4354);
                gl.glHint(3152, 4354);
                gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            }

            public void dispose(GLAutoDrawable drawable) {
            }

            public void display(GLAutoDrawable drawable) {
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 38: {
                        OpenGLPanel.this.xrot += 1.0f;
                        break;
                    }
                    case 40: {
                        OpenGLPanel.this.xrot -= 1.0f;
                        break;
                    }
                    case 37: {
                        OpenGLPanel.this.yrot -= 1.0f;
                        break;
                    }
                    case 39: {
                        OpenGLPanel.this.yrot += 1.0f;
                    }
                }
                OpenGLPanel.this.repaint();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                OpenGLPanel.this.treeDeeModel.getTreeMapModel().getProbing().setSelected(OpenGLPanel.this.getMousePosition(e.getX(), OpenGLPanel.this.getHeight() - e.getY()));
                OpenGLPanel.this.repaint();
            }
        });
        this.treeDeeModel = new TreeDeeModel();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public N getMousePosition(int x, int y) {
        double[] wcoord = new double[4];
        float winX = x;
        float winY = (float)this.viewport[3] - (float)y;
        FloatBuffer floatBuffer = FloatBuffer.allocate(1);
        this.gl.glReadPixels((int)winX, (int)winY, 1, 1, 6402, 5126, (Buffer)floatBuffer);
        float winZ = floatBuffer.get(0);
        boolean test = this.glu.gluUnProject((double)winX, (double)winY, (double)winZ, this.modelview, 0, this.projection, 0, this.viewport, 0, wcoord, 0);
        Object node = this.treeDeeModel.getTreeMapModel().getNode(new Point((int)wcoord[0], (int)wcoord[1]));
        System.out.println("x: " + wcoord[0] + ", y: " + wcoord[1] + ", z: " + wcoord[2] + " worked? " + test);
        return (N)node;
    }

    public void paint(Graphics g) {
        long current = System.currentTimeMillis();
        super.paint(g);
        if (this._showTiming) {
            g.setColor(Color.red);
            String str = System.currentTimeMillis() - current + " milliseconds";
            g.drawString(str, 5, this.getSize().height - 5);
            System.out.println(str);
        }
    }

    @Override
    public void setModel(TreeMapModel<N, Row, Column, Color, Font> treeMapModel) {
        this.treeDeeModel.setTreeMapModel(treeMapModel);
        this.treeDeeModel.addListener(new ThreeDeeListener(){

            @Override
            public void modelChanged() {
                OpenGLPanel.this.repaint();
            }
        });
    }

    protected void setup(GL2 gl2, int width, int height) {
        gl2.glMatrixMode(5889);
        gl2.glLoadIdentity();
        double alpha = 45.0;
        double[] cavalier = new double[]{1.0, 0.0, -1.0 * Math.cos(Math.toRadians(alpha)), 0.0, 0.0, 1.0, Math.sin(Math.toRadians(alpha)), 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        float widthHeightRatio = (float)this.getWidth() / (float)this.getHeight();
        switch (this.perspectiveMode) {
            case Perspective: {
                this.glu.gluPerspective(90.0f, widthHeightRatio, 1.0f, 100000.0f);
                this.glu.gluLookAt((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), 400.0f, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2), 0.0f, 0.0f, 1.0f, 0.0f);
                break;
            }
            case Orthographic: {
                gl2.glOrthof(0.0f, (float)width, 0.0f, (float)height, -1.0E7f, 1.0E8f);
                break;
            }
            case PerspectiveCavalier: {
                this.glu.gluPerspective(90.0f, widthHeightRatio, 1.0f, 100000.0f);
                this.glu.gluLookAt((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), 400.0f, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2), 0.0f, 0.0f, 1.0f, 0.0f);
                gl2.glMultTransposeMatrixd(cavalier, 0);
                break;
            }
            case OrthographicCavalier: {
                gl2.glOrthof(0.0f, (float)width, 0.0f, (float)height, -1.0E7f, 1.0E8f);
                gl2.glMultTransposeMatrixd(cavalier, 0);
            }
        }
        gl2.glMatrixMode(5888);
        gl2.glLoadIdentity();
        gl2.glViewport(0, 0, width, height);
        gl2.glEnable(2929);
    }

    protected void render(GL2 gl2, int w, int h) {
        Rectangle2D rootBounds;
        Object rootNode;
        this.gl = gl2;
        gl2.glClear(16640);
        gl2.glLoadIdentity();
        gl2.glTranslatef((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), 0.0f);
        gl2.glRotatef(this.xrot, 1.0f, 0.0f, 0.0f);
        gl2.glRotatef(this.yrot, 0.0f, 1.0f, 0.0f);
        gl2.glTranslatef((float)(-this.getWidth() / 2), (float)(-this.getHeight() / 2), 0.0f);
        TreeMapModel<N, Row, Column, Color, Font> treeMapModel = this.treeDeeModel.getTreeMapModel();
        if (treeMapModel != null && (rootNode = treeMapModel.getRoot()) != null && (rootBounds = treeMapModel.getBounds(rootNode)) != null) {
            float xMax = (float)rootBounds.getWidth();
            float yMax = (float)rootBounds.getHeight();
            TreeMapField field = (TreeMapField)treeMapModel.getSettings().getHeightVariableSelection().getSelected();
            double maxHeight = field instanceof NoTreeMapField ? DEFAULT_HEIGHT : treeMapModel.getNumericMax(field);
            for (Object node : treeMapModel.preorderEnumeration(rootNode)) {
                String text;
                Rectangle2D bounds = treeMapModel.getBounds(node);
                float width = (float)bounds.getWidth();
                float height = (float)bounds.getHeight();
                float x = (float)bounds.getX();
                float y = (float)bounds.getY();
                if (treeMapModel.hasNoChildren(node)) {
                    Object value;
                    float size = (float)DEFAULT_HEIGHT;
                    if (!(field instanceof NoTreeMapField) && (value = field.getValue(node)) != null) {
                        size = ((Number)value).floatValue() / (float)maxHeight;
                        size = (float)((double)size * treeMapModel.getSettings().getMaximumHeight() * 2.0 * Math.min(treeMapModel.getSettings().getDimension().getWidth(), treeMapModel.getSettings().getDimension().getHeight()));
                    }
                    Color color = treeMapModel.getProbing().getSelected() == node ? Color.yellow : (Color)treeMapModel.getColor(node).getNativeColor();
                    float p1x = x;
                    float p1y = yMax - y;
                    float p2x = x + width;
                    float p2y = yMax - y;
                    float p3x = x + width;
                    float p3y = yMax - (y + height);
                    float p4x = x;
                    float p4y = yMax - (y + height);
                    gl2.glBegin(7);
                    gl2.glColor3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
                    gl2.glVertex3f(p1x, p1y, size);
                    gl2.glVertex3f(p2x, p2y, size);
                    gl2.glVertex3f(p3x, p3y, size);
                    gl2.glVertex3f(p4x, p4y, size);
                    gl2.glEnd();
                    color = Color.gray;
                    gl2.glBegin(7);
                    gl2.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.5f);
                    gl2.glVertex3f(p1x, p1y, size);
                    gl2.glVertex3f(p1x, p1y, 0.0f);
                    gl2.glVertex3f(p4x, p4y, 0.0f);
                    gl2.glVertex3f(p4x, p4y, size);
                    gl2.glEnd();
                    color = Color.gray;
                    gl2.glBegin(7);
                    gl2.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.5f);
                    gl2.glVertex3f(p2x, p2y, size);
                    gl2.glVertex3f(p2x, p2y, 0.0f);
                    gl2.glVertex3f(p3x, p3y, 0.0f);
                    gl2.glVertex3f(p3x, p3y, size);
                    gl2.glEnd();
                    color = Color.gray;
                    gl2.glBegin(7);
                    gl2.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.5f);
                    gl2.glVertex3f(p1x, p1y, size);
                    gl2.glVertex3f(p1x, p1y, 0.0f);
                    gl2.glVertex3f(p2x, p2y, 0.0f);
                    gl2.glVertex3f(p2x, p2y, size);
                    gl2.glEnd();
                    color = Color.gray;
                    gl2.glBegin(7);
                    gl2.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.5f);
                    gl2.glVertex3f(p4x, p4y, size);
                    gl2.glVertex3f(p4x, p4y, 0.0f);
                    gl2.glVertex3f(p3x, p3y, 0.0f);
                    gl2.glVertex3f(p3x, p3y, size);
                    gl2.glEnd();
                    gl2.glBegin(7);
                    gl2.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.5f);
                    gl2.glVertex3f(p1x, p1y, 0.0f);
                    gl2.glVertex3f(p2x, p2y, 0.0f);
                    gl2.glVertex3f(p3x, p3y, 0.0f);
                    gl2.glVertex3f(p4x, p4y, 0.0f);
                    gl2.glEnd();
                    continue;
                }
                if (treeMapModel.isRoot(node) || (text = node.toString()) == null || text.length() <= 0 || !(16.0 <= (double)height * 0.2)) continue;
                this.renderer.begin3DRendering();
                this.renderer.setColor(Color.lightGray);
                this.renderer.draw3D(text, (float)((int)x), (float)((int)(yMax - y - 16.0f)), 0.0f, 1.0f);
                this.renderer.end3DRendering();
            }
        }
        this.viewport = new int[4];
        this.projection = new double[16];
        gl2.glGetDoublev(2983, this.projection, 0);
        gl2.glGetIntegerv(2978, this.viewport, 0);
        this.modelview = new double[16];
        gl2.glGetDoublev(2982, this.modelview, 0);
    }

    public void setStyleClass(String ... styleClasses) {
    }

    public Component getNativeComponent() {
        return this;
    }

    static enum Projection {
        Perspective,
        Orthographic,
        PerspectiveCavalier,
        OrthographicCavalier;

    }
}

