/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.presentation.implementation.treedee;

import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import com.treemap.app.swing.presentation.implementation.treedee.TreeDeeModel;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;

public class PickBehavior<N, Row, Column>
extends Behavior {
    private WakeupOr wakeupCondition;
    private PickCanvas pickCanvas;
    private TreeDeeModel<N, Row, Column> treeDeeModel;

    public PickBehavior(Canvas3D canvas3D, BranchGroup sceneRoot, TreeDeeModel<N, Row, Column> treeDeeModel) {
        this.treeDeeModel = treeDeeModel;
        this.pickCanvas = new PickCanvas(canvas3D, sceneRoot);
        this.pickCanvas.setTolerance(0.0f);
    }

    public void initialize() {
        WakeupCriterion[] wakeupCriteria = new WakeupCriterion[]{new WakeupOnAWTEvent(503), new WakeupOnAWTEvent(501)};
        this.wakeupCondition = new WakeupOr(wakeupCriteria);
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    public void processStimulus(Enumeration stimulusCriteria) {
        AWTEvent[] evt = null;
        while (stimulusCriteria.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)stimulusCriteria.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            evt = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
        }
        if (evt[0] instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)evt[0];
            this.processMouseEvent(mouseEvent);
        }
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    private void processMouseEvent(MouseEvent evt) {
        if (evt.getID() == 503) {
            Object userData;
            TransformGroup tg;
            this.pickCanvas.setShapeLocation(evt.getX(), evt.getY());
            this.pickCanvas.setMode(256);
            PickResult pickResult = this.pickCanvas.pickClosest();
            if (pickResult != null && (tg = (TransformGroup)pickResult.getNode(32)) != null && (userData = tg.getUserData()) != null) {
                Object node = userData;
                this.treeDeeModel.getTreeMapModel().getProbing().setSelected(node);
            }
        }
    }
}

