/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.presentation.implementation.treetable;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.grid.TreeTableModel;
import com.macrofocus.format.CPFormat;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.dataframe.DataFrameListener;
import com.treemap.AbstractTreeMapNode;
import com.treemap.TreeMapEvent;
import com.treemap.TreeMapListener;
import com.treemap.TreeMapModel;
import com.treemap.app.swing.presentation.implementation.TreeMapRow;
import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class TreeMapTreeTableModel<Row, Column>
extends TreeTableModel
implements StyleModel {
    private EditorContext editorContext = new EditorContext("TreeTable");
    private final TreeMapModel<AbstractTreeMapNode, Row, Column, Color, Font> treeMapModel;
    private final DecimalFormat sizeFormat = new DecimalFormat("#0.00%");
    private final boolean expertMode;

    public TreeMapTreeTableModel(final TreeMapModel<AbstractTreeMapNode, Row, Column, Color, Font> treeMapModel, final boolean expertMode) {
        super(TreeMapTreeTableModel.getChildrenList((AbstractTreeMapNode)treeMapModel.getRoot(), treeMapModel, expertMode));
        this.treeMapModel = treeMapModel;
        this.expertMode = expertMode;
        treeMapModel.addListener(new TreeMapListener(){

            public void tableModelChanged() {
            }

            public void treeMapChanged(final TreeMapEvent event) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (event.isGroupByChanged() || event.isLayoutChanged()) {
                            TreeMapTreeTableModel.this.setOriginalRows(TreeMapTreeTableModel.getChildrenList((AbstractTreeMapNode)treeMapModel.getRoot(), treeMapModel, expertMode));
                        } else if (event.isColorsChanged()) {
                            TreeMapTreeTableModel.this.fireTableDataChanged();
                        } else if (event.isLayoutChanged() && expertMode) {
                            TreeMapTreeTableModel.this.fireTableDataChanged();
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        });
        treeMapModel.getDataFrame().addDataFrameListener(new DataFrameListener<Row, Column>(){

            public void dataFrameChanged(DataFrameEvent<Row, Column> event) {
                TreeMapTreeTableModel.this.fireTableStructureChanged();
            }
        });
    }

    public int getColumnCount() {
        return this.treeMapModel.getDataFrame().getColumnCount() + (this.expertMode ? 5 : 2);
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.treeMapModel.getDataFrame().getColumnName(this.treeMapModel.getDataFrame().getColumnKey(columnIndex));
            }
            case 1: {
                return "Size";
            }
            case 2: {
                return "Color";
            }
            case 3: {
                if (this.expertMode) {
                    return "Area";
                }
            }
            case 4: {
                if (this.expertMode) {
                    return "Error";
                }
            }
            case 5: {
                if (!this.expertMode) break;
                return "Accuracy";
            }
        }
        return this.treeMapModel.getDataFrame().getColumnName(this.treeMapModel.getDataFrame().getColumnKey(columnIndex - (this.expertMode ? 5 : 2)));
    }

    public static List<?> getChildrenList(AbstractTreeMapNode node, TreeMapModel<AbstractTreeMapNode, ?, ?, Color, Font> model, boolean expertMode) {
        ArrayList<TreeMapRow> list = new ArrayList<TreeMapRow>();
        if (node != null) {
            for (AbstractTreeMapNode child : model.getChildren((Object)node)) {
                if (((Boolean)model.getSettings().getHideFilterResultsSelection().getValue()).booleanValue() && model.getFilter().isFiltered((Object)child) || ((Boolean)model.getSettings().getHideSearchResultsSelection().getValue()).booleanValue() && model.getSearch().isFiltered((Object)child) || !child.hasNoChildren() && TreeMapTreeTableModel.getChildrenList(child, model, expertMode).size() <= 0) continue;
                TreeMapRow row = new TreeMapRow(child, model, expertMode);
                list.add(row);
            }
        }
        return list;
    }

    public ConverterContext getConverterContextAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                CPFormat format = this.treeMapModel.getSettings().getFieldSettings(this.treeMapModel.getTreeMapField(columnIndex)).getFormat();
                return new ConverterContext("treetable", format != null ? format.getNativeFormat() : null);
            }
            case 1: {
                return new ConverterContext("treetable", (Object)this.sizeFormat);
            }
            case 2: {
                return null;
            }
            case 3: {
                if (this.expertMode) {
                    return new ConverterContext("treetable", (Object)this.sizeFormat);
                }
            }
            case 4: {
                if (this.expertMode) {
                    return new ConverterContext("treetable", (Object)this.sizeFormat);
                }
            }
            case 5: {
                if (!this.expertMode) break;
                return new ConverterContext("treetable", (Object)this.sizeFormat);
            }
        }
        CPFormat format = this.treeMapModel.getSettings().getFieldSettings(this.treeMapModel.getTreeMapField(columnIndex - (this.expertMode ? 5 : 2))).getFormat();
        return new ConverterContext("treetable", format != null ? format.getNativeFormat() : null);
    }

    public EditorContext getEditorContextAt(int rowIndex, int columnIndex) {
        return this.editorContext;
    }

    public CellStyle getCellStyleAt(int row, int column) {
        TreeMapRow r = (TreeMapRow)this.getRowAt(row);
        if (r != null) {
            AbstractTreeMapNode treeMapNode = r.getNode();
            if (this.treeMapModel.getFilter().isFiltered((Object)treeMapNode) || this.treeMapModel.getSearch().isFiltered((Object)treeMapNode) || this.isFiltered(treeMapNode, this.treeMapModel)) {
                CellStyle style = new CellStyle();
                style.setFontStyle(2);
                style.setForeground(Color.GRAY);
                return style;
            }
            return null;
        }
        return null;
    }

    private boolean isFiltered(AbstractTreeMapNode node, TreeMapModel<AbstractTreeMapNode, Row, Column, Color, Font> model) {
        for (AbstractTreeMapNode child : model.preorderEnumeration((Object)node)) {
            if (!child.hasNoChildren() || this.treeMapModel.getFilter().isFiltered((Object)child) || this.treeMapModel.getSearch().isFiltered((Object)child)) continue;
            return false;
        }
        return true;
    }

    public boolean isCellStyleOn() {
        return true;
    }
}

