/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.screenshots;

import com.macrofocus.application.document.OpenDocumentException;
import com.macrofocus.application.document.View;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.util.file.FileHelper;
import com.macrofocus.util.swing.export.ComponentCustomizer;
import com.macrofocus.util.swing.export.format.AbstractRasterExportFormat;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.macrofocus.util.swing.export.format.DefaultContentProvider;
import com.macrofocus.util.swing.export.format.ExportFormat;
import com.macrofocus.util.swing.export.format.PNGExportFormat;
import com.macrofocus.util.swing.export.format.TIFFExportFormat;
import com.macrofocus.util.swing.export.format.WebPExportFormat;
import com.macrofocus.util.swing.export.format.XMLGraphicsPDFExportFormat;
import com.treemap.app.document.TreeMapView;
import com.treemap.app.java.document.JavaTreeMapDocument;
import com.treemap.app.swing.document.SwingTreeMapApplication;
import com.treemap.app.swing.document.SwingTreeMapView;
import com.treemap.app.swing.document.export.TreeMapComponentCustomizer;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ScreenShotsHelper {
    private static final AbstractRasterExportFormat[] rasterExportFormats = new AbstractRasterExportFormat[]{new PNGExportFormat(), new TIFFExportFormat(), new WebPExportFormat()};
    private static final ExportFormat[] vectorExportFormats = new ExportFormat[]{new XMLGraphicsPDFExportFormat()};
    static final AbstractRasterExportFormat[] documentationExportFormats = new AbstractRasterExportFormat[]{new PNGExportFormat()};
    private static final ComponentCustomizer componentCustomizer = new TreeMapComponentCustomizer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void takeScreenShot(final File output, final String name, final SwingTreeMapApplication application) {
        application.waitUntilReady();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    for (AbstractRasterExportFormat abstractRasterExportFormat : rasterExportFormats) {
                        ScreenShotsHelper.saveImage(abstractRasterExportFormat, application, name, output, 32.4f);
                        ScreenShotsHelper.saveImage(abstractRasterExportFormat, application, name, output, abstractRasterExportFormat.getScreenDPI());
                        ScreenShotsHelper.saveImage(abstractRasterExportFormat, application, name, output, 300.0f);
                        ScreenShotsHelper.saveImage(abstractRasterExportFormat, application, name, output, 600.0f);
                    }
                    for (AbstractRasterExportFormat abstractRasterExportFormat : vectorExportFormats) {
                        ScreenShotsHelper.saveImage((ExportFormat<Component>)abstractRasterExportFormat, application, name, output);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void saveImage(AbstractRasterExportFormat exportFormat, SwingTreeMapApplication application, String name, File output, float dpi) {
        File destination;
        exportFormat.setOutputDPI(dpi);
        String dpiString = Integer.toString((int)dpi);
        try {
            destination = new File(output, "application/" + dpiString + "dpi");
            if (!destination.exists()) {
                destination.mkdirs();
            }
            exportFormat.save((ContentProvider)new DefaultContentProvider((Object)application.getRootWindow()), new File(destination, name + "-" + dpiString + "dpi." + exportFormat.getFileFilter().getDefaultExtension()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            destination = new File(output, "treemap/" + dpiString + "dpi");
            if (!destination.exists()) {
                destination.mkdirs();
            }
            SwingTreeMapView focusedView = application.getFocusedView();
            exportFormat.save((ContentProvider)new DefaultContentProvider((Object)((Component)focusedView.getTreeMapView().getNativeComponent())), new File(destination, name + "-treemap-" + dpiString + "dpi." + exportFormat.getFileFilter().getDefaultExtension()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void saveImage(ExportFormat<Component> exportFormat, SwingTreeMapApplication application, String name, File output) {
        try {
            File destination = new File(output, "treemap");
            if (!destination.exists()) {
                destination.mkdirs();
            }
            SwingTreeMapView focusedView = application.getFocusedView();
            exportFormat.save((ContentProvider)new DefaultContentProvider((Object)((Component)focusedView.getTreeMapView().getNativeComponent())), new File(destination, name + "-treemap." + exportFormat.getFileFilter().getDefaultExtension()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void close(SwingTreeMapApplication application) {
        application.getFocusedModeltDirty(false);
        application.closeView((View)application.getFocusedView());
    }

    static TreeMapView open(File dataset, SwingTreeMapApplication application) {
        try {
            JavaTreeMapDocument document = application.openLocalDocument(dataset, dataset.getName(), null);
            CPWindow window = application.createWindow();
            TreeMapView<JComponent, JavaTreeMapDocument> view = application.createView((JFrame)window.getNativeWindow(), document);
            application.setup(window, (View)view);
            view.waitUntilReady();
            return view;
        }
        catch (OpenDocumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    static void saveForDocumentation(SwingTreeMapApplication application, File file, Component component) {
        application.waitUntilReady();
        for (AbstractRasterExportFormat exportFormat : documentationExportFormats) {
            try {
                System.err.println(component);
                component = componentCustomizer.configure(component);
                exportFormat.setOutputDPI(exportFormat.getScreenDPI());
                System.out.println("Saving " + file);
                exportFormat.save((ContentProvider)new DefaultContentProvider((Object)component), FileHelper.replaceSuffix((File)file, (String)exportFormat.getFileFilter().getDefaultExtension()));
                System.out.println(exportFormat.getScreenDPI() + ", " + exportFormat.getOutputDPI());
                exportFormat.setOutputDPI(exportFormat.getScreenDPI() * 2.0f);
                System.out.println(exportFormat.getScreenDPI() + ", " + exportFormat.getOutputDPI());
                exportFormat.save((ContentProvider)new DefaultContentProvider((Object)component), FileHelper.replaceSuffix((File)new File(file.getParentFile(), file.getName() + "@2x"), (String)exportFormat.getFileFilter().getDefaultExtension()));
                componentCustomizer.restore(component);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

