/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.v4.settings.algorithm;

import com.macrofocus.cartogram.Engine;
import com.macrofocus.cartogram.OutputLayerModel;
import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.data.dataframe.DataFrameTableModel;
import com.macrofocus.data.table.Column;
import com.macrofocus.geo.model.SimpleGeoModel;
import com.macrofocus.geo.view.Java2DConverter;
import com.macrofocus.geom.Area;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.transform.OneDScreenTransform;
import com.macrofocus.transform.SimpleOneDScreenTransform;
import com.treemap.AbstractAlgorithm;
import com.treemap.AbstractTreeMapNode;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapWorker;
import com.treemap.app.swing.v4.model.MTreeMapModel;
import com.treemap.swing.tagcloud.SwingShape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.table.TableModel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class CartogramAlgorithm<N, Row, C, Color, Font>
extends AbstractAlgorithm<N, Row, C, Color, Font> {
    private double resolution = 0.125;

    public void startLayout(com.macrofocus.geom.Rectangle2D bounds, TreeMapModel<N, Row, C, Color, Font> model, N root, final TreeMapWorker worker) {
        block9: {
            block8: {
                TreeMapField geometryField = null;
                for (int c = 0; c < model.getColumnCount(); ++c) {
                    if (!Geometry.class.isAssignableFrom(model.getColumnClass(((MTreeMapModel)model).getDataFrame().getColumnKey(c)))) continue;
                    geometryField = model.getTreeMapField(c);
                    break;
                }
                if (geometryField == null || !geometryField.isValid()) break block8;
                com.macrofocus.geom.Rectangle2D b = this.computeBounds(model, root, geometryField);
                SimpleSingleSelection sizeColumn = new SimpleSingleSelection();
                TreeMapField selected = model.getSettings().getSizeTreeMapField();
                SimpleGeoModel input = new SimpleGeoModel((TableModel)new DataFrameTableModel(((MTreeMapModel)model).getDataFrame()));
                sizeColumn.setSelected((Object)input.getColumn(((MTreeMapModel)model).getDataFrame().getColumnAddress(selected.getIndex())));
                Java2DConverter inputConverter = this.createConverter(bounds, input.getBounds());
                for (Object node : model.depthFirstIterator(root)) {
                    if (model.hasNoChildren(node)) {
                        Geometry geometry = (Geometry)geometryField.getValue(node);
                        model.setShape(node, (Shape)new SwingShape(inputConverter.toShape(geometry)));
                        continue;
                    }
                    Area area = new Area();
                    for (Object child : model.getChildren(node)) {
                        Shape shape = model.getShape(child);
                        if (shape == null) continue;
                        area.add(new Area(shape));
                    }
                    model.setShape(node, (Shape)area);
                }
                if (!model.getSettings().getSizeTreeMapField().isValid()) break block9;
                Engine engine = new Engine(input, (MutableSingleSelection<Column>)sizeColumn, null, new Engine.Worker(){

                    @Override
                    public boolean isCancelled() {
                        return worker.isCancelled();
                    }
                });
                engine.setSigma(0.1);
                engine.run();
                if (worker.isCancelled()) break block9;
                OutputLayerModel output = engine.getOutputMap();
                Java2DConverter outputConverter = this.createConverter(bounds, output.getBounds());
                for (Object node : model.depthFirstIterator(root)) {
                    if (model.hasNoChildren(node)) {
                        Object row = ((AbstractTreeMapNode)node).getRow();
                        Geometry geometry = output.getGeometry(((MTreeMapModel)model).getDataFrame().getRowAddress(row));
                        model.setShape(node, (Shape)new SwingShape(outputConverter.toShape(geometry)));
                        continue;
                    }
                    Area area = new Area();
                    for (Object child : model.getChildren(node)) {
                        Shape shape = model.getShape(child);
                        if (shape == null) continue;
                        area.add(new Area(shape));
                    }
                    model.setShape(node, (Shape)area);
                }
                break block9;
            }
            for (Object node : this.iterator(model, root)) {
                if (node == root) continue;
                model.setShape(node, null);
            }
        }
    }

    private Java2DConverter createConverter(com.macrofocus.geom.Rectangle2D bounds, Rectangle2D b) {
        double sourceWidth = b.getWidth();
        double sourceHeight = b.getHeight();
        double targetWidth = bounds.getWidth();
        double targetHeight = bounds.getHeight();
        double scalex = targetWidth / sourceWidth;
        double scaley = targetHeight / sourceHeight;
        double scale = Math.min(scalex, scaley);
        double newWidth = targetWidth / scale;
        double newHeight = targetHeight / scale;
        double diffWidth = newWidth - sourceWidth;
        double diffHeight = newHeight - sourceHeight;
        double x = b.getX() - diffWidth / 2.0;
        double width = b.getWidth() + diffWidth;
        double y = b.getY() - diffHeight / 2.0;
        double height = b.getHeight() + diffHeight;
        SimpleOneDScreenTransform xCoordinateAxis = new SimpleOneDScreenTransform((BoundedInterval)new SimpleBoundedInterval(x, width, x, x + width), (int)bounds.getWidth());
        SimpleOneDScreenTransform yCoordinateAxis = new SimpleOneDScreenTransform((BoundedInterval)new SimpleBoundedInterval(y, height, y, y + height), (int)bounds.getHeight(), false, true);
        return this.getConverter((OneDScreenTransform)xCoordinateAxis, (OneDScreenTransform)yCoordinateAxis);
    }

    protected com.macrofocus.geom.Rectangle2D computeBounds(TreeMapModel<N, Row, C, Color, Font> model, N root, TreeMapField<N, C> field) {
        RectangularShape bounds = null;
        for (Object node : this.iterator(model, root)) {
            Geometry g = (Geometry)field.getValue(node);
            if (g == null) continue;
            try {
                Envelope e = g.getEnvelopeInternal();
                if (e.isNull()) continue;
                if (bounds != null) {
                    ((Rectangle2D)bounds).add(e.getMinX(), e.getMinY());
                    ((Rectangle2D)bounds).add(e.getMaxX(), e.getMaxY());
                    continue;
                }
                bounds = new Rectangle2D.Double(e.getMinX(), e.getMinY(), e.getWidth(), e.getHeight());
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        return new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    Java2DConverter getConverter(final OneDScreenTransform xCoordinateAxis, final OneDScreenTransform yCoordinateAxis) {
        return new Java2DConverter(new Java2DConverter.PointConverter(){

            @Override
            public Point2D toViewPoint(Coordinate modelCoordinate) {
                return new Point2D.Double(xCoordinateAxis.worldToScreenPrecise(modelCoordinate.x), yCoordinateAxis.worldToScreenPrecise(modelCoordinate.y));
            }

            @Override
            public double getScale() {
                return 1.0;
            }
        }, this.resolution);
    }

    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        return false;
    }

    public boolean isCompatible(Shape shape) {
        return shape instanceof com.macrofocus.geom.Rectangle2D;
    }

    public boolean isSpaceFilling() {
        return false;
    }

    public String toString() {
        return "Cartogram";
    }
}

